/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.net4j.ui.shared.SharedIcons;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IContainerEvent;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.factory.FactoryKey;
import org.eclipse.net4j.util.factory.IFactoryKey;
import org.eclipse.net4j.util.internal.ui.bundle.OM;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.views.ContainerItemProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class ManagedContainerItemProvider
extends ContainerItemProvider<IContainer<Object>> {
    private final IListener containerListener = new ContainerEventAdapter<Object>(){

        protected void notifyContainerEvent(IContainerEvent<Object> event) {
            if (ManagedContainerItemProvider.this.showFactories) {
                ManagedContainerItemProvider.this.refreshViewer(true);
            }
        }
    };
    private final Map<String, ProductGroupWrapper> productGroupWrappers = new HashMap<String, ProductGroupWrapper>();
    private final Map<IFactoryKey, FactoryWrapper> factoryWrappers = new HashMap<IFactoryKey, FactoryWrapper>();
    private boolean showFactories = true;
    private Image productGroupImage;

    public boolean isShowFactories() {
        return this.showFactories;
    }

    public void setShowFactories(boolean showFactories) {
        if (showFactories != this.showFactories) {
            this.showFactories = showFactories;
            this.refreshViewer(true);
        }
    }

    @Override
    public IManagedContainer getInput() {
        return (IManagedContainer)super.getInput();
    }

    @Override
    public boolean hasChildren(Object element) {
        if (this.showFactories) {
            IManagedContainer input = this.getInput();
            if (element == input) {
                return !input.isEmpty();
            }
            if (element instanceof Wrapper) {
                Wrapper wrapper = (Wrapper)element;
                return wrapper.hasChildren();
            }
        }
        return super.hasChildren(element);
    }

    @Override
    public Object[] getChildren(Object element) {
        if (this.showFactories) {
            IManagedContainer input = this.getInput();
            if (element == input) {
                ArrayList result = new ArrayList();
                input.getProductGroups().forEach(productGroup -> {
                    boolean bl = result.add(this.getProductGroupWrapper((String)productGroup));
                });
                result.sort(null);
                return result.toArray();
            }
            if (element instanceof Wrapper) {
                Wrapper wrapper = (Wrapper)element;
                return wrapper.getChildren();
            }
        }
        return super.getChildren(element);
    }

    @Override
    public Object getParent(Object element) {
        if (this.showFactories) {
            IManagedContainer input = this.getInput();
            if (element == input) {
                return null;
            }
            if (element instanceof Wrapper) {
                Wrapper wrapper = (Wrapper)element;
                return wrapper.getParent();
            }
        }
        return super.getParent(element);
    }

    @Override
    public String getText(Object element) {
        if (this.showFactories && element instanceof Wrapper) {
            Wrapper wrapper = (Wrapper)element;
            return wrapper.getText();
        }
        return super.getText(element);
    }

    @Override
    public Image getImage(Object element) {
        if (this.showFactories) {
            if (element instanceof FactoryWrapper) {
                return SharedIcons.getImage((String)"obj16/factory");
            }
            if (element instanceof ProductGroupWrapper) {
                return this.getProductGroupImage();
            }
        }
        return SharedIcons.getImage((String)"obj16/javabean");
    }

    @Override
    public Color getForeground(Object element) {
        Wrapper wrapper;
        if (this.showFactories && element instanceof Wrapper && (wrapper = (Wrapper)element).getElementCount() == 0) {
            return UIUtil.grayColor();
        }
        return super.getForeground(element);
    }

    @Override
    public void dispose() {
        if (this.productGroupImage != null) {
            this.productGroupImage.dispose();
            this.productGroupImage = null;
        }
        super.dispose();
    }

    @Override
    protected void connectInput(IContainer<Object> input) {
        super.connectInput(input);
        input.addListener(this.containerListener);
    }

    @Override
    protected void disconnectInput(IContainer<Object> input) {
        input.removeListener(this.containerListener);
        super.disconnectInput(input);
        this.productGroupWrappers.clear();
        this.factoryWrappers.clear();
    }

    private Image getProductGroupImage() {
        if (this.productGroupImage == null) {
            this.productGroupImage = OM.getImageDescriptor("icons/product_group.gif").createImage();
        }
        return this.productGroupImage;
    }

    private ProductGroupWrapper getProductGroupWrapper(String productGroup) {
        return this.productGroupWrappers.computeIfAbsent(productGroup, k -> new ProductGroupWrapper(productGroup));
    }

    private FactoryWrapper getFactoryWrapper(String productGroup, String factoryType) {
        FactoryKey factoryKey = new FactoryKey(productGroup, factoryType);
        return this.factoryWrappers.computeIfAbsent((IFactoryKey)factoryKey, k -> new FactoryWrapper(productGroup, factoryType));
    }

    private final class FactoryWrapper
    extends Wrapper {
        private final String productGroup;
        private final String factoryType;

        public FactoryWrapper(String productGroup, String factoryType) {
            this.productGroup = productGroup;
            this.factoryType = factoryType;
        }

        @Override
        public boolean hasChildren() {
            return this.getElementCount() != 0;
        }

        @Override
        public Object[] getChildren() {
            return ManagedContainerItemProvider.this.getInput().getElements(this.productGroup, this.factoryType);
        }

        @Override
        public Object getParent() {
            return ManagedContainerItemProvider.this.getProductGroupWrapper(this.productGroup);
        }

        @Override
        public int getElementCount() {
            return ManagedContainerItemProvider.this.getInput().countElements(this.productGroup, this.factoryType);
        }

        @Override
        public String getText() {
            return this.factoryType;
        }
    }

    private final class ProductGroupWrapper
    extends Wrapper {
        private final String productGroup;

        public ProductGroupWrapper(String productGroup) {
            this.productGroup = productGroup;
        }

        @Override
        public boolean hasChildren() {
            return !this.doGetChildren().isEmpty();
        }

        @Override
        public Object[] getChildren() {
            ArrayList result = new ArrayList();
            this.doGetChildren().forEach(factoryType -> {
                boolean bl = result.add(ManagedContainerItemProvider.this.getFactoryWrapper(this.productGroup, (String)factoryType));
            });
            result.sort(null);
            return result.toArray();
        }

        private Set<String> doGetChildren() {
            return ManagedContainerItemProvider.this.getInput().getFactoryTypes(this.productGroup);
        }

        @Override
        public Object getParent() {
            return ManagedContainerItemProvider.this.getInput();
        }

        @Override
        public int getElementCount() {
            return ManagedContainerItemProvider.this.getInput().countElements(this.productGroup);
        }

        @Override
        public String getText() {
            return this.productGroup;
        }
    }

    public abstract class Wrapper
    implements Comparable<Wrapper> {
        protected Wrapper() {
        }

        public abstract boolean hasChildren();

        public abstract Object[] getChildren();

        public abstract Object getParent();

        public abstract int getElementCount();

        public abstract String getText();

        @Override
        public final int compareTo(Wrapper o) {
            String text1 = this.getText();
            String text2 = o.getText();
            return text1 == null ? (text2 == null ? 0 : 1) : text1.compareTo(text2);
        }

        public final String toString() {
            return this.getText();
        }
    }
}

