/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec;

import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.spec.ValidationContext;
import org.eclipse.datatools.connectivity.oda.spec.util.QuerySpecificationHelper;

public abstract class BaseQuery {
    public String getQualifiedId() {
        return this.getClass().getName();
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public void validate() throws OdaException {
        this.validate(null);
    }

    public void validate(ValidationContext context) throws OdaException {
        try {
            this.validateSyntax(context);
            if (context != null && context.getValidator() != null) {
                context.getValidator().validate(this, context);
            }
        }
        catch (OdaException ex) {
            QuerySpecificationHelper.logValidationException(this.getName(), ex);
            throw ex;
        }
    }

    public abstract void validateSyntax(ValidationContext var1) throws OdaException;
}

