/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.hyperlink.dnd;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.Activator;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.SemanticElementHelper;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.TransactionalDropStrategy;
import org.eclipse.papyrus.infra.hyperlink.helper.AbstractHyperLinkHelper;
import org.eclipse.papyrus.infra.hyperlink.helper.IHyperlinkHelperExtension;
import org.eclipse.papyrus.infra.hyperlink.util.HyperLinkHelpersRegistrationUtil;
import org.eclipse.swt.graphics.Image;

public class HyperlinkDropStrategy
extends TransactionalDropStrategy {
    public String getLabel() {
        return "Create hyperlinks";
    }

    public String getDescription() {
        return "Creates an hyperlink to Papyrus nested editor (e.g. Diagram, Table, ...) on a Diagram element";
    }

    public Image getImage() {
        return null;
    }

    public String getID() {
        return "org.eclipse.papyrus.infra.gmfdiag.dnd.CreateHyperlink";
    }

    @Deprecated
    public int getPriority() {
        return 0;
    }

    public org.eclipse.gef.commands.Command doGetCommand(Request request, EditPart targetEditPart) {
        if (request instanceof DropObjectsRequest) {
            View view = this.getTargetView(targetEditPart);
            if (view == null) {
                return null;
            }
            View mainView = SemanticElementHelper.findPrimaryView((EObject)view);
            if (mainView instanceof Diagram) {
                return null;
            }
            DropObjectsRequest dropRequest = (DropObjectsRequest)request;
            ArrayList<Command> hyperlinkCommands = null;
            try {
                ServicesRegistry registry = ServiceUtilsForEObject.getInstance().getServiceRegistry((EObject)mainView);
                Collection helpers = HyperLinkHelpersRegistrationUtil.INSTANCE.getAllRegisteredHyperLinkHelper();
                TransactionalEditingDomain domain = ServiceUtils.getInstance().getTransactionalEditingDomain((Object)registry);
                block2: for (Object droppedObject : dropRequest.getObjects()) {
                    for (AbstractHyperLinkHelper next : helpers) {
                        IHyperlinkHelperExtension helper;
                        Command command;
                        if (!(next instanceof IHyperlinkHelperExtension) || (command = (helper = (IHyperlinkHelperExtension)next).getCreateHyperlinkCommand(domain, (EModelElement)mainView, droppedObject)) == null) continue;
                        if (hyperlinkCommands == null) {
                            hyperlinkCommands = new ArrayList<Command>();
                        }
                        hyperlinkCommands.add(command);
                        continue block2;
                    }
                }
            }
            catch (ServiceException ex) {
                Activator.log.error((Throwable)ex);
            }
            if (hyperlinkCommands != null) {
                final ArrayList<Command> _hyperlinkCommands = hyperlinkCommands;
                return new org.eclipse.gef.commands.Command(){

                    public void execute() {
                        for (Command next : _hyperlinkCommands) {
                            next.execute();
                        }
                    }
                };
            }
        }
        return null;
    }
}

