/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.ui.internal.launch;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.cli.configuration.SettingsXmlConfigurationProcessor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.m2e.actions.MavenLaunchConstants;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.ui.internal.MavenImages;
import org.eclipse.m2e.core.ui.internal.dialogs.MavenPropertyDialog;
import org.eclipse.m2e.internal.launch.LaunchingUtils;
import org.eclipse.m2e.internal.launch.Messages;
import org.eclipse.m2e.ui.internal.launch.MavenRuntimeSelector;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenLaunchMainTab
extends AbstractLaunchConfigurationTab
implements MavenLaunchConstants {
    private static final Logger log = LoggerFactory.getLogger(MavenLaunchMainTab.class);
    public static final String ID_EXTERNAL_TOOLS_LAUNCH_GROUP = "org.eclipse.ui.externaltools.launchGroup";
    protected Text pomDirNameText;
    protected Text goalsText;
    protected Text goalsAutoBuildText;
    protected Text goalsManualBuildText;
    protected Text goalsCleanText;
    protected Text goalsAfterCleanText;
    protected Text profilesText;
    protected Table propsTable;
    private Button offlineButton;
    private Button updateSnapshotsButton;
    private Button debugOutputButton;
    private Button skipTestsButton;
    private Button nonRecursiveButton;
    private Button enableWorkspaceResolution;
    private Button removePropButton;
    private Button editPropButton;
    private Combo threadsCombo;
    private MavenRuntimeSelector runtimeSelector;
    private Text userSettings;

    public Image getImage() {
        return MavenImages.IMG_LAUNCH_MAIN;
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        GridData gridData = new GridData(768);
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)gridData);
        mainComposite.setFont(parent.getFont());
        class Listener
        implements ModifyListener,
        SelectionListener {
            Listener() {
            }

            public void modifyText(ModifyEvent e) {
                MavenLaunchMainTab.this.entriesChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                MavenLaunchMainTab.this.entriesChanged();
            }

            public void widgetSelected(SelectionEvent e) {
                MavenLaunchMainTab.this.entriesChanged();
            }
        }
        Listener modyfyingListener = new Listener();
        Label label = new Label(mainComposite, 0);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 5, 1));
        label.setText(Messages.launchPomGroup);
        this.pomDirNameText = new Text(mainComposite, 2048);
        this.pomDirNameText.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 5, 1));
        this.pomDirNameText.addModifyListener((ModifyListener)modyfyingListener);
        Composite pomDirButtonsComposite = new Composite(mainComposite, 0);
        pomDirButtonsComposite.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 5, 1));
        GridLayout pomDirButtonsGridLayout = new GridLayout();
        pomDirButtonsGridLayout.marginWidth = 0;
        pomDirButtonsGridLayout.marginHeight = 0;
        pomDirButtonsGridLayout.numColumns = 3;
        pomDirButtonsComposite.setLayout((Layout)pomDirButtonsGridLayout);
        Button browseWorkspaceButton = new Button(pomDirButtonsComposite, 0);
        browseWorkspaceButton.setText(Messages.launchBrowseWorkspace);
        browseWorkspaceButton.addSelectionListener((SelectionListener)new BrowseWorkspaceDirAction(this.pomDirNameText, Messages.launchChoosePomDir));
        Button browseFilesystemButton = new Button(pomDirButtonsComposite, 0);
        browseFilesystemButton.setText(Messages.launchBrowseFs);
        browseFilesystemButton.addSelectionListener((SelectionListener)new BrowseDirAction(this.pomDirNameText));
        Button browseVariablesButton = new Button(pomDirButtonsComposite, 0);
        browseVariablesButton.setText(Messages.launchBrowseVariables);
        browseVariablesButton.addSelectionListener((SelectionListener)new VariablesAction(this.pomDirNameText));
        Label goalsLabel = new Label(mainComposite, 0);
        GridData gd_goalsLabel = new GridData();
        gd_goalsLabel.horizontalAlignment = 131072;
        gd_goalsLabel.verticalIndent = 7;
        goalsLabel.setLayoutData((Object)gd_goalsLabel);
        goalsLabel.setText(Messages.launchGoalsLabel);
        this.goalsText = new Text(mainComposite, 2048);
        this.goalsText.setData("name", (Object)"goalsText");
        GridData gd_goalsText = new GridData(4, 0x1000000, true, false, 4, 1);
        gd_goalsText.verticalIndent = 7;
        this.goalsText.setLayoutData((Object)gd_goalsText);
        this.goalsText.addModifyListener((ModifyListener)modyfyingListener);
        this.goalsText.addFocusListener((FocusListener)new GoalsFocusListener(this.goalsText));
        Label profilesLabel = new Label(mainComposite, 0);
        profilesLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        profilesLabel.setText(Messages.launchProfilesLabel);
        this.profilesText = new Text(mainComposite, 2048);
        this.profilesText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        this.profilesText.addModifyListener((ModifyListener)modyfyingListener);
        Label lblUserSettings = new Label(mainComposite, 0);
        lblUserSettings.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblUserSettings.setText(Messages.MavenLaunchMainTab_lblUserSettings_text);
        this.userSettings = new Text(mainComposite, 2048);
        this.userSettings.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        this.userSettings.addModifyListener((ModifyListener)modyfyingListener);
        Composite userSettingsButtonsComposite = new Composite(mainComposite, 0);
        userSettingsButtonsComposite.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 5, 1));
        GridLayout userSettingsButtonsGridLayout = new GridLayout();
        userSettingsButtonsGridLayout.marginWidth = 0;
        userSettingsButtonsGridLayout.marginHeight = 0;
        userSettingsButtonsGridLayout.numColumns = 3;
        userSettingsButtonsComposite.setLayout((Layout)userSettingsButtonsGridLayout);
        Button userSettingsWorkspaceButton = new Button(userSettingsButtonsComposite, 0);
        userSettingsWorkspaceButton.setText(Messages.launchBrowseWorkspace);
        userSettingsWorkspaceButton.addSelectionListener((SelectionListener)new BrowseWorkspaceFileAction(this.userSettings, Messages.launchChooseSettingsFile));
        Button userSettingsFilesystemButton = new Button(userSettingsButtonsComposite, 0);
        userSettingsFilesystemButton.setText(Messages.launchBrowseFs);
        userSettingsFilesystemButton.addSelectionListener((SelectionListener)new BrowseFileAction(this.userSettings, new String[]{"*.xml"}));
        Button userSettingsVariablesButton = new Button(userSettingsButtonsComposite, 0);
        userSettingsVariablesButton.setText(Messages.launchBrowseVariables);
        userSettingsVariablesButton.addSelectionListener((SelectionListener)new VariablesAction(this.userSettings));
        new Label(mainComposite, 0);
        this.offlineButton = new Button(mainComposite, 32);
        this.offlineButton.setToolTipText("-o");
        this.offlineButton.setText(Messages.MavenLaunchMainTab_btnOffline);
        this.offlineButton.addSelectionListener((SelectionListener)modyfyingListener);
        this.updateSnapshotsButton = new Button(mainComposite, 32);
        this.updateSnapshotsButton.setToolTipText("-U");
        this.updateSnapshotsButton.addSelectionListener((SelectionListener)modyfyingListener);
        GridData gd_updateSnapshotsButton = new GridData(16384, 0x1000000, false, false, 3, 1);
        gd_updateSnapshotsButton.horizontalIndent = 10;
        this.updateSnapshotsButton.setLayoutData((Object)gd_updateSnapshotsButton);
        this.updateSnapshotsButton.setText(Messages.MavenLaunchMainTab_btnUpdateSnapshots);
        new Label(mainComposite, 0);
        this.debugOutputButton = new Button(mainComposite, 32);
        this.debugOutputButton.setToolTipText("-X -e");
        this.debugOutputButton.addSelectionListener((SelectionListener)modyfyingListener);
        this.debugOutputButton.setText(Messages.MavenLaunchMainTab_btnDebugOutput);
        this.skipTestsButton = new Button(mainComposite, 32);
        this.skipTestsButton.setToolTipText("-Dmaven.test.skip=true");
        this.skipTestsButton.addSelectionListener((SelectionListener)modyfyingListener);
        GridData gd_skipTestsButton = new GridData();
        gd_skipTestsButton.horizontalIndent = 10;
        this.skipTestsButton.setLayoutData((Object)gd_skipTestsButton);
        this.skipTestsButton.setText(Messages.MavenLaunchMainTab_btnSkipTests);
        this.nonRecursiveButton = new Button(mainComposite, 32);
        GridData gd_nonrecursiveButton = new GridData(16384, 0x1000000, false, false, 2, 1);
        gd_nonrecursiveButton.horizontalIndent = 10;
        this.nonRecursiveButton.setLayoutData((Object)gd_nonrecursiveButton);
        this.nonRecursiveButton.setText(Messages.MavenLaunchMainTab_btnNotRecursive);
        this.nonRecursiveButton.setToolTipText("-N");
        this.nonRecursiveButton.setData("name", (Object)"nonRecursiveButton");
        this.nonRecursiveButton.addSelectionListener((SelectionListener)modyfyingListener);
        new Label(mainComposite, 0);
        this.enableWorkspaceResolution = new Button(mainComposite, 32);
        this.enableWorkspaceResolution.addSelectionListener((SelectionListener)modyfyingListener);
        this.enableWorkspaceResolution.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        this.enableWorkspaceResolution.setData("name", (Object)"enableWorkspaceResolution");
        this.enableWorkspaceResolution.setText(Messages.MavenLaunchMainTab_btnResolveWorkspace);
        int processors = Runtime.getRuntime().availableProcessors();
        new Label(mainComposite, 0);
        Composite composite = new Composite(mainComposite, 0);
        composite.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        this.threadsCombo = new Combo(composite, 2060);
        int i = 1;
        while (i <= processors) {
            this.threadsCombo.add(Integer.toString(i));
            ++i;
        }
        this.threadsCombo.setEnabled(processors > 1);
        this.threadsCombo.addSelectionListener((SelectionListener)modyfyingListener);
        Label threadsLabel = new Label(composite, 0);
        threadsLabel.setText(Messages.MavenLaunchMainTab_lblThreads);
        threadsLabel.setToolTipText("--threads");
        new Label(mainComposite, 0);
        new Label(mainComposite, 0);
        TableViewer tableViewer = new TableViewer(mainComposite, 67586);
        tableViewer.addDoubleClickListener(event -> {
            TableItem[] selection = this.propsTable.getSelection();
            if (selection.length == 1) {
                this.editProperty(selection[0].getText(0), selection[0].getText(1));
            }
        });
        tableViewer.addSelectionChangedListener(event -> {
            TableItem[] items = this.propsTable.getSelection();
            if (items == null || items.length == 0) {
                this.editPropButton.setEnabled(false);
                this.removePropButton.setEnabled(false);
            } else if (items.length == 1) {
                this.editPropButton.setEnabled(true);
                this.removePropButton.setEnabled(true);
            } else {
                this.editPropButton.setEnabled(false);
                this.removePropButton.setEnabled(true);
            }
        });
        this.propsTable = tableViewer.getTable();
        this.propsTable.setLayoutData((Object)new GridData(4, 4, true, true, 4, 3));
        this.propsTable.setLinesVisible(true);
        this.propsTable.setHeaderVisible(true);
        TableColumn propColumn = new TableColumn(this.propsTable, 0, 0);
        propColumn.setWidth(120);
        propColumn.setText(Messages.launchPropName);
        TableColumn valueColumn = new TableColumn(this.propsTable, 0, 1);
        valueColumn.setWidth(200);
        valueColumn.setText(Messages.launchPropValue);
        Button addPropButton = new Button(mainComposite, 0);
        addPropButton.setLayoutData((Object)new GridData(4, 128, false, false));
        addPropButton.setText(Messages.launchPropAddButton);
        addPropButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.addProperty()));
        this.editPropButton = new Button(mainComposite, 0);
        this.editPropButton.setLayoutData((Object)new GridData(4, 128, false, false));
        this.editPropButton.setText(Messages.launchPropEditButton);
        this.editPropButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selection;
                if (MavenLaunchMainTab.this.propsTable.getSelectionCount() > 0 && (selection = MavenLaunchMainTab.this.propsTable.getSelection()).length == 1) {
                    MavenLaunchMainTab.this.editProperty(selection[0].getText(0), selection[0].getText(1));
                }
            }
        });
        this.editPropButton.setEnabled(false);
        this.removePropButton = new Button(mainComposite, 0);
        this.removePropButton.setLayoutData((Object)new GridData(4, 128, false, false));
        this.removePropButton.setText(Messages.launchPropRemoveButton);
        this.removePropButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.propsTable.getSelectionCount() > 0) {
                this.propsTable.remove(this.propsTable.getSelectionIndices());
                this.entriesChanged();
            }
        }));
        this.removePropButton.setEnabled(false);
        Label mavenRuntimeLabel = new Label(mainComposite, 0);
        mavenRuntimeLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        mavenRuntimeLabel.setText(Messages.MavenLaunchMainTab_lblRuntime);
        this.runtimeSelector = new MavenRuntimeSelector(mainComposite);
        this.runtimeSelector.setLayoutData(new GridData(4, 0x1000000, false, false, 4, 1));
        this.runtimeSelector.addSelectionChangedListener(event -> this.entriesChanged());
        this.goalsText.setFocus();
    }

    protected Shell getShell() {
        return super.getShell();
    }

    void addProperty() {
        MavenPropertyDialog dialog = this.getMavenPropertyDialog(Messages.MavenLaunchMainTab_property_dialog_title, "", "");
        if (dialog.open() == 0) {
            TableItem item = new TableItem(this.propsTable, 0);
            item.setText(0, dialog.getName());
            item.setText(1, dialog.getValue());
            this.entriesChanged();
        }
    }

    void editProperty(String name, String value) {
        MavenPropertyDialog dialog = this.getMavenPropertyDialog(Messages.MavenLaunchMainTab_property_dialog_edit_title, name, value);
        if (dialog.open() == 0) {
            TableItem[] item = this.propsTable.getSelection();
            item[0].setText(0, dialog.getName());
            item[0].setText(1, dialog.getValue());
            this.entriesChanged();
        }
    }

    private MavenPropertyDialog getMavenPropertyDialog(String title, String initName, String initValue) {
        return new MavenPropertyDialog(this.getShell(), title, initName, initValue, null){

            protected Control createDialogArea(Composite parent) {
                Composite comp = (Composite)super.createDialogArea(parent);
                Button variablesButton = new Button(comp, 8);
                GridData gd = new GridData(128);
                gd.horizontalSpan = 2;
                gd.widthHint = Math.max(this.convertHorizontalDLUsToPixels(61), variablesButton.computeSize((int)-1, (int)-1, (boolean)true).x);
                variablesButton.setLayoutData((Object)gd);
                variablesButton.setFont(comp.getFont());
                variablesButton.setText(Messages.launchPropertyDialogBrowseVariables);
                variablesButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                    String variable;
                    StringVariableSelectionDialog variablesDialog = new StringVariableSelectionDialog(this.getShell());
                    if (variablesDialog.open() == 0 && (variable = variablesDialog.getVariableExpression()) != null) {
                        this.valueText.insert(variable.trim());
                    }
                }));
                return comp;
            }
        };
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        String pomDirName = this.getAttribute(configuration, ATTR_POM_DIR, "");
        this.pomDirNameText.setText(pomDirName);
        this.goalsText.setText(this.getAttribute(configuration, "M2_GOALS", ""));
        this.profilesText.setText(this.getAttribute(configuration, "M2_PROFILES", ""));
        try {
            IMavenConfiguration mavenConfiguration = MavenPlugin.getMavenConfiguration();
            this.offlineButton.setSelection(this.getAttribute(configuration, "M2_OFFLINE", mavenConfiguration.isOffline()));
            this.debugOutputButton.setSelection(this.getAttribute(configuration, "M2_DEBUG_OUTPUT", mavenConfiguration.isDebugOutput()));
            this.updateSnapshotsButton.setSelection(this.getAttribute(configuration, "M2_UPDATE_SNAPSHOTS", false));
            this.skipTestsButton.setSelection(this.getAttribute(configuration, "M2_SKIP_TESTS", false));
            this.nonRecursiveButton.setSelection(this.getAttribute(configuration, "M2_NON_RECURSIVE", false));
            this.enableWorkspaceResolution.setSelection(this.getAttribute(configuration, "M2_WORKSPACE_RESOLUTION", false));
            this.threadsCombo.select(this.getAttribute(configuration, "M2_THREADS", 1) - 1);
            this.runtimeSelector.initializeFrom(configuration);
            this.userSettings.setText(this.getAttribute(configuration, "M2_USER_SETTINGS", ""));
            this.userSettings.setMessage(MavenLaunchMainTab.nvl(mavenConfiguration.getUserSettingsFile(), SettingsXmlConfigurationProcessor.DEFAULT_USER_SETTINGS_FILE.getAbsolutePath()));
            this.propsTable.removeAll();
            List properties = configuration.getAttribute("M2_PROPERTIES", Collections.emptyList());
            for (String property : properties) {
                int n = property.indexOf(61);
                String name = property;
                String value = "";
                if (n > -1) {
                    name = property.substring(0, n);
                    if (n > 1) {
                        value = property.substring(n + 1);
                    }
                }
                TableItem item = new TableItem(this.propsTable, 0);
                item.setText(0, name);
                item.setText(1, value);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.setDirty(false);
    }

    protected static String nvl(String str, String nullValue) {
        return str != null ? str : nullValue;
    }

    private String getAttribute(ILaunchConfiguration configuration, String name, String defaultValue) {
        try {
            return configuration.getAttribute(name, defaultValue);
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return defaultValue;
        }
    }

    private boolean getAttribute(ILaunchConfiguration configuration, String name, boolean defaultValue) {
        try {
            return configuration.getAttribute(name, defaultValue);
        }
        catch (CoreException ex) {
            return defaultValue;
        }
    }

    private int getAttribute(ILaunchConfiguration configuration, String name, int defaultValue) {
        try {
            return configuration.getAttribute(name, defaultValue);
        }
        catch (CoreException ex) {
            return defaultValue;
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(ATTR_POM_DIR, this.pomDirNameText.getText());
        configuration.setAttribute("M2_GOALS", this.goalsText.getText());
        configuration.setAttribute("M2_PROFILES", this.profilesText.getText());
        configuration.setAttribute("M2_USER_SETTINGS", this.userSettings.getText());
        configuration.setAttribute("M2_OFFLINE", this.offlineButton.getSelection());
        configuration.setAttribute("M2_UPDATE_SNAPSHOTS", this.updateSnapshotsButton.getSelection());
        configuration.setAttribute("M2_SKIP_TESTS", this.skipTestsButton.getSelection());
        configuration.setAttribute("M2_NON_RECURSIVE", this.nonRecursiveButton.getSelection());
        configuration.setAttribute("M2_WORKSPACE_RESOLUTION", this.enableWorkspaceResolution.getSelection());
        configuration.setAttribute("M2_DEBUG_OUTPUT", this.debugOutputButton.getSelection());
        this.runtimeSelector.performApply(configuration);
        configuration.setAttribute("M2_THREADS", this.threadsCombo.getSelectionIndex() + 1);
        ArrayList<String> properties = new ArrayList<String>();
        TableItem[] tableItemArray = this.propsTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            String p = item.getText(0);
            String v = item.getText(1);
            if (p != null && p.trim().length() > 0) {
                String prop = String.valueOf(p.trim()) + "=" + (v == null ? "" : v);
                properties.add(prop);
            }
            ++n2;
        }
        configuration.setAttribute("M2_PROPERTIES", properties);
    }

    public String getName() {
        return Messages.launchMainTabName;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        String pomFileName = this.pomDirNameText.getText();
        if (pomFileName == null || pomFileName.trim().length() == 0) {
            this.setErrorMessage(Messages.launchPomDirectoryEmpty);
            return false;
        }
        if (!this.isDirectoryExist(pomFileName)) {
            if (this.getErrorMessage() == null) {
                this.setErrorMessage(Messages.launchPomDirectoryDoesntExist);
            }
            return false;
        }
        return true;
    }

    protected boolean isDirectoryExist(String name) {
        File pomDir;
        block6: {
            String dirName;
            block5: {
                if (name == null || name.trim().length() == 0) {
                    return false;
                }
                try {
                    dirName = LaunchingUtils.substituteVar(name);
                    if (dirName != null) break block5;
                    return false;
                }
                catch (CoreException e) {
                    this.setErrorMessage(Messages.launchErrorEvaluatingBaseDirectory);
                    return false;
                }
            }
            pomDir = new File(dirName);
            if (pomDir.exists()) break block6;
            return false;
        }
        return pomDir.isDirectory();
    }

    void entriesChanged() {
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    }

    private class BrowseDirAction
    extends SelectionAdapter {
        private Text target;

        public BrowseDirAction(Text target) {
            this.target = target;
        }

        public void widgetSelected(SelectionEvent e) {
            DirectoryDialog dialog = new DirectoryDialog(MavenLaunchMainTab.this.getShell(), 0);
            dialog.setFilterPath(this.target.getText());
            String text = dialog.open();
            if (text != null) {
                this.target.setText(text);
                MavenLaunchMainTab.this.entriesChanged();
            }
        }
    }

    private class BrowseFileAction
    extends SelectionAdapter {
        private Text target;
        private String[] filter;

        public BrowseFileAction(Text target, String[] filter) {
            this.target = target;
            this.filter = filter;
        }

        public void widgetSelected(SelectionEvent e) {
            FileDialog dialog = new FileDialog(MavenLaunchMainTab.this.getShell(), 0);
            dialog.setFilterPath(this.target.getText());
            dialog.setFilterExtensions(this.filter);
            String text = dialog.open();
            if (text != null) {
                this.target.setText(text);
                MavenLaunchMainTab.this.entriesChanged();
            }
        }
    }

    private class BrowseWorkspaceDirAction
    extends SelectionAdapter {
        private Text target;
        private String label;

        public BrowseWorkspaceDirAction(Text target, String label) {
            this.target = target;
            this.label = label;
        }

        public void widgetSelected(SelectionEvent e) {
            Object[] resource;
            ContainerSelectionDialog dialog = new ContainerSelectionDialog(MavenLaunchMainTab.this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, this.label);
            dialog.showClosedProjects(false);
            int buttonId = dialog.open();
            if (buttonId == 0 && (resource = dialog.getResult()) != null && resource.length > 0) {
                String fileLoc = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", ((IPath)resource[0]).toString());
                this.target.setText(fileLoc);
                MavenLaunchMainTab.this.entriesChanged();
            }
        }
    }

    private class BrowseWorkspaceFileAction
    extends SelectionAdapter {
        private Text target;
        private String label;

        public BrowseWorkspaceFileAction(Text target, String label) {
            this.target = target;
            this.label = label;
        }

        public void widgetSelected(SelectionEvent e) {
            Object[] resource;
            ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(MavenLaunchMainTab.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
            dialog.setTitle(this.label);
            dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            int buttonId = dialog.open();
            if (buttonId == 0 && (resource = dialog.getResult()) != null && resource.length > 0) {
                String fileLoc = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", ((IResource)resource[0]).getFullPath().toString());
                this.target.setText(fileLoc);
                MavenLaunchMainTab.this.entriesChanged();
            }
        }
    }

    private static final class GoalsFocusListener
    extends FocusAdapter {
        private Text text;

        public GoalsFocusListener(Text text) {
            this.text = text;
        }

        public void focusGained(FocusEvent e) {
            super.focusGained(e);
            this.text.setData((Object)"focus");
        }
    }

    private class VariablesAction
    extends SelectionAdapter {
        private Text target;

        public VariablesAction(Text target) {
            this.target = target;
        }

        public void widgetSelected(SelectionEvent e) {
            StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(MavenLaunchMainTab.this.getShell());
            dialog.open();
            String variable = dialog.getVariableExpression();
            if (variable != null) {
                this.target.insert(variable);
            }
        }
    }
}

