/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.delete;

import java.util.List;
import javax.persistence.EntityManager;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.CalcTypes;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.ui.rcp.controllers.IEditorOperation;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractJBEditor;
import org.eclipse.jubula.client.ui.rcp.handlers.delete.AbstractDeleteTreeItemHandler;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteTreeItemHandlerTCEditor
extends AbstractDeleteTreeItemHandler {
    public Object executeImpl(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof AbstractJBEditor) {
            final AbstractJBEditor tce = (AbstractJBEditor)activePart;
            tce.getEditorHelper().doEditorOperation(new IEditorOperation(){

                @Override
                public void run(IPersistentObject workingPo) {
                    IStructuredSelection structuredSelection = DeleteTreeItemHandlerTCEditor.this.getSelection();
                    if (DeleteTreeItemHandlerTCEditor.this.confirmDelete(structuredSelection)) {
                        DeleteTreeItemHandlerTCEditor.deleteNodesFromEditor(structuredSelection.toList(), tce);
                    }
                }
            });
        }
        return null;
    }

    public static void deleteNodesFromEditor(List<? extends INodePO> nodes, AbstractJBEditor editor) {
        editor.getEditorHelper().getClipboard().clearContents();
        EditSupport supp = editor.getEditorHelper().getEditSupport();
        IWritableComponentNameCache localCache = supp.getCache();
        for (INodePO iNodePO : nodes) {
            DeleteTreeItemHandlerTCEditor.deleteNode(iNodePO, editor.getEntityManager());
        }
        editor.getEditorHelper().setDirty(true);
        CalcTypes calcTypes = new CalcTypes((IComponentNameCache)localCache, (INodePO)supp.getWorkVersion());
        calcTypes.calculateTypes();
        localCache.storeLocalProblems(calcTypes);
    }

    private static void deleteNode(INodePO node, EntityManager sess) {
        node.getParentNode().removeNode(node);
        if (node.getId() != null) {
            sess.remove((Object)node);
        }
        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)node, DataEventDispatcher.DataState.Deleted, DataEventDispatcher.UpdateState.onlyInEditor);
    }
}

