/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.util.List;
import org.eclipse.jubula.client.core.utils.IParamValueToken;
import org.eclipse.jubula.client.core.utils.IParamValueValidator;
import org.eclipse.jubula.client.core.utils.ParamValueConverter;
import org.eclipse.jubula.client.core.utils.SimpleValueToken;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;

public class IntegerParamValueValidator
implements IParamValueValidator {
    private static final String MINUS = "-";
    private int m_minVal;
    private int m_maxVal;
    private int[] m_valuesSet;

    public IntegerParamValueValidator(int minVal, int maxVal, String[] valuesSet) {
        this.m_minVal = minVal;
        this.m_maxVal = maxVal;
        if (valuesSet != null && valuesSet.length > 0) {
            this.m_valuesSet = new int[valuesSet.length];
            int i = 0;
            while (i < valuesSet.length) {
                try {
                    this.m_valuesSet[i] = Integer.parseInt(valuesSet[i]);
                }
                catch (NumberFormatException numberFormatException) {
                    this.m_valuesSet[i] = Integer.MIN_VALUE;
                }
                ++i;
            }
        } else {
            this.m_valuesSet = null;
        }
    }

    @Override
    public ParamValueConverter.ConvValidationState validateInput(List<IParamValueToken> tokens) {
        ParamValueConverter.ConvValidationState val;
        block16: {
            val = ParamValueConverter.ConvValidationState.valid;
            if (tokens.size() == 1) {
                IParamValueToken token = tokens.get(0);
                if (token instanceof SimpleValueToken) {
                    String value = token.getGuiString();
                    if (value.startsWith(MINUS) && value.length() == 1) {
                        val = ParamValueConverter.ConvValidationState.undecided;
                        return val;
                    }
                    try {
                        int n = Integer.parseInt(value);
                        if (n >= this.m_minVal && n <= this.m_maxVal) {
                            boolean valuesOK;
                            if (this.m_valuesSet != null) {
                                valuesOK = false;
                                int i = 0;
                                while (i < this.m_valuesSet.length) {
                                    int candidate = this.m_valuesSet[i];
                                    if (n == candidate) {
                                        valuesOK = true;
                                        break;
                                    }
                                    ++i;
                                }
                            } else {
                                valuesOK = true;
                            }
                            if (valuesOK) {
                                val = ParamValueConverter.ConvValidationState.valid;
                            } else {
                                val = ParamValueConverter.ConvValidationState.invalid;
                                token.setErrorKey(MessageIDs.E_NOT_SUPP_COMBO_ITEM);
                            }
                            break block16;
                        }
                        if (n > this.m_maxVal) {
                            val = ParamValueConverter.ConvValidationState.invalid;
                            token.setErrorKey(MessageIDs.E_TOO_BIG_VALUE);
                            break block16;
                        }
                        val = ParamValueConverter.ConvValidationState.invalid;
                        token.setErrorKey(MessageIDs.E_TOO_SMALL_VALUE);
                    }
                    catch (NumberFormatException numberFormatException) {
                        val = ParamValueConverter.ConvValidationState.invalid;
                        token.setErrorKey(MessageIDs.E_BAD_INT);
                    }
                }
            } else {
                val = ParamValueConverter.ConvValidationState.invalid;
                if (tokens.size() != 0) {
                    tokens.get(0).setErrorKey(MessageIDs.E_BAD_INT);
                }
            }
        }
        return val;
    }
}

