/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.snippet;

import java.util.Arrays;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.completion.LSCompletionProposal;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class Snippet {
    private String[] replacementLines;
    private String display;
    private CompletionItemKind kind;

    public Snippet(String display, CompletionItemKind kind, String[] replacementLines) {
        this.replacementLines = replacementLines == null ? null : Arrays.copyOf(replacementLines, replacementLines.length);
        this.display = display;
        this.kind = kind;
    }

    public ICompletionProposal convertToCompletionProposal(int offset, LanguageServiceAccessor.LSPDocumentInfo info, String prefix, String lineIndentation) {
        CompletionItem item = new CompletionItem();
        item.setLabel(this.display);
        item.setKind(this.kind);
        item.setInsertTextFormat(InsertTextFormat.Snippet);
        Range r = null;
        try {
            int line = info.getDocument().getLineOfOffset(offset);
            int lineOffset = offset - info.getDocument().getLineOffset(line);
            r = new Range(new Position(line, lineOffset - prefix.length()), new Position(line, lineOffset));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (r == null) {
            return null;
        }
        item.setTextEdit(new TextEdit(r, this.createReplacement(lineIndentation)));
        return new LSCompletionProposal(info.getDocument(), offset, item, info.getLanguageClient());
    }

    public boolean matchesPrefix(String prefix) {
        return this.display.startsWith(prefix);
    }

    private String createReplacement(String lineIndentation) {
        StringBuilder responseBuilder = new StringBuilder();
        if (this.replacementLines.length == 1) {
            return this.replacementLines[0];
        }
        if (this.replacementLines.length > 1) {
            String[] stringArray = this.replacementLines;
            int n = this.replacementLines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (responseBuilder.length() == 0) {
                    responseBuilder.append(line);
                } else {
                    responseBuilder.append('\n');
                    responseBuilder.append(lineIndentation);
                    responseBuilder.append(line);
                }
                ++n2;
            }
        }
        return responseBuilder.toString();
    }
}

