/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.meta.commands.clipboard;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.CutToClipboardCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jwt.meta.PluginProperties;
import org.eclipse.jwt.meta.commands.helper.CommandHelper;
import org.eclipse.jwt.meta.commands.interfaces.IInterruptibleCommand;
import org.eclipse.jwt.meta.model.core.Package;
import org.eclipse.jwt.meta.model.processes.ActivityEdge;

public class JWTCutToClipboardCommand
extends CutToClipboardCommand
implements IInterruptibleCommand {
    public JWTCutToClipboardCommand(EditingDomain domain, Command command) {
        super(domain, command);
    }

    protected Set getAllRemoveCommandsRecursively(Command command) {
        HashSet<Command> commands = new HashSet<Command>();
        if (command instanceof CompoundCommand) {
            Iterator iteratorC = ((CompoundCommand)command).getCommandList().iterator();
            while (iteratorC.hasNext()) {
                commands.addAll(this.getAllRemoveCommandsRecursively((Command)iteratorC.next()));
            }
        } else if (command instanceof RemoveCommand) {
            commands.add(command);
        }
        return commands;
    }

    public boolean checkIfCommandCanBeExecuted() {
        HashSet relevantElements = new HashSet();
        Set removeCommands = this.getAllRemoveCommandsRecursively(this.command);
        for (RemoveCommand removeCommand : removeCommands) {
            for (EObject object : removeCommand.getCollection()) {
                relevantElements.addAll(CommandHelper.collectRelevantElements(object));
            }
        }
        Package rootPackage = null;
        if (relevantElements.size() <= 0) {
            return true;
        }
        rootPackage = (Package)CommandHelper.getRoot((EObject)relevantElements.iterator().next());
        Set referencedElements = CommandHelper.collectReferencedElements(relevantElements, rootPackage, false);
        if (referencedElements.size() == 0) {
            return true;
        }
        String refNameString = "\n\n" + CommandHelper.collectNames(referencedElements);
        MessageDialog.openInformation(null, (String)PluginProperties.editor_StillReferenced_title, (String)PluginProperties.bind((String)PluginProperties.editor_StillReferenced_message, (Object)refNameString));
        return false;
    }

    private Set getAffectedObjectsForClipboard() {
        Set removeCommands = this.getAllRemoveCommandsRecursively(this.command);
        HashSet<EObject> affectedObjects = new HashSet<EObject>();
        for (RemoveCommand removeCommand : removeCommands) {
            for (EObject object : removeCommand.getCollection()) {
                if (object instanceof ActivityEdge) continue;
                affectedObjects.add(object);
            }
        }
        affectedObjects.addAll(CommandHelper.getAffectedEdges(affectedObjects));
        return affectedObjects;
    }

    public void execute() {
        Set affectedObjects = this.getAffectedObjectsForClipboard();
        if (this.domain != null) {
            this.oldClipboard = this.domain.getClipboard();
            Collection copy = EcoreUtil.copyAll((Collection)affectedObjects);
            this.domain.setClipboard(copy);
        }
        if (this.command != null) {
            this.command.execute();
        }
    }

    public void redo() {
        Set affectedObjects = this.getAffectedObjectsForClipboard();
        if (this.domain != null) {
            this.oldClipboard = this.domain.getClipboard();
            Collection copy = EcoreUtil.copyAll((Collection)affectedObjects);
            this.domain.setClipboard(copy);
        }
        if (this.command != null) {
            this.command.redo();
        }
    }
}

