/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.alm.mylyn.ui.dialogs;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jubula.client.alm.mylyn.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.views.ColumnViewerSorter;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class InspectALMAttributesDialog
extends TitleAreaDialog {
    private TaskAttribute m_taskAttribute;

    public InspectALMAttributesDialog(Shell parentShell, TaskAttribute taskAttribute) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.m_taskAttribute = taskAttribute;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.InspectorTitle);
        this.setMessage(Messages.InspectorMessage);
        this.getShell().setText(Messages.InspectorTitle);
        parent.setLayout((Layout)new GridLayout());
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout());
        TableViewer tableViewer = this.createTableViewer(content);
        this.createAttributeIDColumn(tableViewer);
        this.createValueColumn(tableViewer);
        this.createOptionsColumn(tableViewer);
        this.createPropertiesColumn(tableViewer);
        tableViewer.setInput((Object)this.m_taskAttribute.getAttributes());
        GridData tableViewerGD = new GridData(4, 4, true, true);
        tableViewerGD.horizontalSpan = 2;
        tableViewer.getControl().setLayoutData((Object)tableViewerGD);
        GridData contentGD = new GridData(4, 4, true, true);
        contentGD.heightHint = 600;
        content.setLayoutData((Object)contentGD);
        return parent;
    }

    private TableViewer createTableViewer(Composite parent) {
        TableViewer tableViewer = new TableViewer(parent, 2816);
        this.changeTableOptions(tableViewer);
        tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Map) {
                    Map a = (Map)inputElement;
                    ArrayList<KeyValue<TaskAttribute>> list = new ArrayList<KeyValue<TaskAttribute>>();
                    for (String attributeID : a.keySet()) {
                        list.add(new KeyValue<TaskAttribute>(attributeID, (TaskAttribute)a.get(attributeID)));
                    }
                    return list.toArray();
                }
                return null;
            }
        });
        return tableViewer;
    }

    private void changeTableOptions(TableViewer tableViewer) {
        final Table table = tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if ((e.stateMask & SWT.MOD1) == SWT.MOD1 && e.keyCode == 99 && table.getSelectionCount() > 0) {
                    Clipboard cb = new Clipboard(Display.getDefault());
                    TextTransfer textTransfer = TextTransfer.getInstance();
                    cb.setContents(new Object[]{table.getSelection()[0].getText()}, new Transfer[]{textTransfer});
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
    }

    private void createAttributeIDColumn(TableViewer tableViewer) {
        TableViewerColumn colAttributeID = new TableViewerColumn(tableViewer, 0);
        colAttributeID.getColumn().setWidth(250);
        colAttributeID.getColumn().setText(Messages.InspectorTableAttributeID);
        colAttributeID.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                KeyValue p = (KeyValue)element;
                return p.getKey();
            }
        });
        ColumnViewerSorter sorter = new ColumnViewerSorter((ColumnViewer)tableViewer, colAttributeID){

            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return InspectALMAttributesDialog.this.getCommonsComparator().compare(((KeyValue)e1).getKey(), ((KeyValue)e2).getKey());
            }
        };
        sorter.setSorter(1);
    }

    private void createValueColumn(TableViewer tableViewer) {
        TableViewerColumn value = new TableViewerColumn(tableViewer, 0);
        value.getColumn().setWidth(200);
        value.getColumn().setText(Messages.InspectorTableValue);
        value.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                KeyValue p = (KeyValue)element;
                return ((TaskAttribute)p.m_value).getValue();
            }
        });
        new ColumnViewerSorter((ColumnViewer)tableViewer, value){

            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return InspectALMAttributesDialog.this.getCommonsComparator().compare(((TaskAttribute)((KeyValue)e1).getValue()).getValue(), ((TaskAttribute)((KeyValue)e2).getValue()).getValue());
            }
        };
    }

    private void createOptionsColumn(TableViewer tableViewer) {
        TableViewerColumn options = new TableViewerColumn(tableViewer, 0);
        options.getColumn().setWidth(300);
        options.getColumn().setText(Messages.InspecotrTableOptions);
        options.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                KeyValue p = (KeyValue)element;
                String text = ((TaskAttribute)p.getValue()).getOptions().toString();
                text = StringUtils.substring((String)text, (int)1, (int)(text.length() - 1));
                return text;
            }
        });
        new ColumnViewerSorter((ColumnViewer)tableViewer, options){

            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                return InspectALMAttributesDialog.this.getCommonsComparator().compare(((TaskAttribute)((KeyValue)e1).getValue()).getOptions().toString(), ((TaskAttribute)((KeyValue)e2).getValue()).getOptions().toString());
            }
        };
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer);
    }

    private void createPropertiesColumn(TableViewer tableViewer) {
        TableViewerColumn propertiesColumn = new TableViewerColumn(tableViewer, 0);
        propertiesColumn.getColumn().setWidth(120);
        propertiesColumn.getColumn().setText(Messages.InspectorTableProperties);
        propertiesColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                KeyValue p = (KeyValue)element;
                String returnValue = "";
                if (((TaskAttribute)p.m_value).getMetaData().isReadOnly()) {
                    returnValue = String.valueOf(returnValue) + Messages.InspectorTablePropertieReadOnly;
                }
                if (((TaskAttribute)p.m_value).getMetaData().isDisabled()) {
                    returnValue = returnValue.length() == 0 ? String.valueOf(returnValue) + Messages.InspectorTablePropertieDisabled : String.valueOf(returnValue) + ", " + Messages.InspectorTablePropertieDisabled;
                }
                return returnValue;
            }
        });
    }

    private Comparator getCommonsComparator() {
        return ComparatorUtils.nullHighComparator((Comparator)ComparatorUtils.naturalComparator());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }

    private class KeyValue<E> {
        private String m_key;
        private E m_value;

        public KeyValue(String key, E value) {
            this.m_key = key;
            this.m_value = value;
        }

        public String getKey() {
            return this.m_key;
        }

        public E getValue() {
            return this.m_value;
        }
    }
}

