/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.common.commands;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.autagent.common.AutStarter;
import org.eclipse.jubula.autagent.common.commands.AbstractStartJavaAut;
import org.eclipse.jubula.autagent.common.commands.AbstractStartToolkitAut;
import org.eclipse.jubula.communication.internal.Communicator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStartJavaAutServer
extends AbstractStartJavaAut {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractStartJavaAutServer.class);
    private static final String ENV_SEPARATOR = "\n";

    protected abstract String getRcBundleClassPath();

    protected void setEnv(Map<String, String> parameters, String autServerClasspath) {
        String env = parameters.get("ENVIRONMENT");
        env = env == null ? "" : String.valueOf(env) + ENV_SEPARATOR;
        env = String.valueOf(env) + this.setJavaOptions(parameters);
        if (this.isRunningFromExecutable(parameters)) {
            String serverPort = "null";
            Communicator autCommunicator = AutStarter.getInstance().getAutCommunicator();
            if (autCommunicator != null) {
                serverPort = String.valueOf(autCommunicator.getLocalPort());
            }
            env = String.valueOf(env) + "\nAUT_SERVER_PORT=" + serverPort;
            env = String.valueOf(env) + "\nAUT_SERVER_CLASSPATH=" + autServerClasspath;
            env = String.valueOf(env) + "\nAUT_SERVER_NAME=" + this.getServerClassName();
            env = String.valueOf(env) + "\norg.eclipse.jubula.STARTED_ROOT_DIRECTORY=" + AbstractStartJavaAutServer.getInstallDir();
            env = String.valueOf(env) + "\ncom.bredexsw.guidancer.aut.register.autAgentHost=" + parameters.get("com.bredexsw.guidancer.aut.register.autAgentHost");
            env = String.valueOf(env) + "\ncom.bredexsw.guidancer.aut.register.autAgentPort=" + parameters.get("com.bredexsw.guidancer.aut.register.autAgentPort");
            env = String.valueOf(env) + "\ncom.bredexsw.guidancer.aut.register.autName=" + parameters.get("com.bredexsw.guidancer.aut.register.autName");
        }
        parameters.put("ENVIRONMENT", env);
    }

    public String[] getLaunchClasspath() {
        StringBuffer autServerClasspath = new StringBuffer();
        this.createServerClasspath(autServerClasspath);
        autServerClasspath.append(PATH_SEPARATOR).append(this.getRcBundleClassPath());
        return autServerClasspath.toString().split(PATH_SEPARATOR);
    }

    protected void createServerClasspath(StringBuffer serverClasspath) {
        String[] bundlesToAddToClasspath;
        String[] stringArray = bundlesToAddToClasspath = new String[]{"org.eclipse.jubula.tools", "org.eclipse.jubula.tools.exec", "org.eclipse.jubula.communication", "org.eclipse.jubula.rc.common", "org.eclipse.jubula.toolkit.api", "org.slf4j.jcl", "org.slf4j.api", "org.apache.commons.lang", "org.apache.commons.io", "org.apache.commons.exec", "org.apache.oro", "org.apache.commons.beanutils", "org.apache.commons.collections", "ch.qos.logback.classic", "ch.qos.logback.core", "ch.qos.logback.slf4j", "com.thoughtworks.xstream", "org.xmlpull"};
        int n = bundlesToAddToClasspath.length;
        int n2 = 0;
        while (n2 < n) {
            String bundleId = stringArray[n2];
            serverClasspath.append(AbstractStartToolkitAut.getClasspathForBundleId(bundleId));
            serverClasspath.append(PATH_SEPARATOR);
            ++n2;
        }
        serverClasspath.append(this.getAbsExtImplClassesPath());
        if (LOG.isDebugEnabled()) {
            LOG.debug("serverClasspath" + serverClasspath);
        }
    }

    protected String getAbsExtImplClassesPath() {
        File implDir = new File("./lib/extImplClasses");
        StringBuffer paths = new StringBuffer(implDir.getAbsolutePath());
        File[] jars = implDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        if (jars != null) {
            int maxIdx = jars.length;
            int i = 0;
            while (i < maxIdx) {
                File f = jars[i];
                paths.append(PATH_SEPARATOR);
                paths.append(f.getAbsolutePath());
                ++i;
            }
        }
        return paths.toString();
    }

    protected void createAutServerClasspath(StringBuffer autServerClasspath, List<String> cmds, Map<String, String> parameters) {
        Communicator autCommunicator = AutStarter.getInstance().getAutCommunicator();
        if (autCommunicator != null) {
            cmds.add(String.valueOf(autCommunicator.getLocalPort()));
        } else {
            cmds.add("null");
        }
        String autMain = this.getAUTMainClass(parameters);
        if (autMain == null) {
            return;
        }
        cmds.add(autMain);
        autServerClasspath.append(PATH_SEPARATOR).append(this.getRcBundleClassPath());
        cmds.add(autServerClasspath.toString());
        cmds.add(this.getServerClassName());
    }

    protected String createServerBasePath() {
        return AbstractStartToolkitAut.getClasspathForBundleId("org.eclipse.jubula.rc.common");
    }

    protected List<String> createAutArguments(Map<String, String> parameters) {
        Vector<String> argsList = new Vector<String>();
        String joinedAutRunArgs = parameters.get("AUT_RUN_AUT_ARGUMENTS");
        if (joinedAutRunArgs != null) {
            return Arrays.asList(StringUtils.split((String)joinedAutRunArgs, (char)'?'));
        }
        this.processAutRunArguments(parameters, argsList);
        return argsList;
    }

    private void processAutRunArguments(Map<String, String> parameters, List<String> argsList) {
        String autArguments = parameters.get("AUT_ARGUMENTS");
        if (autArguments == null) {
            autArguments = "";
        }
        String delimiterString = "%_";
        String[] quotedParts = StringUtils.substringsBetween((String)autArguments, (String)"\"", (String)"\"");
        if (quotedParts != null) {
            String[] stringArray = quotedParts;
            int n = quotedParts.length;
            int n2 = 0;
            while (n2 < n) {
                String quotedPart = stringArray[n2];
                String escapedQuotePart = new String(quotedPart);
                escapedQuotePart = escapedQuotePart.replaceAll("\\s+", delimiterString);
                autArguments = autArguments.replace(quotedPart, escapedQuotePart);
                ++n2;
            }
        }
        StringTokenizer args = new StringTokenizer(autArguments, " ");
        while (args.hasMoreTokens()) {
            String arg = args.nextToken();
            if (arg.contains(delimiterString)) {
                arg = arg.replaceAll(delimiterString, " ").replaceAll("\"", "");
            }
            argsList.add(arg);
        }
    }

    protected void createAutServerLauncherClasspath(List<String> cmds, StringBuffer autServerClasspath, Map<String, String> parameters) {
        this.addBaseSettings(cmds, parameters);
        cmds.add("-classpath");
        StringBuffer autClassPath = this.createAutClasspath(parameters);
        String serverBasePath = this.createServerBasePath();
        cmds.add(autClassPath.append(PATH_SEPARATOR).append(serverBasePath).toString());
        cmds.add("org.eclipse.jubula.rc.common.AutServerLauncher");
        autServerClasspath.append(PATH_SEPARATOR).append(serverBasePath);
    }

    protected void addBaseSettings(List<String> cmds, Map<String, String> parameters) {
        this.addLocale(cmds, LocaleUtils.toLocale((String)parameters.get("AUT_LOCALE")));
        String jreParams = parameters.get("JRE_PARAMETER");
        if (jreParams != null && jreParams.length() > 0) {
            StringTokenizer tok = new StringTokenizer(jreParams, " ");
            while (tok.hasMoreTokens()) {
                cmds.add(tok.nextToken());
            }
        }
        this.addDebugParams(cmds, false);
    }

    protected StringBuffer createAutClasspath(Map parameters) {
        String manifestClassPath;
        StringBuffer autClassPath = new StringBuffer();
        String jarFile = (String)parameters.get("JAR_FILE");
        if (jarFile == null) {
            jarFile = "";
        }
        if ((manifestClassPath = this.getClassPathFromManifest(parameters)).length() > 0) {
            autClassPath.append(manifestClassPath).append(PATH_SEPARATOR);
        }
        autClassPath.append(jarFile);
        if (jarFile != null && jarFile.length() > 0) {
            autClassPath.append(PATH_SEPARATOR);
        }
        return autClassPath;
    }
}

