/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.vocab.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.actf.util.vocab.IEvalTarget;
import org.eclipse.actf.util.vocab.IProposition;

public class Function
implements IProposition {
    private String name;
    private Object[] args;
    private Method method;

    public Function(String string, String ... stringArray) {
        this.name = string;
        this.args = new Object[stringArray.length + 1];
        int n = 0;
        while (n < stringArray.length) {
            this.args[n + 1] = stringArray[n];
            ++n;
        }
    }

    public boolean eval(IEvalTarget iEvalTarget) {
        if (this.method == null) {
            Class[] classArray = new Class[this.args.length];
            int n = 0;
            while (n < classArray.length) {
                classArray[n] = this.args[n].getClass();
                ++n;
            }
            Class<?> clazz = iEvalTarget.getTerms().getClass();
            try {
                this.method = clazz.getMethod(this.getName(), classArray);
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
        }
        if (this.method != null) {
            try {
                this.args[0] = iEvalTarget;
                return (Boolean)this.method.invoke((Object)iEvalTarget.getTerms(), this.args);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
        return false;
    }

    public String getName() {
        return this.name;
    }
}

