/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.core.swt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rcptt.tesla.recording.core.swt.IRecorderDescriberExtension;
import org.eclipse.rcptt.tesla.recording.core.swt.IRecordingDescriber;
import org.eclipse.rcptt.tesla.recording.core.swt.RecordingWidgetDescriber;
import org.eclipse.swt.widgets.Widget;

public class RecordingDescriberManager {
    private List<Entry> extensions = null;
    private static RecordingDescriberManager descManager = null;

    private RecordingDescriberManager() {
    }

    private synchronized void initialize() {
        IConfigurationElement[] elements;
        if (this.extensions != null) {
            return;
        }
        this.extensions = new ArrayList<Entry>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.rcptt.tesla.recording.swt.describerExtensions");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement cfg = iConfigurationElementArray[n2];
            try {
                IRecorderDescriberExtension provider = (IRecorderDescriberExtension)cfg.createExecutableExtension("class");
                int priority = 0;
                try {
                    String attribute = cfg.getAttribute("priority");
                    priority = Integer.valueOf(attribute);
                }
                catch (NumberFormatException attribute) {
                    // empty catch block
                }
                Entry e = new Entry();
                e.ext = provider;
                e.priority = priority;
                this.extensions.add(e);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        Collections.sort(this.extensions, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                return Integer.valueOf(o1.priority).compareTo(o2.priority);
            }
        });
    }

    IRecorderDescriberExtension[] getExtensions() {
        this.initialize();
        IRecorderDescriberExtension[] ar = new IRecorderDescriberExtension[this.extensions.size()];
        int i = 0;
        while (i < ar.length) {
            ar[i] = this.extensions.get((int)i).ext;
            ++i;
        }
        return ar;
    }

    public static IRecordingDescriber getDescriber(Widget widget, int x, int y, boolean fromAssert) {
        if (descManager == null) {
            descManager = new RecordingDescriberManager();
        }
        IRecorderDescriberExtension[] extensions = descManager.getExtensions();
        IRecordingDescriber current = new RecordingWidgetDescriber(widget);
        IRecorderDescriberExtension[] iRecorderDescriberExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IRecorderDescriberExtension ext = iRecorderDescriberExtensionArray[n2];
            current = ext.getDescriber(widget, current, x, y, fromAssert);
            ++n2;
        }
        return current;
    }

    private static class Entry {
        IRecorderDescriberExtension ext;
        int priority = 0;

        private Entry() {
        }
    }
}

