/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.zephyr;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.rcptt.internal.zephyr.Messages;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;
import org.eclipse.rcptt.tesla.core.utils.Cryptography;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public final class ZephyrPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.rcptt.zephyr";
    public static final String LAUNCH_TESTRUNID = "org.eclipse.rcptt.zephyr.ATTR_ZEPHYR_TESTRUNID";
    public static final String ZEPHYR_ENABLED = "ZEPHYR_ENABLED";
    public static final String ZEPHYR_ADDRESS = "ZEPHYR_ADDRESS";
    public static final String ZEPHYR_USERNAME = "ZEPHYR_USERNAME";
    public static final String ZEPHYR_PASSWORD = "ZEPHYR_PASSWORD";
    public static final String ZEPHYR_PROJECT = "ZEPHYR_PROJECT";
    public static final String ZEPHYR_VERSION = "ZEPHYR_VERSION";
    public static final String ZEPHYR_CYCLE = "ZEPHYR_CYCLE";
    public static final boolean DEFAULT_ZEPHYR_ENABLED = false;
    private static ZephyrPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static ZephyrPlugin getDefault() {
        return plugin;
    }

    public static void logInfo(String message) {
        String loggingEnabled = TeslaFeatures.getInstance().getValue("com.xored.testengine.logs");
        if ("true".equals(loggingEnabled)) {
            ZephyrPlugin.log(ZephyrPlugin.createStatus(1, message));
        }
    }

    public static void log(Throwable t) {
        ZephyrPlugin.log(t.getMessage(), t);
    }

    public static void log(String message, Throwable t) {
        ZephyrPlugin.log(ZephyrPlugin.createStatus(message, t));
    }

    public static void log(String message) {
        ZephyrPlugin.log(ZephyrPlugin.createStatus(message));
    }

    public static void log(IStatus status) {
        if (ZephyrPlugin.getDefault() != null) {
            ZephyrPlugin.getDefault().getLog().log(status);
        }
    }

    public static IStatus createStatus(String message) {
        return ZephyrPlugin.createStatus(4, message, null);
    }

    public static IStatus createStatus(int state, String message) {
        return ZephyrPlugin.createStatus(state, message, null);
    }

    public static IStatus createStatus(String message, Throwable t) {
        return ZephyrPlugin.createStatus(4, message, t);
    }

    public static IStatus createStatus(int state, String message, Throwable t) {
        return new Status(state, PLUGIN_ID, message, t);
    }

    public static IEclipsePreferences getPreferences() {
        return InstanceScope.INSTANCE.getNode(PLUGIN_ID);
    }

    public static ISecurePreferences getSecurePreferences() {
        return SecurePreferencesFactory.getDefault().node(PLUGIN_ID);
    }

    public static boolean getZephyrEnabled() {
        IEclipsePreferences preferences = ZephyrPlugin.getPreferences();
        return preferences.getBoolean(ZEPHYR_ENABLED, false);
    }

    public static void setZephyrEnabled(boolean enabled) {
        IEclipsePreferences preferences = ZephyrPlugin.getPreferences();
        try {
            preferences.putBoolean(ZEPHYR_ENABLED, enabled);
            preferences.flush();
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(MessageFormat.format(Messages.ZephyrPlugin_ErrorWhileSaving, ZEPHYR_ENABLED), e);
        }
    }

    public static String getZephyrAddress() {
        IEclipsePreferences preferences = ZephyrPlugin.getPreferences();
        return preferences.get(ZEPHYR_ADDRESS, "");
    }

    public static void setZephyrAddress(String address) {
        IEclipsePreferences preferences = ZephyrPlugin.getPreferences();
        try {
            preferences.put(ZEPHYR_ADDRESS, address);
            preferences.flush();
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(MessageFormat.format(Messages.ZephyrPlugin_ErrorWhileSaving, ZEPHYR_ADDRESS), e);
        }
    }

    public static String getZephyrUsername() {
        IEclipsePreferences preferences = ZephyrPlugin.getPreferences();
        return preferences.get(ZEPHYR_USERNAME, "");
    }

    public static void setZephyrUsername(String username) {
        IEclipsePreferences preferences = ZephyrPlugin.getPreferences();
        try {
            preferences.put(ZEPHYR_USERNAME, username);
            preferences.flush();
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(MessageFormat.format(Messages.ZephyrPlugin_ErrorWhileSaving, ZEPHYR_USERNAME), e);
        }
    }

    public static String getZephyrPassword() {
        ISecurePreferences preferences = ZephyrPlugin.getSecurePreferences();
        try {
            return Cryptography.INSTANCE.decrypt(preferences.get(ZEPHYR_PASSWORD, ""));
        }
        catch (StorageException e) {
            throw new IllegalStateException(MessageFormat.format(Messages.ZephyrPlugin_ErrorWhileSaving, ZEPHYR_PASSWORD), e);
        }
    }

    public static void setZephyrPassword(String password) {
        ISecurePreferences preferences = ZephyrPlugin.getSecurePreferences();
        try {
            preferences.put(ZEPHYR_PASSWORD, Cryptography.INSTANCE.encrypt(password), false);
            preferences.flush();
        }
        catch (IOException | StorageException e) {
            throw new IllegalStateException(MessageFormat.format(Messages.ZephyrPlugin_ErrorWhileSaving, ZEPHYR_PASSWORD), e);
        }
    }

    public static String getZephyrProject(IProject project) {
        IEclipsePreferences preferences = ZephyrPlugin.getProperties(project);
        return preferences.get(ZEPHYR_PROJECT, "");
    }

    public static void setZephyrProject(String zephyrProject, IProject rcpttProject) {
        IEclipsePreferences properties = ZephyrPlugin.getProperties(rcpttProject);
        try {
            properties.put(ZEPHYR_PROJECT, zephyrProject);
            properties.flush();
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(MessageFormat.format(Messages.ZephyrPlugin_ErrorWhileSaving, ZEPHYR_PROJECT), e);
        }
    }

    public static String getZephyrVersion(IProject project) {
        IEclipsePreferences preferences = ZephyrPlugin.getProperties(project);
        return preferences.get(ZEPHYR_VERSION, "");
    }

    public static void setZephyrVersion(String zephyrVersion, IProject rcpttProject) {
        IEclipsePreferences properties = ZephyrPlugin.getProperties(rcpttProject);
        try {
            properties.put(ZEPHYR_VERSION, zephyrVersion);
            properties.flush();
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(MessageFormat.format(Messages.ZephyrPlugin_ErrorWhileSaving, ZEPHYR_VERSION), e);
        }
    }

    public static String getZephyrCycle(IProject project) {
        IEclipsePreferences preferences = ZephyrPlugin.getProperties(project);
        return preferences.get(ZEPHYR_CYCLE, "");
    }

    public static void setZephyrCycle(String zephyrCycle, IProject rcpttProject) {
        IEclipsePreferences properties = ZephyrPlugin.getProperties(rcpttProject);
        try {
            properties.put(ZEPHYR_CYCLE, zephyrCycle);
            properties.flush();
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(MessageFormat.format(Messages.ZephyrPlugin_ErrorWhileSaving, ZEPHYR_CYCLE), e);
        }
    }

    private static IEclipsePreferences getProperties(IProject project) {
        return new ProjectScope(project).getNode(PLUGIN_ID);
    }
}

