/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.operations;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.equinox.internal.p2.operations.LoadFailure;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.operations.RepositoryTracker;

public final class LoadFailureAccumulator {
    private final RepositoryTracker repositoryTracker;
    private int loadFailuresNotCausedByBadRepoLocation;
    private final List<LoadFailure> loadFailuresCausedByBadRepoLocation;

    public LoadFailureAccumulator(RepositoryTracker repositoryTracker) {
        this.repositoryTracker = repositoryTracker;
        this.loadFailuresCausedByBadRepoLocation = new ArrayList<LoadFailure>();
    }

    public void recordLoadFailure(ProvisionException e, URI location) {
        if (LoadFailure.failureRepresentsBadRepositoryLocation(e)) {
            this.loadFailuresCausedByBadRepoLocation.add(new LoadFailure(location, e));
            this.repositoryTracker.addNotFound(location);
        } else {
            ++this.loadFailuresNotCausedByBadRepoLocation;
        }
    }

    public boolean hasSingleFailureCausedByBadLocation() {
        return this.loadFailuresCausedByBadRepoLocation.size() == 1 && this.loadFailuresNotCausedByBadRepoLocation == 0;
    }

    public boolean allFailuresCausedByBadLocation() {
        return this.loadFailuresCausedByBadRepoLocation.size() >= 1 && this.loadFailuresNotCausedByBadRepoLocation == 0;
    }

    public List<LoadFailure> getLoadFailuresCausedByBadRepoLocation() {
        return this.loadFailuresCausedByBadRepoLocation;
    }
}

