/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.rap;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.rcptt.core.launching.events.AutBundleState;
import org.eclipse.rcptt.core.launching.events.AutEventStart;
import org.eclipse.rcptt.core.launching.events.AutStartState;
import org.eclipse.rcptt.core.launching.events.EventsFactory;
import org.eclipse.rcptt.internal.launching.Q7LaunchingPlugin;
import org.eclipse.rcptt.internal.launching.aut.BaseAutLaunch;
import org.eclipse.rcptt.internal.launching.aut.BaseAutManager;
import org.eclipse.rcptt.internal.launching.aut.LaunchInfoCache;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.launching.AutLaunchListener;
import org.eclipse.rcptt.launching.AutLaunchState;

public class Q7RapLaunchMonitor {
    private IStatus status;
    private AutEventStart start;
    private final BaseAutLaunch aut;

    public Q7RapLaunchMonitor(ILaunch launch) throws CoreException {
        this.aut = BaseAutManager.INSTANCE.getByLaunch(launch);
        if (this.aut == null) {
            throw new CoreException(Q7LaunchingPlugin.createStatus((String)("Couldn't find AUT for ILaunch: " + String.valueOf(launch))));
        }
    }

    public void wait(IProgressMonitor monitor, int seconds, Runnable openbrowser) throws CoreException {
        monitor.beginTask("Waiting for AUT", 2);
        this.aut.addListener(new AutLaunchListener(){

            public void stateChanged(AutLaunch launch, AutLaunchState state) {
                if (state.equals((Object)AutLaunchState.TERMINATE) && launch.equals(Q7RapLaunchMonitor.this.aut)) {
                    Q7RapLaunchMonitor.this.aut.setLocationOnRestart(null);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void autStarted(AutLaunch baseAutLaunch, int eclPort, int teslaPort) {
                Q7RapLaunchMonitor q7RapLaunchMonitor = Q7RapLaunchMonitor.this;
                synchronized (q7RapLaunchMonitor) {
                    AutEventStart st = EventsFactory.eINSTANCE.createAutEventStart();
                    st.setEclPort(eclPort);
                    st.setTeslaPort(teslaPort);
                    Q7RapLaunchMonitor.this.start = st;
                    Q7RapLaunchMonitor.this.notifyAll();
                }
            }

            public void autInit(AutLaunch baseAutLaunch, List<AutBundleState> bundleState) {
            }

            public void autLocationChange(BaseAutLaunch baseAutLaunch, String location) {
                Q7RapLaunchMonitor.this.aut.setLocationOnRestart(location);
                LaunchInfoCache.CachedInfo info = LaunchInfoCache.getInfo((ILaunchConfiguration)Q7RapLaunchMonitor.this.aut.getLaunch().getLaunchConfiguration());
                if (info != null) {
                    info.programArgs = null;
                }
            }
        });
        long start = System.currentTimeMillis();
        AutEventStart startup = this.doWait((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1), seconds);
        openbrowser.run();
        int teslaPort = startup.getTeslaPort();
        int eclPort = startup.getEclPort();
        String platform = startup.getPlatform().getLiteral().toLowerCase();
        String capability = startup.getCapability().getLiteral().toLowerCase();
        seconds = (int)(start - System.currentTimeMillis()) / 1000 + seconds;
        this.aut.activate("localhost", eclPort, teslaPort, platform, capability, (float)seconds, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
        monitor.done();
        this.status = Status.OK_STATUS;
    }

    public void handle(Exception e) {
        this.status = e instanceof CoreException ? ((CoreException)e).getStatus() : Q7LaunchingPlugin.createStatus((String)e.getMessage(), (Throwable)e);
    }

    public void dispose() {
        if (this.status == null) {
            this.status = Q7LaunchingPlugin.createStatus((String)"Execution finished unexpectedly");
        }
        if (!this.status.isOK()) {
            this.aut.terminated(this.status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AutEventStart doWait(IProgressMonitor monitor, int seconds) throws CoreException {
        monitor.beginTask("Waiting for startup status...", seconds);
        int terminateTimeout = 5;
        while (--seconds >= 0) {
            if (monitor.isCanceled()) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            if (this.aut.getState().equals((Object)AutLaunchState.TERMINATE)) {
                if (terminateTimeout > 0) {
                    --terminateTimeout;
                }
                if (terminateTimeout <= 0) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.launching.ext", 7788, "Process was terminated while waiting for AUT startup data", null));
                }
            }
            Q7RapLaunchMonitor q7RapLaunchMonitor = this;
            synchronized (q7RapLaunchMonitor) {
                if (this.start != null) {
                    if (!this.start.getState().equals((Object)AutStartState.OK)) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.launching.ext", this.start.getMessage()));
                    }
                    monitor.done();
                    return this.start;
                }
                try {
                    this.wait(1000L);
                    if (monitor.isCanceled()) {
                        throw new CoreException(Status.CANCEL_STATUS);
                    }
                }
                catch (InterruptedException e) {
                    throw new CoreException(Status.CANCEL_STATUS);
                }
            }
            monitor.worked(1);
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.launching.ext", "Timeout error: AUT doesn't respond"));
    }

    public void handleNewLocation(String location) {
        this.aut.setLocationOnRestart(location);
    }
}

