/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.formatter.IndentManipulation;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.IProposableFix;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSUtil;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class StringFixCore
implements IProposableFix {
    private final TextEditGroup[] fEditGroups;
    private final String fName;
    private final ICompilationUnit fCompilationUnit;

    public static StringFixCore createFix(CompilationUnit compilationUnit, IProblemLocation problem, boolean removeNLSTag, boolean addNLSTag) throws CoreException {
        String label;
        IBuffer buffer;
        TextEdit addEdit = null;
        ICompilationUnit cu = (ICompilationUnit)compilationUnit.getJavaElement();
        if (addNLSTag) {
            addEdit = NLSUtil.createNLSEdit(cu, problem.getOffset());
        }
        ReplaceEdit removeEdit = null;
        if (removeNLSTag && (buffer = cu.getBuffer()) != null) {
            removeEdit = StringFixCore.getReplace(problem.getOffset(), problem.getLength(), buffer, true);
        }
        if (addEdit != null && removeEdit != null) {
            label = FixMessages.StringFix_AddRemoveNonNls_description;
            return new StringFixCore(label, compilationUnit, new TextEditGroup[]{new TextEditGroup(label, addEdit), new TextEditGroup(label, (TextEdit)removeEdit)});
        }
        if (addEdit != null) {
            label = FixMessages.StringFix_AddNonNls_description;
            return new StringFixCore(label, compilationUnit, new TextEditGroup[]{new TextEditGroup(label, addEdit)});
        }
        if (removeEdit != null) {
            label = FixMessages.StringFix_RemoveNonNls_description;
            return new StringFixCore(label, compilationUnit, new TextEditGroup[]{new TextEditGroup(label, (TextEdit)removeEdit)});
        }
        return null;
    }

    public static ICleanUpFix createCleanUp(CompilationUnit compilationUnit, boolean addNLSTag, boolean removeNLSTag) throws CoreException, JavaModelException {
        if (!addNLSTag && !removeNLSTag) {
            return null;
        }
        IProblem[] problems = compilationUnit.getProblems();
        IProblemLocation[] locations = new IProblemLocation[problems.length];
        int i = 0;
        while (i < problems.length) {
            locations[i] = new ProblemLocation(problems[i]);
            ++i;
        }
        return StringFixCore.createCleanUp(compilationUnit, addNLSTag, removeNLSTag, locations);
    }

    public static ICleanUpFix createCleanUp(CompilationUnit compilationUnit, IProblemLocation[] problems, boolean addNLSTag, boolean removeNLSTag) throws CoreException, JavaModelException {
        if (!addNLSTag && !removeNLSTag) {
            return null;
        }
        return StringFixCore.createCleanUp(compilationUnit, addNLSTag, removeNLSTag, problems);
    }

    private static ICleanUpFix createCleanUp(CompilationUnit compilationUnit, boolean addNLSTag, boolean removeNLSTag, IProblemLocation[] problems) throws CoreException, JavaModelException {
        ICompilationUnit cu = (ICompilationUnit)compilationUnit.getJavaElement();
        if (!cu.isStructureKnown()) {
            return null;
        }
        ArrayList<CategorizedTextEditGroup> result = new ArrayList<CategorizedTextEditGroup>();
        ArrayList<IProblemLocation> missingNLSProblems = new ArrayList<IProblemLocation>();
        IProblemLocation[] iProblemLocationArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            ReplaceEdit edit;
            IBuffer buffer;
            IProblemLocation problem = iProblemLocationArray[n2];
            if (addNLSTag && problem.getProblemId() == 536871173) {
                missingNLSProblems.add(problem);
            }
            if (removeNLSTag && problem.getProblemId() == 536871177 && (buffer = cu.getBuffer()) != null && (edit = StringFixCore.getReplace(problem.getOffset(), problem.getLength(), buffer, true)) != null) {
                String label = FixMessages.StringFix_RemoveNonNls_description;
                result.add(new CategorizedTextEditGroup(label, (TextEdit)edit, new GroupCategorySet(new GroupCategory(label, label, label))));
            }
            ++n2;
        }
        if (!missingNLSProblems.isEmpty()) {
            int[] positions = new int[missingNLSProblems.size()];
            int i = 0;
            for (IProblemLocation problem : missingNLSProblems) {
                positions[i] = problem.getOffset();
                ++i;
            }
            TextEdit[] edits = NLSUtil.createNLSEdits(cu, positions);
            if (edits != null) {
                TextEdit[] textEditArray = edits;
                int n3 = edits.length;
                int n4 = 0;
                while (n4 < n3) {
                    TextEdit edit = textEditArray[n4];
                    String label = FixMessages.StringFix_AddNonNls_description;
                    result.add(new CategorizedTextEditGroup(label, edit, new GroupCategorySet(new GroupCategory(label, label, label))));
                    ++n4;
                }
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        return new StringFixCore("", compilationUnit, result.toArray(new TextEditGroup[result.size()]));
    }

    public static ReplaceEdit getReplace(int offset, int length, IBuffer buffer, boolean removeLeadingIndents) {
        String replaceString = "";
        boolean hasMoreInComment = false;
        int next = offset + length;
        while (next < buffer.getLength()) {
            char ch = buffer.getChar(next);
            if (IndentManipulation.isIndentChar((char)ch)) {
                if (!buffer.getContents().substring(++next).startsWith("//$NON-NLS-")) continue;
                break;
            }
            if (IndentManipulation.isLineDelimiterChar((char)ch)) {
                length = next - offset;
                break;
            }
            if (ch == '/') {
                if (++next == buffer.getLength() || buffer.getChar(next) != '/') {
                    replaceString = "//";
                } else {
                    length = next - offset - 1;
                }
                hasMoreInComment = true;
                break;
            }
            replaceString = "//";
            hasMoreInComment = true;
            break;
        }
        if (!hasMoreInComment && removeLeadingIndents) {
            while (offset > 0 && IndentManipulation.isIndentChar((char)buffer.getChar(offset - 1))) {
                --offset;
                ++length;
            }
        }
        if (length > 0) {
            ReplaceEdit replaceEdit = new ReplaceEdit(offset, length, replaceString);
            return replaceEdit;
        }
        return null;
    }

    public StringFixCore(String name, CompilationUnit compilationUnit, TextEditGroup[] groups) {
        this.fName = name;
        this.fCompilationUnit = (ICompilationUnit)compilationUnit.getJavaElement();
        this.fEditGroups = groups;
    }

    @Override
    public CompilationUnitChange createChange(IProgressMonitor progressMonitor) throws CoreException {
        if (this.fEditGroups == null || this.fEditGroups.length == 0) {
            return null;
        }
        CompilationUnitChange result = new CompilationUnitChange(this.getDisplayString(), this.fCompilationUnit);
        TextEditGroup[] textEditGroupArray = this.fEditGroups;
        int n = this.fEditGroups.length;
        int n2 = 0;
        while (n2 < n) {
            TextEditGroup editGroup = textEditGroupArray[n2];
            String groupName = editGroup.getName();
            TextEdit[] textEditArray = editGroup.getTextEdits();
            int n3 = textEditArray.length;
            int n4 = 0;
            while (n4 < n3) {
                TextEdit edit = textEditArray[n4];
                TextChangeCompatibility.addTextEdit((TextChange)result, groupName, edit);
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    @Override
    public String getAdditionalProposalInfo() {
        return null;
    }

    @Override
    public String getDisplayString() {
        return this.fName;
    }

    @Override
    public IStatus getStatus() {
        return null;
    }
}

