/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.core.target;

import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.internal.core.EclipseHomeInitializer;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEPreferencesManager;
import org.eclipse.pde.internal.core.target.Messages;
import org.eclipse.pde.internal.core.target.TargetPlatformService;

public class LoadTargetDefinitionJob
extends WorkspaceJob {
    private static final String JOB_FAMILY_ID = "LoadTargetDefinitionJob";
    private ITargetDefinition fTarget;
    private boolean fNone = false;

    public static void load(ITargetDefinition target) {
        LoadTargetDefinitionJob.load(target, null);
    }

    public static void load(ITargetDefinition target, IJobChangeListener listener) {
        Job.getJobManager().cancel((Object)JOB_FAMILY_ID);
        LoadTargetDefinitionJob job = new LoadTargetDefinitionJob(target);
        job.setUser(true);
        if (listener != null) {
            job.addJobChangeListener(listener);
        }
        job.schedule();
    }

    public LoadTargetDefinitionJob(ITargetDefinition target) {
        super(Messages.LoadTargetDefinitionJob_0);
        this.fTarget = target;
        if (target == null) {
            this.fNone = true;
            ITargetPlatformService service = TargetPlatformService.getDefault();
            this.fTarget = service.newTarget();
        }
    }

    public boolean belongsTo(Object family) {
        return JOB_FAMILY_ID.equals(family);
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        try {
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.LoadTargetOperation_mainTaskName, (int)40).checkCanceled();
            if (!this.fTarget.isResolved()) {
                this.fTarget.resolve((IProgressMonitor)subMon.split(20));
            }
            subMon.checkCanceled();
            subMon.setWorkRemaining(20);
            PDEPreferencesManager preferences = PDECore.getDefault().getPreferencesManager();
            ((TargetPlatformService)TargetPlatformService.getDefault()).setWorkspaceTargetDefinition(this.fTarget, false);
            String memento = this.fTarget.getHandle().getMemento();
            if (this.fNone) {
                memento = "NO_TARGET";
            }
            if (memento.equals(preferences.getString("workspace_target_handle"))) {
                preferences.setValue("workspace_target_handle", "");
            }
            preferences.setValue("workspace_target_handle", memento);
            this.loadJRE((IProgressMonitor)subMon.split(3));
            PDECore.getDefault().getPreferencesManager().savePluginPreferences();
            this.resetPlatform((IProgressMonitor)subMon.split(14));
        }
        catch (OperationCanceledException e) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private void loadJRE(IProgressMonitor monitor) {
        IVMInstall def;
        IVMInstall jre;
        IPath container = this.fTarget.getJREContainer();
        monitor.beginTask(Messages.LoadTargetOperation_jreTaskName, 1);
        if (container != null && (jre = JavaRuntime.getVMInstall((IPath)container)) != null && !jre.equals(def = JavaRuntime.getDefaultVMInstall())) {
            try {
                JavaRuntime.setDefaultVMInstall((IVMInstall)jre, null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        monitor.done();
    }

    private void resetPlatform(IProgressMonitor monitor) {
        EclipseHomeInitializer.resetEclipseHomeVariable();
        PDECore.getDefault().getSourceLocationManager().reset();
        PDECore.getDefault().getJavadocLocationManager().reset();
        PDECore.getDefault().getExtensionsRegistry().targetReloaded();
        PDECore.getDefault().getModelManager().targetReloaded(monitor);
        PDECore.getDefault().getFeatureModelManager().targetReloaded();
    }
}

