/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.api.tools.internal.ApiBaselineManager;
import org.eclipse.pde.api.tools.internal.model.ApiModelFactory;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.preferences.ApiBaselinePreferencePage;
import org.eclipse.pde.api.tools.ui.internal.wizards.WizardMessages;

public abstract class ApiBaselineWizardPage
extends WizardPage {
    IApiBaseline fProfile = null;
    private String originalname = null;
    boolean contentchange = false;

    protected ApiBaselineWizardPage(IApiBaseline profile) {
        super(WizardMessages.ApiProfileWizardPage_1);
        this.fProfile = profile;
        this.setTitle(WizardMessages.ApiProfileWizardPage_1);
        if (profile == null) {
            this.setMessage(WizardMessages.ApiProfileWizardPage_3);
        } else {
            this.originalname = this.fProfile.getName();
            this.setMessage(WizardMessages.ApiProfileWizardPage_4);
        }
        this.setImageDescriptor(ApiUIPlugin.getImageDescriptor("IMG_WIZBAN_PROFILE"));
    }

    protected void initialize() {
        if (this.fProfile == null) {
            return;
        }
        WorkingCopyOperation op = new WorkingCopyOperation(this.fProfile);
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)op);
        }
        catch (InterruptedException | InvocationTargetException e) {
            ApiUIPlugin.log(e);
        }
        this.fProfile = op.getWorkingCopy();
    }

    protected boolean isNameValid(String name) {
        if (name.length() < 1) {
            this.setErrorMessage(WizardMessages.ApiProfileWizardPage_20);
            return false;
        }
        if (!name.equals(this.originalname) && ((ApiBaselineManager)ApiPlugin.getDefault().getApiBaselineManager()).isExistingProfileName(name) && !ApiBaselinePreferencePage.isRemovedBaseline(name)) {
            this.setErrorMessage(WizardMessages.ApiProfileWizardPage_profile_with_that_name_exists);
            return false;
        }
        IStatus status = ResourcesPlugin.getWorkspace().validateName(name, 1);
        if (!status.isOK()) {
            this.setErrorMessage(status.getMessage());
            return false;
        }
        return true;
    }

    protected IApiComponent[] getCurrentComponents() {
        if (this.fProfile != null) {
            return this.fProfile.getApiComponents();
        }
        return new IApiComponent[0];
    }

    public abstract IApiBaseline finish() throws IOException, CoreException;

    public boolean contentChanged() {
        return this.contentchange;
    }

    public void cancel() {
        if (this.fProfile != null) {
            this.fProfile.dispose();
        }
    }

    static class ContentProvider
    implements ITreeContentProvider {
        ContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IApiComponent) {
                try {
                    IApiComponent component = (IApiComponent)parentElement;
                    List ees = component.getExecutionEnvironments();
                    return ees.stream().map(EEEntry::new).toArray();
                }
                catch (CoreException e) {
                    ApiPlugin.log((Throwable)e);
                }
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IApiComponent) {
                try {
                    IApiComponent component = (IApiComponent)element;
                    return !component.getExecutionEnvironments().isEmpty();
                }
                catch (CoreException e) {
                    ApiPlugin.log((Throwable)e);
                }
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IApiComponent[]) {
                return (Object[])inputElement;
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }
    }

    public static class EEEntry {
        String name = null;

        public EEEntry(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    static class WorkingCopyOperation
    implements IRunnableWithProgress {
        IApiBaseline original = null;
        IApiBaseline workingcopy = null;

        public WorkingCopyOperation(IApiBaseline original) {
            this.original = original;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                IApiComponent[] components = this.original.getApiComponents();
                SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)WizardMessages.ApiProfileWizardPage_create_working_copy, (int)(components.length + 1));
                localmonitor.subTask(WizardMessages.ApiProfileWizardPage_copy_profile_attribs);
                this.workingcopy = ApiModelFactory.newApiBaseline((String)this.original.getName(), (String)this.original.getLocation());
                localmonitor.worked(1);
                localmonitor.subTask(WizardMessages.ApiProfileWizardPage_copy_api_components);
                ArrayList<IApiComponent> comps = new ArrayList<IApiComponent>();
                IApiComponent comp = null;
                IApiComponent[] iApiComponentArray = components;
                int n = components.length;
                int n2 = 0;
                while (n2 < n) {
                    IApiComponent component = iApiComponentArray[n2];
                    comp = ApiModelFactory.newApiComponent((IApiBaseline)this.workingcopy, (String)component.getLocation());
                    if (comp != null) {
                        comps.add(comp);
                    }
                    localmonitor.worked(1);
                    ++n2;
                }
                this.workingcopy.addApiComponents(comps.toArray(new IApiComponent[comps.size()]));
            }
            catch (CoreException ce) {
                ApiUIPlugin.log(ce);
            }
        }

        public IApiBaseline getWorkingCopy() {
            return this.workingcopy;
        }
    }
}

