/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.parameters;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.core.persistence.plain.IPlainTextPersistenceExtension;
import org.eclipse.rcptt.core.persistence.plain.PlainTextPersistenceModel;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.parameters.Parameter;
import org.eclipse.rcptt.parameters.ParametersContext;
import org.eclipse.rcptt.parameters.ParametersFactory;
import org.eclipse.rcptt.util.FileUtil;

public class ParametersContextPlainExtension
implements IPlainTextPersistenceExtension {
    private static final String PARAMETERS_CONTEXT = ".parameters.context";

    public boolean isContentEntryOptional(EList<EObject> contents) {
        return contents.get(0) instanceof ParametersContext;
    }

    public void updateAttributes(PlainTextPersistenceModel plainTextPersistenceModel, Map<String, String> masterAttributes, EObject eObject) {
        if (eObject instanceof ParametersContext) {
            ParametersContext ctx = (ParametersContext)eObject;
            Properties props = ParametersContextPlainExtension.convertToProperties(ctx);
            OutputStream stream = plainTextPersistenceModel.store(PARAMETERS_CONTEXT);
            try {
                try {
                    props.store(stream, null);
                }
                catch (IOException e) {
                    RcpttPlugin.log((Throwable)e);
                    FileUtil.safeClose((Closeable)stream);
                }
            }
            finally {
                FileUtil.safeClose((Closeable)stream);
            }
        }
    }

    public static Properties convertToProperties(ParametersContext ctx) {
        Properties props = new Properties();
        for (Parameter param : ctx.getParameters()) {
            props.put(param.getName(), param.getValue());
        }
        return props;
    }

    public void updateMetadata(PlainTextPersistenceModel plainTextPersistenceModel, Map<String, String> header, EObject eObject) {
        InputStream stream;
        if (eObject instanceof ParametersContext && (stream = plainTextPersistenceModel.read(PARAMETERS_CONTEXT)) != null) {
            try {
                try {
                    Properties props = new Properties();
                    props.load(stream);
                    EList<Parameter> params = ((ParametersContext)eObject).getParameters();
                    params.clear();
                    for (Map.Entry<Object, Object> prop : props.entrySet()) {
                        Parameter param = ParametersFactory.eINSTANCE.createParameter();
                        param.setName((String)prop.getKey());
                        param.setValue((String)prop.getValue());
                        params.add((Object)param);
                    }
                }
                catch (IOException e) {
                    RcpttPlugin.log((Throwable)e);
                    FileUtil.safeClose((Closeable)stream);
                }
            }
            finally {
                FileUtil.safeClose((Closeable)stream);
            }
        }
    }

    public void performObjectPreSaveUpdate(EObject eObject) {
        if (eObject instanceof ParametersContext) {
            ((ParametersContext)eObject).getParameters().clear();
        }
    }

    public String getTextContentType(String fName) {
        if (PARAMETERS_CONTEXT.equals(fName)) {
            return "text/properties";
        }
        return null;
    }
}

