/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.update;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;
import org.eclipse.jface.viewers.Viewer;

public class LaunchManagerProxy
extends AbstractModelProxy
implements ILaunchesListener2 {
    private ILaunchManager fLaunchManager;

    @Override
    public synchronized void init(IPresentationContext context) {
        super.init(context);
        this.fLaunchManager = DebugPlugin.getDefault().getLaunchManager();
        this.fLaunchManager.addLaunchListener((ILaunchesListener)this);
    }

    @Override
    public void installed(Viewer viewer) {
        ILaunch[] launches = this.fLaunchManager.getLaunches();
        if (launches.length > 0) {
            this.launchesAdded(launches);
        }
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        if (this.fLaunchManager != null) {
            this.fLaunchManager.removeLaunchListener((ILaunchesListener)this);
            this.fLaunchManager = null;
        }
    }

    public void launchesTerminated(ILaunch[] launches) {
    }

    public void launchesRemoved(ILaunch[] launches) {
        this.fireDelta(launches, 2);
    }

    public void launchesAdded(ILaunch[] launches) {
        this.fireDelta(launches, 0x400001);
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    protected void fireDelta(ILaunch[] launches, int launchFlags) {
        ModelDelta delta = new ModelDelta(this.fLaunchManager, 0);
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            delta.addNode(launch, launchFlags);
            ++n2;
        }
        this.fireModelChanged(delta);
    }
}

