/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.manipulation.internal.javadoc;

import java.util.ArrayList;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;

abstract class InheritDocVisitor {
    public static final Object STOP_BRANCH = new Object(){

        public String toString() {
            return "STOP_BRANCH";
        }
    };
    public static final Object CONTINUE = new Object(){

        public String toString() {
            return "CONTINUE";
        }
    };

    InheritDocVisitor() {
    }

    public abstract Object visit(IType var1) throws JavaModelException;

    public Object visitInheritDoc(IType currentType, ITypeHierarchy typeHierarchy) throws JavaModelException {
        ArrayList<IType> visited = new ArrayList<IType>();
        visited.add(currentType);
        Object result = this.visitInheritDocInterfaces(visited, currentType, typeHierarchy);
        if (result != CONTINUE) {
            return result;
        }
        IType superClass = currentType.isInterface() ? currentType.getJavaProject().findType("java.lang.Object") : typeHierarchy.getSuperclass(currentType);
        while (superClass != null && !visited.contains(superClass)) {
            result = this.visit(superClass);
            if (result == STOP_BRANCH) {
                return null;
            }
            if (result == CONTINUE) {
                visited.add(superClass);
                result = this.visitInheritDocInterfaces(visited, superClass, typeHierarchy);
                if (result != CONTINUE) {
                    return result;
                }
                superClass = typeHierarchy.getSuperclass(superClass);
                continue;
            }
            return result;
        }
        return null;
    }

    private Object visitInheritDocInterfaces(ArrayList<IType> visited, IType currentType, ITypeHierarchy typeHierarchy) throws JavaModelException {
        ArrayList<IType> toVisitChildren = new ArrayList<IType>();
        IType[] iTypeArray = typeHierarchy.getSuperInterfaces(currentType);
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType superInterface = iTypeArray[n2];
            if (!visited.contains(superInterface)) {
                visited.add(superInterface);
                Object result = this.visit(superInterface);
                if (result != STOP_BRANCH) {
                    if (result == CONTINUE) {
                        toVisitChildren.add(superInterface);
                    } else {
                        return result;
                    }
                }
            }
            ++n2;
        }
        for (IType child : toVisitChildren) {
            Object result = this.visitInheritDocInterfaces(visited, child, typeHierarchy);
            if (result == CONTINUE) continue;
            return result;
        }
        return CONTINUE;
    }
}

