/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.variables;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.views.variables.details.DefaultDetailPane;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.ui.ExpressionInformationControlCreator;
import org.eclipse.jdt.internal.debug.ui.JDIContentAssistPreference;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.propertypages.PropertyPageMessages;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class JavaVariablesDetailPane
extends DefaultDetailPane {
    public static final String JAVA_VARIABLE_DETAIL_PANE_VARIABLES = JDIDebugUIPlugin.getUniqueIdentifier() + ".JAVA_VARIABLE_DETAIL_PANE_VARIABLES";
    public static final String NAME = PropertyPageMessages.JavaVariableDetailsPane_name;
    public static final String DESCRIPTION = PropertyPageMessages.JavaVariableDetailsPane_description;
    private FocusListener focusListener;
    private Composite fDetailPaneContainer;
    private Combo fExpressionHistory;
    private final IDialogSettings fExpressionHistoryDialogSettings = DialogSettings.getOrCreateSection((IDialogSettings)JDIDebugUIPlugin.getDefault().getDialogSettings(), (String)"expressionHistory");
    private static final int MAX_HISTORY_SIZE = 20;
    private static final String DS_SECTION_EXPRESSION_HISTORY = "expressionHistory";
    private static final String DS_KEY_HISTORY_ENTRY_COUNT = "expressionHistoryEntryCount";
    private static final String DS_KEY_HISTORY_ENTRY_PREFIX = "expressionHistoryEntry_";
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("\r\n|\r|\n");
    private IJavaVariable fVariable;
    private IValue fValue;
    private boolean textModified = false;

    public Control createControl(Composite parent) {
        if (!this.isInView()) {
            Control c = super.createControl(parent);
            c.setBackground(ExpressionInformationControlCreator.getSystemBackgroundColor());
            return c;
        }
        Composite container = parent;
        if (this.fExpressionHistoryDialogSettings != null) {
            this.fDetailPaneContainer = container = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)1808, (int)0, (int)0);
            this.fExpressionHistory = SWTFactory.createCombo((Composite)container, (int)12, (int)1, null);
            this.fExpressionHistory.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int historyIndex = JavaVariablesDetailPane.this.fExpressionHistory.getSelectionIndex() - 1;
                    if (historyIndex >= 0 && JavaVariablesDetailPane.this.getSourceViewer() != null) {
                        JavaVariablesDetailPane.this.getSourceViewer().getDocument().set(JavaVariablesDetailPane.this.getExpressionHistory()[historyIndex]);
                        JavaVariablesDetailPane.this.textModified = true;
                    }
                }
            });
            GridData data = new GridData(4, 128, true, false);
            this.fExpressionHistory.setLayoutData((Object)data);
            this.fExpressionHistory.setEnabled(false);
        }
        Control newControl = super.createControl(container);
        SourceViewer viewer = this.getSourceViewer();
        ControlDecoration decoration = new ControlDecoration(viewer.getControl(), 16512);
        decoration.setShowOnlyOnFocus(true);
        FieldDecoration dec = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
        decoration.setImage(dec.getImage());
        decoration.setDescriptionText(JDIContentAssistPreference.getContentAssistDescription());
        this.focusListener = new FocusListener(){

            public void focusLost(FocusEvent e) {
                JavaVariablesDetailPane.this.updateExpressionHistories();
                JavaVariablesDetailPane.this.fValue = null;
            }

            public void focusGained(FocusEvent e) {
                JavaVariablesDetailPane.this.fValue = null;
                try {
                    if (JavaVariablesDetailPane.this.fVariable != null) {
                        JavaVariablesDetailPane.this.fValue = JavaVariablesDetailPane.this.fVariable.getValue();
                    }
                }
                catch (DebugException debugException) {
                    // empty catch block
                }
            }
        };
        viewer.getTextWidget().addFocusListener(this.focusListener);
        viewer.getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaVariablesDetailPane.this.textModified = true;
            }
        });
        return newControl;
    }

    private void initializeExpressionHistoryDropDown() {
        this.fExpressionHistory.setItems(this.getExpressionHistoryLabels());
        String userHint = PropertyPageMessages.JavaVariableDetailsPane_choosePreviousExpression;
        this.fExpressionHistory.add(userHint, 0);
        this.fExpressionHistory.setText(userHint);
    }

    private String[] getExpressionHistoryLabels() {
        String[] expressions = this.getExpressionHistory();
        String[] labels = new String[expressions.length];
        int i = 0;
        while (i < expressions.length) {
            labels[i] = NEWLINE_PATTERN.matcher(expressions[i]).replaceAll(" ");
            ++i;
        }
        return labels;
    }

    private String[] getExpressionHistory() {
        return JavaVariablesDetailPane.readExpressionHistory(this.fExpressionHistoryDialogSettings);
    }

    private void updateExpressionHistories() {
        String newItem = this.getSourceViewer().getDocument().get();
        if (newItem.length() == 0 || this.fValue == null) {
            return;
        }
        String oldValue = this.fValue.toString();
        if (oldValue.charAt(0) == '\"' && oldValue.charAt(oldValue.length() - 1) == '\"') {
            oldValue = oldValue.substring(1, oldValue.length() - 1);
        }
        if (!this.textModified || newItem.equals(oldValue)) {
            return;
        }
        this.textModified = false;
        String[] globalItems = JavaVariablesDetailPane.readExpressionHistory(this.fExpressionHistoryDialogSettings);
        if (globalItems.length > 0 && newItem.equals(globalItems[0])) {
            return;
        }
        if (globalItems.length == 0) {
            globalItems = new String[1];
        } else {
            String[] tempItems = new String[globalItems.length + 1];
            System.arraycopy(globalItems, 0, tempItems, 1, globalItems.length);
            globalItems = tempItems;
        }
        globalItems[0] = newItem;
        JavaVariablesDetailPane.storeExpressionHistory(globalItems, this.fExpressionHistoryDialogSettings);
    }

    private static String[] readExpressionHistory(IDialogSettings dialogSettings) {
        int count = 0;
        try {
            count = dialogSettings.getInt(DS_KEY_HISTORY_ENTRY_COUNT);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        count = Math.min(count, 20);
        String[] expressions = new String[count];
        int i = 0;
        while (i < count) {
            expressions[i] = dialogSettings.get(DS_KEY_HISTORY_ENTRY_PREFIX + i);
            ++i;
        }
        return expressions;
    }

    private static void storeExpressionHistory(String[] expressions, IDialogSettings dialogSettings) {
        ArrayList<String> uniqueExpressions = new ArrayList<String>(new LinkedHashSet<String>(Arrays.asList(expressions)));
        int length = Math.min(uniqueExpressions.size(), 20);
        int count = 0;
        for (String expression : uniqueExpressions) {
            dialogSettings.put(DS_KEY_HISTORY_ENTRY_PREFIX + count, expression);
            if (++count >= length) break;
        }
        dialogSettings.put(DS_KEY_HISTORY_ENTRY_COUNT, count);
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getID() {
        return JAVA_VARIABLE_DETAIL_PANE_VARIABLES;
    }

    public String getName() {
        return NAME;
    }

    public void display(IStructuredSelection selection) {
        if (this.fExpressionHistory != null && selection != null && selection.getFirstElement() instanceof IJavaVariable) {
            IJavaVariable variable = (IJavaVariable)selection.getFirstElement();
            if (this.fVariable == null || !this.fVariable.equals(variable)) {
                this.fVariable = variable;
                this.fExpressionHistory.setEnabled(true);
                this.initializeExpressionHistoryDropDown();
            }
        }
        super.display(selection);
    }

    protected void clearSourceViewer() {
        this.fVariable = null;
        if (this.fExpressionHistory != null) {
            this.fExpressionHistory.setEnabled(false);
        }
        super.clearSourceViewer();
    }

    public void dispose() {
        if (this.fExpressionHistory != null) {
            this.fExpressionHistory.dispose();
        }
        if (this.fDetailPaneContainer != null) {
            this.fDetailPaneContainer.dispose();
        }
        if (this.focusListener != null && this.getSourceViewer() != null && this.getSourceViewer().getTextWidget() != null) {
            this.getSourceViewer().getTextWidget().removeFocusListener(this.focusListener);
        }
        super.dispose();
    }
}

