/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.ecl.internal.impl.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.dispatch.ServiceDispatchingUtils;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;
import org.eclipse.rcptt.tesla.ecl.impl.rap.AbstractActionService;
import org.eclipse.rcptt.tesla.ecl.internal.impl.ServiceUtil;
import org.eclipse.rcptt.tesla.ecl.internal.impl.TeslaImplPlugin;
import org.eclipse.rcptt.tesla.ecl.internal.impl.commands.ActionService;
import org.eclipse.rcptt.tesla.ecl.model.ControlHandler;
import org.eclipse.rcptt.tesla.ecl.model.Select;

public class SelectService
extends AbstractActionService {
    @Override
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        IStatus result = ServiceDispatchingUtils.handleWithExtensions((Command)command, (IProcess)context);
        if (result != null) {
            return result;
        }
        return super.service(command, context);
    }

    @Override
    protected Object exec(Command command) throws CoreException {
        if (command instanceof Select) {
            return this.handleSelect((Select)command);
        }
        return null;
    }

    private ControlHandler handleSelect(Select s) throws CoreException {
        if (!s.getControl().getKind().equals((Object)ElementKind.Combo)) {
            EList pathList = s.getItems();
            int size = pathList.size();
            if (size == 0) {
                throw new CoreException(TeslaImplPlugin.error("Path is not specified"));
            }
            ArrayList<List<String>> list = new ArrayList<List<String>>(size);
            for (Object item : pathList) {
                list.add(ServiceUtil.processSelectItems(item, s.getColumn()));
            }
            ActionService.getViewerUIElement(s.getControl()).setMultiSelectionList(list, s.isAll());
            return s.getControl();
        }
        EList items = s.getItems();
        if (items == null || items.size() < 1) {
            throw new CoreException(TeslaImplPlugin.error("No item to select"));
        }
        Object item = items.get(0);
        if (item == null) {
            throw new CoreException(TeslaImplPlugin.error("Bad item to select"));
        }
        String text = item.toString();
        ActionService.getTextUIElement(s.getControl()).setText(text, true, false);
        return s.getControl();
    }
}

