/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.swt.profiling;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rcptt.tesla.swt.profiling.IProfilingListener;

public class ProfilingEventManager {
    private static ProfilingEventManager INSTANCE = null;
    private List<IProfilingListener> listeners = new ArrayList<IProfilingListener>();

    public static synchronized ProfilingEventManager getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new ProfilingEventManager();
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IProfilingListener listener) {
        List<IProfilingListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IProfilingListener listener) {
        List<IProfilingListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getListenersLength() {
        List<IProfilingListener> list = this.listeners;
        synchronized (list) {
            return this.listeners.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncRunning(Runnable value) {
        List<IProfilingListener> list = this.listeners;
        synchronized (list) {
            for (IProfilingListener l : this.listeners) {
                l.asyncRunning(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncDone(Runnable value) {
        List<IProfilingListener> list = this.listeners;
        synchronized (list) {
            for (IProfilingListener l : this.listeners) {
                l.asyncDone(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncAdded(Runnable async, boolean value) {
        List<IProfilingListener> list = this.listeners;
        synchronized (list) {
            for (IProfilingListener l : this.listeners) {
                l.asyncAdded(async, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timerAdded(Runnable run) {
        List<IProfilingListener> list = this.listeners;
        synchronized (list) {
            for (IProfilingListener l : this.listeners) {
                l.timerAdded(run);
            }
        }
    }
}

