/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyContentProvider;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.jdt.internal.ui.callhierarchy.MethodWrapperWorkbenchAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class DeferredMethodWrapper
extends MethodWrapperWorkbenchAdapter
implements IDeferredWorkbenchAdapter {
    private final CallHierarchyContentProvider fProvider;

    DeferredMethodWrapper(CallHierarchyContentProvider provider, MethodWrapper methodWrapper) {
        super(methodWrapper);
        this.fProvider = provider;
    }

    private Object getCalls(IProgressMonitor monitor) {
        return this.getMethodWrapper().getCalls(monitor);
    }

    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        DeferredMethodWrapper deferredMethodWrapper = (DeferredMethodWrapper)object;
        try {
            try {
                this.fProvider.startFetching();
                collector.add((Object[])deferredMethodWrapper.getCalls(monitor), monitor);
                collector.done();
            }
            catch (OperationCanceledException operationCanceledException) {
                final MethodWrapper methodWrapper = deferredMethodWrapper.getMethodWrapper();
                if (!CallHierarchyContentProvider.isExpandWithConstructors(methodWrapper)) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            CallHierarchyViewPart viewPart = DeferredMethodWrapper.this.fProvider.getViewPart();
                            if (viewPart != null && !viewPart.getViewer().getControl().isDisposed()) {
                                DeferredMethodWrapper.this.fProvider.collapseAndRefresh(methodWrapper);
                            }
                        }
                    });
                }
                this.fProvider.doneFetching();
            }
            catch (Exception e) {
                JavaPlugin.log(e);
                this.fProvider.doneFetching();
            }
        }
        finally {
            this.fProvider.doneFetching();
        }
    }

    public boolean isContainer() {
        return true;
    }

    public ISchedulingRule getRule(Object o) {
        return new BatchSimilarSchedulingRule("org.eclipse.jdt.ui.callhierarchy.methodwrapper");
    }

    public Object[] getChildren(Object o) {
        return this.fProvider.fetchChildren(((DeferredMethodWrapper)o).getMethodWrapper());
    }

    private class BatchSimilarSchedulingRule
    implements ISchedulingRule {
        public String id;

        public BatchSimilarSchedulingRule(String id) {
            this.id = id;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            if (rule instanceof BatchSimilarSchedulingRule) {
                return ((BatchSimilarSchedulingRule)rule).id.equals(this.id);
            }
            return false;
        }

        public boolean contains(ISchedulingRule rule) {
            return this == rule;
        }
    }
}

