/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.base.acquire;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.passage.lbc.internal.base.acquire.ProtectedGrantCapacity;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.equinox.EquinoxPassage;
import org.eclipse.passage.lic.licenses.model.api.FeatureGrant;
import org.eclipse.passage.lic.licenses.model.api.GrantAcqisition;
import org.eclipse.passage.lic.licenses.model.meta.LicensesFactory;

final class AcquiredGrantsStorage {
    private final Map<LicensedProduct, Map<String, Collection<GrantAcqisition>>> locks = new HashMap<LicensedProduct, Map<String, Collection<GrantAcqisition>>>();
    private final String feature = "org.eclipse.passage.lbc.acquire.concurrent";
    private final Logger log = LogManager.getLogger(this.getClass());

    /*
     * Enabled aggressive block sorting
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    AcquiredGrantsStorage() {
        AcquiredGrantsStorage acquiredGrantsStorage = this;
        // MONITORENTER : acquiredGrantsStorage
        // MONITOREXIT : acquiredGrantsStorage
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Optional<GrantAcqisition> acquire(LicensedProduct product, String user, FeatureGrant grant) {
        this.checkFlsLicense();
        int capacity = new ProtectedGrantCapacity(grant).get();
        AcquiredGrantsStorage acquiredGrantsStorage = this;
        synchronized (acquiredGrantsStorage) {
            Collection<GrantAcqisition> acquisitions = this.grantLocks(product, grant.getIdentifier());
            if (acquisitions.size() < capacity) {
                GrantAcqisition acquistion = this.acquistion(grant, user);
                acquisitions.add(acquistion);
                this.logAcquisition("acquire", acquistion, product);
                return Optional.of(acquistion);
            }
        }
        return Optional.empty();
    }

    private void checkFlsLicense() {
        if (!new EquinoxPassage().canUse("org.eclipse.passage.lbc.acquire.concurrent")) {
            this.log.error(String.format("FLS feature %s is not covered by a license", "org.eclipse.passage.lbc.acquire.concurrent"));
        }
    }

    synchronized boolean release(LicensedProduct product, GrantAcqisition acquisition) {
        Collection<GrantAcqisition> colleagues = this.grantLocks(product, acquisition.getGrant());
        for (GrantAcqisition colleage : colleagues) {
            if (!this.matches(colleage, acquisition)) continue;
            colleagues.remove(colleage);
            this.logAcquisition("release", colleage, product);
            return true;
        }
        return false;
    }

    private boolean matches(GrantAcqisition actual, GrantAcqisition expected) {
        return actual.getIdentifier().equals(expected.getIdentifier());
    }

    private GrantAcqisition acquistion(FeatureGrant grant, String user) {
        GrantAcqisition acquisition = LicensesFactory.eINSTANCE.createGrantAcqisition();
        acquisition.setCreated(new Date());
        acquisition.setFeature(grant.getFeature().getIdentifier());
        acquisition.setGrant(grant.getIdentifier());
        acquisition.setIdentifier(UUID.randomUUID().toString());
        acquisition.setUser(user);
        return acquisition;
    }

    private Collection<GrantAcqisition> grantLocks(LicensedProduct product, String grant) {
        return this.productLocks(product).computeIfAbsent(grant, id -> new HashSet());
    }

    private Map<String, Collection<GrantAcqisition>> productLocks(LicensedProduct product) {
        return this.locks.computeIfAbsent(product, p -> new HashMap());
    }

    private void logAcquisition(String operation, GrantAcqisition grant, LicensedProduct product) {
        this.log.debug(String.format("|%s| acquisiiton [%s] for user %s on feature %s product %s v%s", operation, grant.getIdentifier(), grant.getUser(), grant.getFeature(), product.identifier(), product.version()));
    }
}

