/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Win32DPIUtils;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ProgressBar
extends Control {
    static final int DELAY = 100;
    static final int TIMER_ID = 100;
    static final int MINIMUM_WIDTH = 100;
    static final long ProgressBarProc;
    static final TCHAR ProgressBarClass;

    static {
        ProgressBarClass = new TCHAR(0, "msctls_progress32", true);
        WNDCLASS lpWndClass = new WNDCLASS();
        OS.GetClassInfo(0L, ProgressBarClass, lpWndClass);
        ProgressBarProc = lpWndClass.lpfnWndProc;
        lpWndClass.hInstance = OS.GetModuleHandle(null);
        lpWndClass.style &= 0xFFFFBFFF;
        lpWndClass.style |= 8;
        OS.RegisterClass(ProgressBarClass, lpWndClass);
    }

    public ProgressBar(Composite parent, int style) {
        super(parent, ProgressBar.checkStyle(style));
    }

    @Override
    long callWindowProc(long hwnd, int msg, long wParam, long lParam) {
        if (this.handle == 0L) {
            return 0L;
        }
        return OS.CallWindowProc(ProgressBarProc, hwnd, msg, wParam, lParam);
    }

    static int checkStyle(int style) {
        return ProgressBar.checkBits(style |= 0x80000, 256, 512, 0, 0, 0, 0);
    }

    @Override
    Point computeSizeInPixels(Point hintInPoints, boolean changed) {
        this.checkWidget();
        int zoom = this.getZoom();
        Point hintInPixels = Win32DPIUtils.pointToPixelAsSize(hintInPoints, zoom);
        int border = this.getBorderWidthInPixels();
        int width = border * 2;
        int height = border * 2;
        if ((this.style & 0x100) != 0) {
            width += this.getSystemMetrics(21) * 10;
            height += this.getSystemMetrics(3);
        } else {
            width += this.getSystemMetrics(2);
            height += this.getSystemMetrics(20) * 10;
        }
        if (hintInPoints.x != -1) {
            width = hintInPixels.x + border * 2;
        }
        if (hintInPoints.y != -1) {
            height = hintInPixels.y + border * 2;
        }
        return new Point(width, height);
    }

    @Override
    void createHandle() {
        super.createHandle();
        if (this.display.progressbarUseColors) {
            char[] noTheme = new char[1];
            OS.SetWindowTheme(this.handle, noTheme, noTheme);
        }
        this.startTimer();
    }

    @Override
    int defaultForeground() {
        return OS.GetSysColor(13);
    }

    public int getMaximum() {
        this.checkWidget();
        return (int)OS.SendMessage(this.handle, 1031, 0L, 0L);
    }

    public int getMinimum() {
        this.checkWidget();
        return (int)OS.SendMessage(this.handle, 1031, 1L, 0L);
    }

    public int getSelection() {
        this.checkWidget();
        return (int)OS.SendMessage(this.handle, 1032, 0L, 0L);
    }

    public int getState() {
        this.checkWidget();
        int state = (int)OS.SendMessage(this.handle, 1041, 0L, 0L);
        switch (state) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 4;
            }
        }
        return 0;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.stopTimer();
    }

    void startTimer() {
        if ((this.style & 2) != 0) {
            int bits = OS.GetWindowLong(this.handle, -16);
            if ((bits & 8) == 0) {
                OS.SetTimer(this.handle, 100L, 100, 0L);
            } else {
                OS.SendMessage(this.handle, 1034, 1L, 100L);
            }
        }
    }

    void stopTimer() {
        if ((this.style & 2) != 0) {
            int bits = OS.GetWindowLong(this.handle, -16);
            if ((bits & 8) == 0) {
                OS.KillTimer(this.handle, 100L);
            } else {
                OS.SendMessage(this.handle, 1034, 0L, 0L);
            }
        }
    }

    @Override
    void setBackgroundPixel(int pixel) {
        if (pixel == -1) {
            pixel = -16777216;
        }
        OS.SendMessage(this.handle, 8193, 0L, pixel);
    }

    @Override
    void setForegroundPixel(int pixel) {
        if (pixel == -1) {
            pixel = -16777216;
        }
        OS.SendMessage(this.handle, 1033, 0L, pixel);
    }

    public void setMaximum(int value) {
        this.checkWidget();
        int minimum = (int)OS.SendMessage(this.handle, 1031, 1L, 0L);
        if (minimum >= 0 && minimum < value) {
            OS.SendMessage(this.handle, 1030, (long)minimum, value);
        }
    }

    public void setMinimum(int value) {
        this.checkWidget();
        int maximum = (int)OS.SendMessage(this.handle, 1031, 0L, 0L);
        if (value >= 0 && value < maximum) {
            OS.SendMessage(this.handle, 1030, (long)value, maximum);
        }
    }

    public void setSelection(int value) {
        this.checkWidget();
        OS.SendMessage(this.handle, 1026, (long)value, 0L);
        long state = OS.SendMessage(this.handle, 1041, 0L, 0L);
        if (state != 1L) {
            OS.SendMessage(this.handle, 1026, (long)value, 0L);
        }
    }

    public void setState(int state) {
        this.checkWidget();
        switch (state) {
            case 0: {
                OS.SendMessage(this.handle, 1040, 1L, 0L);
                break;
            }
            case 1: {
                OS.SendMessage(this.handle, 1040, 2L, 0L);
                break;
            }
            case 4: {
                OS.SendMessage(this.handle, 1040, 3L, 0L);
            }
        }
    }

    @Override
    int widgetStyle() {
        int bits = super.widgetStyle();
        if ((this.style & 0x10000) != 0) {
            bits |= 1;
        }
        if ((this.style & 0x200) != 0) {
            bits |= 4;
        }
        if ((this.style & 2) != 0) {
            bits |= 8;
        }
        return bits;
    }

    @Override
    TCHAR windowClass() {
        return ProgressBarClass;
    }

    @Override
    long windowProc() {
        return ProgressBarProc;
    }

    @Override
    LRESULT WM_GETDLGCODE(long wParam, long lParam) {
        LRESULT result = super.WM_GETDLGCODE(wParam, lParam);
        if (result != null) {
            return result;
        }
        return new LRESULT(256L);
    }

    @Override
    LRESULT WM_SIZE(long wParam, long lParam) {
        LRESULT result = super.WM_SIZE(wParam, lParam);
        if (result != null) {
            return result;
        }
        if ((this.style & 2) != 0 && !OS.IsAppThemed()) {
            int oldBits;
            this.forceResize();
            RECT rect = new RECT();
            OS.GetClientRect(this.handle, rect);
            int newBits = oldBits = OS.GetWindowLong(this.handle, -16);
            newBits = rect.right - rect.left < 100 ? (newBits &= 0xFFFFFFF7) : (newBits |= 8);
            if (newBits != oldBits) {
                this.stopTimer();
                OS.SetWindowLong(this.handle, -16, newBits);
                this.startTimer();
            }
        }
        return result;
    }

    @Override
    LRESULT WM_TIMER(long wParam, long lParam) {
        int bits;
        LRESULT result = super.WM_TIMER(wParam, lParam);
        if (result != null) {
            return result;
        }
        if ((this.style & 2) != 0 && ((bits = OS.GetWindowLong(this.handle, -16)) & 8) == 0 && wParam == 100L) {
            OS.SendMessage(this.handle, 1029, 0L, 0L);
        }
        return result;
    }
}

