/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.model.WorkbenchResource;

public class WorkbenchFile
extends WorkbenchResource {
    public static QualifiedName IMAGE_CACHE_KEY = new QualifiedName(WorkbenchPlugin.PI_WORKBENCH, "WorkbenchFileImage");

    @Override
    protected ImageDescriptor getBaseImage(IResource resource) {
        ImageDescriptor image;
        IContentType contentType = null;
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            try {
                ImageDescriptor cached = (ImageDescriptor)file.getSessionProperty(IMAGE_CACHE_KEY);
                if (cached != null) {
                    return cached;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            contentType = IDE.guessContentType(file);
        }
        if ((image = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(resource.getName(), contentType)) == null) {
            image = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE");
        }
        return image;
    }
}

