/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.internal.SWTFontRegistry;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICS;
import org.eclipse.swt.internal.win32.OS;

final class DefaultSWTFontRegistry
implements SWTFontRegistry {
    private static FontData KEY_SYSTEM_FONTS = new FontData();
    private Map<FontData, Font> fontsMap = new HashMap<FontData, Font>();
    private Device device;

    DefaultSWTFontRegistry(Device device) {
        this.device = device;
    }

    @Override
    public Font getSystemFont(int zoom) {
        if (this.fontsMap.containsKey(KEY_SYSTEM_FONTS)) {
            return this.fontsMap.get(KEY_SYSTEM_FONTS);
        }
        long hFont = 0L;
        NONCLIENTMETRICS info = new NONCLIENTMETRICS();
        info.cbSize = NONCLIENTMETRICS.sizeof;
        if (OS.SystemParametersInfo(41, 0, info, 0)) {
            hFont = OS.CreateFontIndirect(info.lfMessageFont);
        }
        if (hFont == 0L) {
            hFont = OS.GetStockObject(17);
        }
        if (hFont == 0L) {
            hFont = OS.GetStockObject(13);
        }
        Font font = Font.win32_new(this.device, hFont);
        this.registerFont(KEY_SYSTEM_FONTS, font);
        return font;
    }

    @Override
    public Font getFont(FontData fontData, int zoom) {
        Font font;
        if (this.fontsMap.containsKey(fontData)) {
            font = this.fontsMap.get(fontData);
            if (font.isDisposed()) {
                this.fontsMap.remove(fontData);
            } else {
                return font;
            }
        }
        font = new Font(this.device, fontData);
        this.registerFont(fontData, font);
        return font;
    }

    private Font registerFont(FontData fontData, Font font) {
        this.fontsMap.put(fontData, font);
        return font;
    }

    @Override
    public void dispose() {
        for (Font font : this.fontsMap.values()) {
            if (font == null) continue;
            font.dispose();
        }
    }
}

