/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.felix.scr.impl.inject.RefPair;
import org.apache.felix.scr.impl.inject.ScrComponentContext;
import org.apache.felix.scr.impl.logger.InternalLogger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class SingleRefPair<S, T>
extends RefPair<S, T> {
    private final AtomicReference<T> serviceObjectRef = new AtomicReference();

    public SingleRefPair(ServiceReference<T> ref) {
        super(ref);
    }

    @Override
    public T getServiceObject(ScrComponentContext key) {
        return this.serviceObjectRef.get();
    }

    @Override
    public boolean setServiceObject(ScrComponentContext key, T serviceObject) {
        boolean set = this.serviceObjectRef.compareAndSet(null, serviceObject);
        if (serviceObject != null) {
            this.clearFailed();
        }
        return set;
    }

    @Override
    public T ungetServiceObject(ScrComponentContext key) {
        return null;
    }

    @Override
    public void ungetServiceObjects(BundleContext bundleContext) {
        Object service = this.serviceObjectRef.getAndSet(null);
        if (service != null && bundleContext != null) {
            SingleRefPair.safeUngetService(bundleContext, this.getRef());
        }
    }

    public String toString() {
        return "[RefPair: ref: [" + this.getRef() + "] service: [" + this.serviceObjectRef.get() + "]]";
    }

    @Override
    public boolean getServiceObject(ScrComponentContext key, BundleContext context) {
        Object service = context.getService(this.getRef());
        if (service == null) {
            this.markFailed();
            key.getLogger().log(InternalLogger.Level.WARN, "Could not get service from ref {0}", null, this.getRef());
            return false;
        }
        if (!this.setServiceObject(key, service)) {
            SingleRefPair.safeUngetService(context, this.getRef());
        }
        return true;
    }

    private static void safeUngetService(BundleContext context, ServiceReference<?> ref) {
        try {
            context.ungetService(ref);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

