/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.oomph.base.provider.ModelElementItemProvider;
import org.eclipse.oomph.setup.AttributeRule;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.util.StringUtil;

public class AttributeRuleItemProvider
extends ModelElementItemProvider {
    public AttributeRuleItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addAttributeURIPropertyDescriptor(object);
            this.addValuePropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addAttributeURIPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_AttributeRule_attributeURI_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_AttributeRule_attributeURI_feature", "_UI_AttributeRule_type"), (EStructuralFeature)SetupPackage.Literals.ATTRIBUTE_RULE__ATTRIBUTE_URI, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addValuePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_AttributeRule_value_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_AttributeRule_value_feature", "_UI_AttributeRule_type"), (EStructuralFeature)SetupPackage.Literals.ATTRIBUTE_RULE__VALUE, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/AttributeRule"));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        AttributeRule attributeRule = (AttributeRule)object;
        String name = null;
        URI attributeURI = attributeRule.getAttributeURI();
        if (attributeURI != null && (name = attributeURI.fragment()) != null && name.startsWith("//")) {
            name = name.substring(2).replace('/', '.');
        }
        if (StringUtil.isEmpty(name)) {
            return this.getString("_UI_AttributeRule_type");
        }
        Object label = name;
        String value = attributeRule.getValue();
        if (value != null) {
            label = value.length() == 0 ? (String)label + " = \"\"" : (String)label + " = " + value;
        }
        return label;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(AttributeRule.class)) {
            case 1: 
            case 2: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }
}

