/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.publisher.eclipse;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.p2.core.helpers.SecureXMLUtil;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.core.helpers.URLUtil;
import org.eclipse.equinox.internal.p2.publisher.eclipse.FeatureInstallMode;
import org.eclipse.equinox.internal.p2.publisher.eclipse.IProductDescriptor;
import org.eclipse.equinox.internal.p2.publisher.eclipse.Messages;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ProductContentType;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.equinox.p2.publisher.eclipse.FeatureEntry;
import org.eclipse.equinox.p2.repository.IRepositoryReference;
import org.eclipse.equinox.p2.repository.spi.RepositoryReference;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.publishing.Activator;
import org.osgi.framework.BundleContext;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ProductFile
extends DefaultHandler
implements IProductDescriptor {
    public static final String GENERIC_VERSION_NUMBER = "0.0.0";
    private static final String ATTRIBUTE_PATH = "path";
    private static final String ATTRIBUTE_ICON = "icon";
    protected static final String ATTRIBUTE_FRAGMENT = "fragment";
    private static final String ATTRIBUTE_APPLICATION = "application";
    private static final String ATTRIBUTE_INCLUDE_LAUNCHERS = "includeLaunchers";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_VALUE = "value";
    private static final String ATTRIBUTE_LOCATION = "location";
    private static final String ATTRIBUTE_AUTO_START = "autoStart";
    private static final String ATTRIBUTE_START_LEVEL = "startLevel";
    protected static final String ATTRIBUTE_VERSION = "version";
    protected static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_UID = "uid";
    private static final String ATTRIBUTE_CONTENT_TYPE = "type";
    private static final String ATTRIBUTE_OS = "os";
    private static final String ATTRIBUTE_ARCH = "arch";
    private static final String ATTRIBUTE_ENABLED = "enabled";
    private static final String ATTRIBUTE_FEATURE_INSTALL_MODE = "installMode";
    private static final String PROPERTY_ECLIPSE_APPLICATION = "eclipse.application";
    private static final String PROPERTY_ECLIPSE_PRODUCT = "eclipse.product";
    private static final String PROGRAM_ARGS = "programArgs";
    private static final String PROGRAM_ARGS_LINUX = "programArgsLin";
    private static final String PROGRAM_ARGS_MAC = "programArgsMac";
    private static final String PROGRAM_ARGS_SOLARIS = "programArgsSol";
    private static final String PROGRAM_ARGS_WIN = "programArgsWin";
    private static final String VM = "vm";
    private static final String VM_ARGS = "vmArgs";
    private static final String VM_ARGS_LINUX = "vmArgsLin";
    private static final String VM_ARGS_MAC = "vmArgsMac";
    private static final String VM_ARGS_SOLARIS = "vmArgsSol";
    private static final String VM_ARGS_WIN = "vmArgsWin";
    private static final String SOLARIS_LARGE = "solarisLarge";
    private static final String SOLARIS_MEDIUM = "solarisMedium";
    private static final String SOLARIS_SMALL = "solarisSmall";
    private static final String SOLARIS_TINY = "solarisTiny";
    private static final String WIN32_16_LOW = "winSmallLow";
    private static final String WIN32_16_HIGH = "winSmallHigh";
    private static final String WIN32_24_LOW = "win24Low";
    private static final String WIN32_32_LOW = "winMediumLow";
    private static final String WIN32_32_HIGH = "winMediumHigh";
    private static final String WIN32_48_LOW = "winLargeLow";
    private static final String WIN32_48_HIGH = "winLargeHigh";
    private static final String WIN32_256_HIGH = "winExtraLargeHigh";
    private static final String OS_WIN32 = "win32";
    private static final String OS_LINUX = "linux";
    private static final String OS_SOLARIS = "solaris";
    private static final String OS_MACOSX = "macosx";
    private static final String OS_MACOS = "macos";
    private static final String OS_WINDOWS = "windows";
    private static final String ARCH_X86 = "x86";
    private static final String ARCH_X86_64 = "x86_64";
    private static final String ARCH_PPC = "ppc";
    private static final String ARCH_IA_64 = "ia64";
    private static final String ARCH_IA_64_32 = "ia64_32";
    private static final String ARCH_PA_RISC = "PA_RISC";
    private static final String ARCH_SPARC = "sparc";
    private static final String EL_FEATURES = "features";
    private static final String EL_FEATURE = "feature";
    private static final String EL_PLUGINS = "plugins";
    private static final String EL_PLUGIN = "plugin";
    private static final String EL_PRODUCT = "product";
    private static final String EL_PROPERTY = "property";
    private static final String EL_CONFIG_INI = "configIni";
    private static final String EL_LAUNCHER = "launcher";
    private static final String EL_LAUNCHER_ARGS = "launcherArgs";
    private static final String EL_SPLASH = "splash";
    private static final String EL_CONFIGURATIONS = "configurations";
    private static final String EL_LICENSE = "license";
    private static final String EL_URL = "url";
    private static final String EL_TEXT = "text";
    private static final String EL_ARCH_X86 = "argsX86";
    private static final String EL_ARCH_X86_64 = "argsX86_64";
    private static final String EL_ARCH_PPC = "argsPPC";
    private static final String EL_ARCH_IA_64 = "argsIA_64";
    private static final String EL_ARCH_IA_64_32 = "argsIA_64_32";
    private static final String EL_ARCH_PA_RISC = "argsPA_RISC";
    private static final String EL_ARCH_SPARC = "argsSPARC";
    private static final String EL_REPOSITORIES = "repositories";
    private static final String EL_REPOSITORY = "repository";
    private static final int STATE_START = 0;
    private static final int STATE_PRODUCT = 1;
    private static final int STATE_LAUNCHER = 2;
    private static final int STATE_LAUNCHER_ARGS = 3;
    private static final int STATE_PLUGINS = 4;
    private static final int STATE_FEATURES = 5;
    private static final int STATE_PROGRAM_ARGS = 6;
    private static final int STATE_PROGRAM_ARGS_LINUX = 7;
    private static final int STATE_PROGRAM_ARGS_MAC = 8;
    private static final int STATE_PROGRAM_ARGS_SOLARIS = 9;
    private static final int STATE_PROGRAM_ARGS_WIN = 10;
    private static final int STATE_VM_ARGS = 11;
    private static final int STATE_VM_ARGS_LINUX = 12;
    private static final int STATE_VM_ARGS_MAC = 13;
    private static final int STATE_VM_ARGS_SOLARIS = 14;
    private static final int STATE_VM_ARGS_WIN = 15;
    private static final int STATE_CONFIG_INI = 16;
    private static final int STATE_CONFIGURATIONS = 17;
    private static final int STATE_LICENSE = 18;
    private static final int STATE_LICENSE_URL = 19;
    private static final int STATE_LICENSE_TEXT = 20;
    private static final int STATE_ARCH_X86 = 21;
    private static final int STATE_ARCH_X86_64 = 22;
    private static final int STATE_ARCH_PPC = 23;
    private static final int STATE_ARCH_IA_64 = 24;
    private static final int STATE_ARCH_IA_64_32 = 25;
    private static final int STATE_ARCH_PA_RISC = 26;
    private static final int STATE_ARCH_SPARC = 27;
    private static final int STATE_REPOSITORIES = 28;
    private static final int STATE_VM = 29;
    private static final int STATE_VM_LINUX = 31;
    private static final int STATE_VM_MACOS = 32;
    private static final int STATE_VM_WINDOWS = 33;
    private static final String PI_PDEBUILD = "org.eclipse.pde.build";
    private static final int EXCEPTION_PRODUCT_FORMAT = 23;
    private static final int EXCEPTION_PRODUCT_FILE = 24;
    private int state = 0;
    private int outerState = 0;
    private String platformKeyPrefix = null;
    private SAXParser parser;
    private String launcherName = null;
    private final Map<String, Collection<String>> icons = new HashMap<String, Collection<String>>(6);
    private String configPath = null;
    private final Map<String, String> platformSpecificConfigPaths = new HashMap<String, String>();
    private String configPlatform = null;
    private String platformConfigPath = null;
    private String id = null;
    private String uid = null;
    private ProductContentType productContentType = null;
    protected List<FeatureEntry> plugins = new ArrayList<FeatureEntry>();
    private final List<FeatureEntry> features = new ArrayList<FeatureEntry>();
    private final List<FeatureEntry> rootFeatures = new ArrayList<FeatureEntry>();
    private String splashLocation = null;
    private String productName = null;
    private String application = null;
    private String version = null;
    private Properties launcherArgs = new Properties();
    private final File location;
    private List<BundleInfo> bundleInfos;
    private Map<String, String> properties;
    private HashMap<String, HashMap<String, String>> filteredProperties;
    private boolean includeLaunchers = true;
    private String licenseURL;
    private String licenseText = null;
    private final String currentOS;
    private final List<IRepositoryReference> repositories = new ArrayList<IRepositoryReference>();
    private final Map<String, String> vms = new HashMap<String, String>();

    private static String normalize(String text) {
        if (text == null || text.trim().length() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder(text.length());
        boolean haveSpace = false;
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (Character.isWhitespace(c)) {
                if (!haveSpace) {
                    haveSpace = true;
                    result.append(" ");
                }
            } else {
                haveSpace = false;
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public ProductFile(String location, String os) throws CoreException {
        this.currentOS = os;
        this.location = new File(location);
        try {
            SAXParserFactory parserFactory = SecureXMLUtil.newSecureSAXParserFactory();
            parserFactory.setNamespaceAware(true);
            this.parser = parserFactory.newSAXParser();
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(location));
            try {
                this.parser.parse(new InputSource(in), (DefaultHandler)this);
            }
            finally {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (ParserConfigurationException e) {
            throw new CoreException((IStatus)new Status(4, PI_PDEBUILD, 23, NLS.bind((String)Messages.exception_productParse, (Object)location), (Throwable)e));
        }
        catch (SAXException e) {
            throw new CoreException((IStatus)new Status(4, PI_PDEBUILD, 23, NLS.bind((String)Messages.exception_productParse, (Object)location), (Throwable)e));
        }
        catch (FileNotFoundException e) {
            throw new CoreException((IStatus)new Status(4, PI_PDEBUILD, 24, NLS.bind((String)Messages.exception_missingElement, (Object)location), null));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, PI_PDEBUILD, 23, NLS.bind((String)Messages.exception_productParse, (Object)location), (Throwable)e));
        }
    }

    public ProductFile(String location) throws Exception {
        this(location, null);
    }

    @Override
    public String getLauncherName() {
        return this.launcherName;
    }

    @Override
    public File getLocation() {
        return this.location;
    }

    @Override
    public Map<String, String> getConfigurationProperties() {
        return this.getConfigurationProperties(null, null);
    }

    @Override
    public Map<String, String> getConfigurationProperties(String os, String arch) {
        HashMap<String, String> result;
        HashMap<String, String> hashMap = result = this.properties != null ? this.properties : new HashMap<String, String>();
        if (this.filteredProperties != null) {
            String[] filteredKeys = new String[3];
            if (os == null) {
                if (arch != null && arch.length() > 0) {
                    filteredKeys[0] = "." + arch;
                }
            } else if (arch == null) {
                filteredKeys[1] = os + ".";
            } else {
                filteredKeys[0] = "." + arch;
                filteredKeys[1] = os + ".";
                filteredKeys[2] = os + "." + arch;
            }
            String[] stringArray = filteredKeys;
            int n = filteredKeys.length;
            int n2 = 0;
            while (n2 < n) {
                HashMap<String, String> innerMap;
                String filteredKey = stringArray[n2];
                if (filteredKey != null && (innerMap = this.filteredProperties.get(filteredKey)) != null) {
                    result.putAll(innerMap);
                }
                ++n2;
            }
        }
        if (this.application != null && !result.containsKey(PROPERTY_ECLIPSE_APPLICATION)) {
            result.put(PROPERTY_ECLIPSE_APPLICATION, this.application);
        }
        if (this.id != null && !result.containsKey(PROPERTY_ECLIPSE_PRODUCT)) {
            result.put(PROPERTY_ECLIPSE_PRODUCT, this.id);
        }
        return result;
    }

    @Override
    public List<IVersionedId> getBundles() {
        ArrayList<IVersionedId> result = new ArrayList<IVersionedId>();
        for (FeatureEntry plugin : this.plugins) {
            result.add((IVersionedId)new VersionedId(plugin.getId(), plugin.getVersion()));
        }
        return result;
    }

    @Override
    public boolean hasBundles() {
        return !this.plugins.isEmpty();
    }

    @Override
    public List<BundleInfo> getBundleInfos() {
        return this.bundleInfos != null ? this.bundleInfos : Collections.emptyList();
    }

    @Override
    public List<IVersionedId> getFeatures() {
        return this.getFeatures(1);
    }

    @Override
    public boolean hasFeatures() {
        return !this.features.isEmpty();
    }

    @Override
    public List<IVersionedId> getFeatures(int options) {
        ArrayList<IVersionedId> result = new ArrayList<IVersionedId>();
        if ((options & 1) != 0) {
            for (FeatureEntry feature : this.features) {
                result.add((IVersionedId)new VersionedId(feature.getId(), feature.getVersion()));
            }
        }
        if ((options & 2) != 0) {
            for (FeatureEntry feature : this.rootFeatures) {
                result.add((IVersionedId)new VersionedId(feature.getId(), feature.getVersion()));
            }
        }
        return result;
    }

    public List<FeatureEntry> getProductEntries() {
        if (this.useFeatures()) {
            return Collections.unmodifiableList(this.features);
        }
        return Collections.unmodifiableList(this.plugins);
    }

    public boolean containsPlugin(String plugin) {
        List<IVersionedId> bundles = this.getBundles();
        for (IVersionedId versionedId : bundles) {
            if (!versionedId.getId().equals(plugin)) continue;
            return true;
        }
        return false;
    }

    public String[] getIcons() {
        return this.getIcons(this.currentOS);
    }

    @Override
    public String[] getIcons(String os) {
        Collection<String> result = this.icons.get(os);
        if (result == null) {
            return new String[0];
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String getConfigIniPath(String os) {
        String specific = this.platformSpecificConfigPaths.get(os);
        return specific == null ? this.configPath : specific;
    }

    public String getConfigIniPath() {
        return this.configPath;
    }

    public boolean haveCustomConfig() {
        return this.configPath != null || this.platformSpecificConfigPaths.size() > 0;
    }

    @Override
    public String getId() {
        if (this.uid != null) {
            return this.uid;
        }
        return this.id;
    }

    @Override
    public String getProductId() {
        return this.id;
    }

    @Override
    public String getSplashLocation() {
        return this.splashLocation;
    }

    @Override
    public String getProductName() {
        return this.productName;
    }

    @Override
    public String getApplication() {
        return this.application;
    }

    @Override
    public boolean useFeatures() {
        return this.productContentType == ProductContentType.FEATURES;
    }

    @Override
    public String getVersion() {
        return this.version == null || this.version.length() == 0 ? GENERIC_VERSION_NUMBER : this.version;
    }

    @Override
    public boolean includeLaunchers() {
        return this.includeLaunchers;
    }

    public Map<String, BundleInfo> getConfigurationInfo() {
        HashMap<String, BundleInfo> result = new HashMap<String, BundleInfo>();
        for (BundleInfo info : this.getBundleInfos()) {
            result.put(info.getSymbolicName(), info);
        }
        return result;
    }

    public Properties getConfigProperties() {
        Properties props = new Properties();
        for (Map.Entry<String, String> property : this.getConfigurationProperties().entrySet()) {
            props.setProperty(property.getKey(), property.getValue());
        }
        return props;
    }

    @Override
    public String getVMArguments(String os) {
        return this.getVMArguments(os, null);
    }

    @Override
    public String getVMArguments(String os, String arch) {
        String archOnAllPlatforms;
        os = os == null ? "" : os;
        String key = null;
        switch (os) {
            case "win32": {
                key = VM_ARGS_WIN;
                break;
            }
            case "linux": {
                key = VM_ARGS_LINUX;
                break;
            }
            case "macosx": {
                key = VM_ARGS_MAC;
                break;
            }
            case "solaris": {
                key = VM_ARGS_SOLARIS;
                break;
            }
        }
        arch = arch == null ? "" : arch;
        String archKey = null;
        switch (arch) {
            case "x86": {
                archKey = EL_ARCH_X86;
                break;
            }
            case "x86_64": {
                archKey = EL_ARCH_X86_64;
                break;
            }
            case "ppc": {
                archKey = EL_ARCH_PPC;
                break;
            }
            case "ia64": {
                archKey = EL_ARCH_IA_64;
                break;
            }
            case "ia64_32": {
                archKey = EL_ARCH_IA_64_32;
                break;
            }
            case "PA_RISC": {
                archKey = EL_ARCH_PA_RISC;
                break;
            }
            case "sparc": {
                archKey = EL_ARCH_SPARC;
                break;
            }
        }
        String platformArchKey = null;
        Object defaults = this.launcherArgs.getProperty(VM_ARGS);
        if (archKey != null && (archOnAllPlatforms = this.launcherArgs.getProperty("vmArgs." + archKey)) != null && archOnAllPlatforms.length() > 0) {
            defaults = (String)defaults + " " + archOnAllPlatforms;
        }
        String platform = null;
        String platformAndArch = null;
        Object args = null;
        if (key != null) {
            platform = this.launcherArgs.getProperty(key);
            if (archKey != null) {
                platformArchKey = key + "." + archKey;
                platformAndArch = this.launcherArgs.getProperty(platformArchKey);
            }
        }
        args = defaults != null ? (platform != null ? (platformAndArch != null ? (String)defaults + " " + platform + " " + platformAndArch : (String)defaults + " " + platform) : defaults) : (platform != null ? (platformAndArch != null ? platform + " " + platformAndArch : platform) : (platformAndArch != null ? platformAndArch : ""));
        return ProductFile.normalize((String)args);
    }

    @Override
    public String getProgramArguments(String os) {
        return this.getProgramArguments(os, null);
    }

    @Override
    public String getProgramArguments(String os, String arch) {
        String archOnAllPlatforms;
        os = os == null ? "" : os;
        String key = null;
        switch (os) {
            case "win32": {
                key = PROGRAM_ARGS_WIN;
                break;
            }
            case "linux": {
                key = PROGRAM_ARGS_LINUX;
                break;
            }
            case "macosx": {
                key = PROGRAM_ARGS_MAC;
                break;
            }
            case "solaris": {
                key = PROGRAM_ARGS_SOLARIS;
                break;
            }
        }
        arch = arch == null ? "" : arch;
        String archKey = null;
        switch (arch) {
            case "x86": {
                archKey = EL_ARCH_X86;
                break;
            }
            case "x86_64": {
                archKey = EL_ARCH_X86_64;
                break;
            }
            case "ppc": {
                archKey = EL_ARCH_PPC;
                break;
            }
            case "ia64": {
                archKey = EL_ARCH_IA_64;
                break;
            }
            case "ia64_32": {
                archKey = EL_ARCH_IA_64_32;
                break;
            }
            case "PA_RISC": {
                archKey = EL_ARCH_PA_RISC;
                break;
            }
            case "sparc": {
                archKey = EL_ARCH_SPARC;
                break;
            }
        }
        String platformArchKey = null;
        Object defaults = this.launcherArgs.getProperty(PROGRAM_ARGS);
        if (archKey != null && (archOnAllPlatforms = this.launcherArgs.getProperty("programArgs." + archKey)) != null && archOnAllPlatforms.length() > 0) {
            defaults = (String)defaults + " " + archOnAllPlatforms;
        }
        String platform = null;
        String platformAndArch = null;
        Object args = null;
        if (key != null) {
            platform = this.launcherArgs.getProperty(key);
            if (archKey != null) {
                platformArchKey = key + "." + archKey;
                platformAndArch = this.launcherArgs.getProperty(platformArchKey);
            }
        }
        args = defaults != null ? (platform != null ? (platformAndArch != null ? (String)defaults + " " + platform + " " + platformAndArch : (String)defaults + " " + platform) : defaults) : (platform != null ? (platformAndArch != null ? platform + " " + platformAndArch : platform) : (platformAndArch != null ? platformAndArch : ""));
        return ProductFile.normalize((String)args);
    }

    @Override
    public String getLicenseText() {
        return this.licenseText;
    }

    @Override
    public String getLicenseURL() {
        return this.licenseURL;
    }

    @Override
    public List<IRepositoryReference> getRepositoryEntries() {
        return this.repositories;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        switch (this.state) {
            case 0: {
                if (!EL_PRODUCT.equals(localName)) return;
                this.processProduct(attributes);
                this.state = 1;
                return;
            }
            case 1: {
                if (localName == null) return;
                switch (localName) {
                    case "configIni": {
                        this.processConfigIni(attributes);
                        this.state = 16;
                        return;
                    }
                    case "launcher": {
                        this.processLauncher(attributes);
                        this.state = 2;
                        return;
                    }
                    case "plugins": {
                        this.state = 4;
                        return;
                    }
                    case "features": {
                        this.state = 5;
                        return;
                    }
                    case "launcherArgs": {
                        this.state = 3;
                        return;
                    }
                    case "splash": {
                        this.splashLocation = attributes.getValue(ATTRIBUTE_LOCATION);
                        return;
                    }
                    case "configurations": {
                        this.state = 17;
                        return;
                    }
                    case "license": {
                        this.state = 18;
                        return;
                    }
                    case "repositories": {
                        this.state = 28;
                        return;
                    }
                    case "vm": {
                        this.state = 29;
                        return;
                    }
                }
                return;
            }
            case 16: {
                this.processConfigIniPlatform(localName, true);
                return;
            }
            case 2: {
                if (localName != null) {
                    switch (localName) {
                        case "solaris": {
                            this.processSolaris(attributes);
                            break;
                        }
                        case "win": {
                            this.processWin(attributes);
                            break;
                        }
                        case "linux": {
                            this.processLinux(attributes);
                            break;
                        }
                        case "macosx": {
                            this.processMac(attributes);
                            break;
                        }
                    }
                }
                if ("ico".equals(localName)) {
                    this.processIco(attributes);
                    return;
                }
                if (!"bmp".equals(localName)) return;
                this.processBmp(attributes);
                return;
            }
            case 3: {
                if (localName == null) return;
                switch (localName) {
                    case "programArgs": {
                        this.state = 6;
                        return;
                    }
                    case "programArgsLin": {
                        this.state = 7;
                        return;
                    }
                    case "programArgsMac": {
                        this.state = 8;
                        return;
                    }
                    case "programArgsSol": {
                        this.state = 9;
                        return;
                    }
                    case "programArgsWin": {
                        this.state = 10;
                        return;
                    }
                    case "vmArgs": {
                        this.state = 11;
                        return;
                    }
                    case "vmArgsLin": {
                        this.state = 12;
                        return;
                    }
                    case "vmArgsMac": {
                        this.state = 13;
                        return;
                    }
                    case "vmArgsSol": {
                        this.state = 14;
                        return;
                    }
                    case "vmArgsWin": {
                        this.state = 15;
                        return;
                    }
                }
                return;
            }
            case 6: {
                this.platformKeyPrefix = PROGRAM_ARGS;
                this.setArchState(localName);
                return;
            }
            case 7: {
                this.platformKeyPrefix = PROGRAM_ARGS_LINUX;
                this.setArchState(localName);
                return;
            }
            case 8: {
                this.platformKeyPrefix = PROGRAM_ARGS_MAC;
                this.setArchState(localName);
                return;
            }
            case 9: {
                this.platformKeyPrefix = PROGRAM_ARGS_SOLARIS;
                this.setArchState(localName);
                return;
            }
            case 10: {
                this.platformKeyPrefix = PROGRAM_ARGS_WIN;
                this.setArchState(localName);
                return;
            }
            case 11: {
                this.platformKeyPrefix = VM_ARGS;
                this.setArchState(localName);
                return;
            }
            case 12: {
                this.platformKeyPrefix = VM_ARGS_LINUX;
                this.setArchState(localName);
                return;
            }
            case 13: {
                this.platformKeyPrefix = VM_ARGS_MAC;
                this.setArchState(localName);
                return;
            }
            case 14: {
                this.platformKeyPrefix = VM_ARGS_SOLARIS;
                this.setArchState(localName);
                return;
            }
            case 15: {
                this.platformKeyPrefix = VM_ARGS_WIN;
                this.setArchState(localName);
                return;
            }
            case 4: {
                if (!EL_PLUGIN.equals(localName)) return;
                this.processPlugin(attributes);
                return;
            }
            case 28: {
                if (!EL_REPOSITORY.equals(localName)) return;
                this.processRepositoryInformation(attributes);
                return;
            }
            case 18: {
                if (EL_URL.equals(localName)) {
                    this.state = 19;
                    return;
                }
                if (!EL_TEXT.equals(localName)) return;
                this.licenseText = "";
                this.state = 20;
                return;
            }
            case 5: {
                if (!EL_FEATURE.equals(localName)) return;
                this.processFeature(attributes);
                return;
            }
            case 17: {
                if (EL_PLUGIN.equals(localName)) {
                    this.processPluginConfiguration(attributes);
                    return;
                }
                if (!EL_PROPERTY.equals(localName)) return;
                this.processPropertyConfiguration(attributes);
                return;
            }
            case 29: {
                if (localName == null) return;
                switch (localName) {
                    case "linux": {
                        this.state = 31;
                        return;
                    }
                    case "windows": {
                        this.state = 33;
                        return;
                    }
                    case "macos": {
                        this.state = 32;
                        return;
                    }
                }
                return;
            }
        }
    }

    private void setArchState(String archName) {
        block25: {
            this.outerState = this.state;
            if (archName == null) break block25;
            switch (archName) {
                case "argsX86": {
                    this.state = 21;
                    break;
                }
                case "argsX86_64": {
                    this.state = 22;
                    break;
                }
                case "argsPPC": {
                    this.state = 23;
                    break;
                }
                case "argsIA_64": {
                    this.state = 24;
                    break;
                }
                case "argsIA_64_32": {
                    this.state = 25;
                    break;
                }
                case "argsPA_RISC": {
                    this.state = 26;
                    break;
                }
                case "argsSPARC": {
                    this.state = 27;
                    break;
                }
            }
        }
    }

    private void processPropertyConfiguration(Attributes attributes) {
        String arch;
        String name = attributes.getValue(ATTRIBUTE_NAME);
        String value = attributes.getValue(ATTRIBUTE_VALUE);
        String os = attributes.getValue(ATTRIBUTE_OS);
        if (os == null) {
            os = "";
        }
        if ((arch = attributes.getValue(ATTRIBUTE_ARCH)) == null) {
            arch = "";
        }
        String propOSArchKey = os + "." + arch;
        if (name == null) {
            return;
        }
        if (value == null) {
            value = "";
        }
        if (propOSArchKey.length() <= 1) {
            if (this.properties == null) {
                this.properties = new HashMap<String, String>();
            }
            this.properties.put(name, value);
        } else {
            HashMap<String, String> filteredMap;
            if (this.filteredProperties == null) {
                this.filteredProperties = new HashMap();
            }
            if ((filteredMap = this.filteredProperties.get(propOSArchKey)) == null) {
                filteredMap = new HashMap();
                this.filteredProperties.put(propOSArchKey, filteredMap);
            }
            filteredMap.put(name, value);
        }
    }

    private void processPluginConfiguration(Attributes attributes) {
        int startLevel;
        BundleInfo info = new BundleInfo();
        info.setSymbolicName(attributes.getValue(ATTRIBUTE_ID));
        info.setVersion(attributes.getValue(ATTRIBUTE_VERSION));
        String value = attributes.getValue(ATTRIBUTE_START_LEVEL);
        if (value != null && (startLevel = Integer.parseInt(value)) > 0) {
            info.setStartLevel(startLevel);
        }
        if ((value = attributes.getValue(ATTRIBUTE_AUTO_START)) != null) {
            info.setMarkedAsStarted(Boolean.parseBoolean(value));
        }
        if (this.bundleInfos == null) {
            this.bundleInfos = new ArrayList<BundleInfo>();
        }
        this.bundleInfos.add(info);
    }

    private void processRepositoryInformation(Attributes attributes) {
        try {
            URI uri = URIUtil.fromString((String)attributes.getValue(ATTRIBUTE_LOCATION));
            String name = attributes.getValue(ATTRIBUTE_NAME);
            boolean enabled = Boolean.parseBoolean(attributes.getValue(ATTRIBUTE_ENABLED));
            int options = enabled ? 1 : 0;
            this.repositories.add((IRepositoryReference)new RepositoryReference(uri, name, 0, options));
            this.repositories.add((IRepositoryReference)new RepositoryReference(uri, name, 1, options));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        switch (this.state) {
            case 4: {
                if (!EL_PLUGINS.equals(localName)) break;
                this.state = 1;
                break;
            }
            case 5: {
                if (!EL_FEATURES.equals(localName)) break;
                this.state = 1;
                break;
            }
            case 3: {
                if (!EL_LAUNCHER_ARGS.equals(localName)) break;
                this.state = 1;
                break;
            }
            case 2: {
                if (!EL_LAUNCHER.equals(localName)) break;
                this.state = 1;
                break;
            }
            case 17: {
                if (!EL_CONFIGURATIONS.equals(localName)) break;
                this.state = 1;
                break;
            }
            case 18: {
                if (!EL_LICENSE.equals(localName)) break;
                this.state = 1;
                break;
            }
            case 29: {
                this.state = 1;
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                this.state = 29;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                this.state = 3;
                break;
            }
            case 19: 
            case 20: {
                this.state = 18;
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                this.state = this.outerState;
                break;
            }
            case 16: {
                if (EL_CONFIG_INI.equals(localName)) {
                    this.state = 1;
                    break;
                }
                this.processConfigIniPlatform(localName, false);
                break;
            }
            case 28: {
                if (!EL_REPOSITORIES.equals(localName)) break;
                this.state = 1;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        switch (this.state) {
            case 6: {
                this.addLaunchArgumentToMap(PROGRAM_ARGS, String.valueOf(ch, start, length));
                break;
            }
            case 7: {
                this.addLaunchArgumentToMap(PROGRAM_ARGS_LINUX, String.valueOf(ch, start, length));
                break;
            }
            case 8: {
                this.addLaunchArgumentToMap(PROGRAM_ARGS_MAC, String.valueOf(ch, start, length));
                break;
            }
            case 9: {
                this.addLaunchArgumentToMap(PROGRAM_ARGS_SOLARIS, String.valueOf(ch, start, length));
                break;
            }
            case 10: {
                this.addLaunchArgumentToMap(PROGRAM_ARGS_WIN, String.valueOf(ch, start, length));
                break;
            }
            case 11: {
                this.addLaunchArgumentToMap(VM_ARGS, String.valueOf(ch, start, length));
                break;
            }
            case 12: {
                this.addLaunchArgumentToMap(VM_ARGS_LINUX, String.valueOf(ch, start, length));
                break;
            }
            case 13: {
                this.addLaunchArgumentToMap(VM_ARGS_MAC, String.valueOf(ch, start, length));
                break;
            }
            case 14: {
                this.addLaunchArgumentToMap(VM_ARGS_SOLARIS, String.valueOf(ch, start, length));
                break;
            }
            case 15: {
                this.addLaunchArgumentToMap(VM_ARGS_WIN, String.valueOf(ch, start, length));
                break;
            }
            case 21: {
                this.addLaunchArgumentToMap(this.platformKeyPrefix + ".argsX86", String.valueOf(ch, start, length));
                break;
            }
            case 22: {
                this.addLaunchArgumentToMap(this.platformKeyPrefix + ".argsX86_64", String.valueOf(ch, start, length));
                break;
            }
            case 23: {
                this.addLaunchArgumentToMap(this.platformKeyPrefix + ".argsPPC", String.valueOf(ch, start, length));
                break;
            }
            case 24: {
                this.addLaunchArgumentToMap(this.platformKeyPrefix + ".argsIA_64", String.valueOf(ch, start, length));
                break;
            }
            case 25: {
                this.addLaunchArgumentToMap(this.platformKeyPrefix + ".argsIA_64_32", String.valueOf(ch, start, length));
                break;
            }
            case 26: {
                this.addLaunchArgumentToMap(this.platformKeyPrefix + ".argsPA_RISC", String.valueOf(ch, start, length));
                break;
            }
            case 27: {
                this.addLaunchArgumentToMap(this.platformKeyPrefix + ".argsSPARC", String.valueOf(ch, start, length));
                break;
            }
            case 16: {
                if (this.platformConfigPath == null) break;
                this.platformConfigPath = String.valueOf(this.platformConfigPath) + String.valueOf(ch, start, length);
                break;
            }
            case 19: {
                this.licenseURL = String.valueOf(ch, start, length);
                break;
            }
            case 20: {
                if (this.licenseText == null) break;
                this.licenseText = String.valueOf(this.licenseText) + String.valueOf(ch, start, length);
                break;
            }
            case 31: {
                this.addVM(OS_LINUX, String.valueOf(ch, start, length));
                break;
            }
            case 33: {
                this.addVM(OS_WINDOWS, String.valueOf(ch, start, length));
                break;
            }
            case 32: {
                this.addVM(OS_MACOS, String.valueOf(ch, start, length));
            }
        }
    }

    private void addVM(String os, String vm) {
        this.vms.put(os, vm);
    }

    @Override
    public String getVM(String os) {
        if (os.equals(OS_MACOSX)) {
            os = OS_MACOS;
        } else if (os.equals(OS_WIN32)) {
            os = OS_WINDOWS;
        }
        return this.vms.get(os);
    }

    private void addLaunchArgumentToMap(String key, String value) {
        String oldValue;
        if (this.launcherArgs == null) {
            this.launcherArgs = new Properties();
        }
        if ((oldValue = this.launcherArgs.getProperty(key)) != null) {
            this.launcherArgs.setProperty(key, oldValue + value);
        } else {
            this.launcherArgs.setProperty(key, value);
        }
    }

    protected void processPlugin(Attributes attributes) {
        String fragment = attributes.getValue(ATTRIBUTE_FRAGMENT);
        String pluginId = attributes.getValue(ATTRIBUTE_ID);
        String pluginVersion = attributes.getValue(ATTRIBUTE_VERSION);
        FeatureEntry entry = new FeatureEntry(pluginId, pluginVersion != null ? pluginVersion : GENERIC_VERSION_NUMBER, true);
        entry.setFragment(Boolean.parseBoolean(fragment));
        this.plugins.add(entry);
    }

    private void processFeature(Attributes attributes) {
        String featureId = attributes.getValue(ATTRIBUTE_ID);
        String featureVersion = attributes.getValue(ATTRIBUTE_VERSION);
        FeatureInstallMode installMode = FeatureInstallMode.parse(attributes.getValue(ATTRIBUTE_FEATURE_INSTALL_MODE));
        FeatureEntry featureEntry = new FeatureEntry(featureId, featureVersion != null ? featureVersion : GENERIC_VERSION_NUMBER, false);
        switch (installMode) {
            case ROOT: {
                this.rootFeatures.add(featureEntry);
                break;
            }
            default: {
                this.features.add(featureEntry);
            }
        }
    }

    private void processProduct(Attributes attributes) {
        String contentTypeString;
        this.id = attributes.getValue(ATTRIBUTE_ID);
        this.uid = attributes.getValue(ATTRIBUTE_UID);
        this.productName = attributes.getValue(ATTRIBUTE_NAME);
        this.application = attributes.getValue(ATTRIBUTE_APPLICATION);
        if (attributes.getIndex(ATTRIBUTE_INCLUDE_LAUNCHERS) >= 0) {
            this.includeLaunchers = Boolean.valueOf(attributes.getValue(ATTRIBUTE_INCLUDE_LAUNCHERS));
        }
        if ((contentTypeString = attributes.getValue(ATTRIBUTE_CONTENT_TYPE)) != null) {
            this.productContentType = ProductContentType.toProductContentType(contentTypeString);
        }
        if (this.productContentType == null) {
            String use = attributes.getValue("useFeatures");
            this.productContentType = use != null && Boolean.parseBoolean(use) ? ProductContentType.FEATURES : ProductContentType.BUNDLES;
        }
        this.version = attributes.getValue(ATTRIBUTE_VERSION);
    }

    private void processConfigIni(Attributes attributes) {
        String os;
        String path = null;
        if ("custom".equals(attributes.getValue("use"))) {
            path = attributes.getValue(ATTRIBUTE_PATH);
        }
        if ((os = attributes.getValue(ATTRIBUTE_OS)) != null && os.length() > 0) {
            if (path != null) {
                this.platformSpecificConfigPaths.put(os, path);
            }
        } else if (path != null) {
            this.configPath = path;
        }
    }

    private void processConfigIniPlatform(String key, boolean begin) {
        if (begin) {
            this.configPlatform = key;
            this.platformConfigPath = "";
        } else if (this.configPlatform.equals(key) && this.platformConfigPath.length() > 0) {
            this.platformSpecificConfigPaths.put(key, this.platformConfigPath);
            this.platformConfigPath = null;
        }
    }

    private void processLauncher(Attributes attributes) {
        this.launcherName = attributes.getValue(ATTRIBUTE_NAME);
    }

    private void addIcon(String os, String value) {
        Collection<String> list;
        File workspace;
        Location instanceLocation;
        if (value == null) {
            return;
        }
        File iconFile = new File(value);
        if (!iconFile.isFile() && (instanceLocation = this.getInstanceLocation()) != null && instanceLocation.getURL() != null && (workspace = URLUtil.toFile((URL)instanceLocation.getURL())) != null) {
            iconFile = new File(workspace, value);
        }
        if (!iconFile.isFile()) {
            iconFile = new File(this.location.getParentFile(), value);
        }
        if ((list = this.icons.get(os)) == null) {
            list = new ArrayList<String>(6);
            this.icons.put(os, list);
        }
        list.add(iconFile.getAbsolutePath());
    }

    protected Location getInstanceLocation() {
        return (Location)ServiceHelper.getService((BundleContext)Activator.getContext(), Location.class, (String)Location.INSTANCE_FILTER);
    }

    private void processSolaris(Attributes attributes) {
        this.addIcon(OS_SOLARIS, attributes.getValue(SOLARIS_LARGE));
        this.addIcon(OS_SOLARIS, attributes.getValue(SOLARIS_MEDIUM));
        this.addIcon(OS_SOLARIS, attributes.getValue(SOLARIS_SMALL));
        this.addIcon(OS_SOLARIS, attributes.getValue(SOLARIS_TINY));
    }

    private void processWin(Attributes attributes) {
    }

    private void processIco(Attributes attributes) {
        this.addIcon(OS_WIN32, attributes.getValue(ATTRIBUTE_PATH));
    }

    private void processBmp(Attributes attributes) {
        this.addIcon(OS_WIN32, attributes.getValue(WIN32_16_HIGH));
        this.addIcon(OS_WIN32, attributes.getValue(WIN32_16_LOW));
        this.addIcon(OS_WIN32, attributes.getValue(WIN32_24_LOW));
        this.addIcon(OS_WIN32, attributes.getValue(WIN32_32_HIGH));
        this.addIcon(OS_WIN32, attributes.getValue(WIN32_32_LOW));
        this.addIcon(OS_WIN32, attributes.getValue(WIN32_48_HIGH));
        this.addIcon(OS_WIN32, attributes.getValue(WIN32_48_LOW));
        this.addIcon(OS_WIN32, attributes.getValue(WIN32_256_HIGH));
    }

    private void processLinux(Attributes attributes) {
        this.addIcon(OS_LINUX, attributes.getValue(ATTRIBUTE_ICON));
    }

    private void processMac(Attributes attributes) {
        this.addIcon(OS_MACOSX, attributes.getValue(ATTRIBUTE_ICON));
    }

    @Override
    public ProductContentType getProductContentType() {
        return this.productContentType;
    }
}

