/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.oomph.base.util.BaseUtil;
import org.eclipse.oomph.setup.Configuration;
import org.eclipse.oomph.setup.EclipseIniTask;
import org.eclipse.oomph.setup.Index;
import org.eclipse.oomph.setup.Installation;
import org.eclipse.oomph.setup.Product;
import org.eclipse.oomph.setup.ProductCatalog;
import org.eclipse.oomph.setup.ProductVersion;
import org.eclipse.oomph.setup.Project;
import org.eclipse.oomph.setup.ProjectCatalog;
import org.eclipse.oomph.setup.ProjectContainer;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.SetupTaskContainer;
import org.eclipse.oomph.setup.Stream;
import org.eclipse.oomph.setup.Workspace;
import org.eclipse.oomph.setup.WorkspaceTask;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.util.CatalogManager;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.wizards.CatalogSelector;
import org.eclipse.oomph.setup.ui.wizards.Messages;
import org.eclipse.oomph.setup.ui.wizards.SetupWizard;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class ConfigurationProcessor {
    protected final SetupWizard setupWizard;
    protected final Configuration configuration;
    protected final Workspace workspace;
    protected Installation installation;
    private final ScopeStatus status = new ScopeStatus(null, Messages.ConfigurationProcessor_configurationStatus_error);
    private final ScopeStatus installationStatus;
    private final ScopeStatus workspaceStatus;

    public ConfigurationProcessor(SetupWizard setupWizard) {
        this.setupWizard = setupWizard;
        this.configuration = setupWizard.getConfiguration();
        if (this.configuration == null) {
            this.installation = null;
            this.workspace = null;
        } else {
            this.installation = this.configuration.getInstallation();
            this.workspace = this.configuration.getWorkspace();
        }
        this.installationStatus = new ScopeStatus((Scope)this.installation, Messages.ConfigurationProcessor_installationStatus_error);
        this.status.add((IStatus)this.installationStatus);
        this.workspaceStatus = new ScopeStatus((Scope)this.workspace, Messages.ConfigurationProcessor_workspaceStatus_error);
        this.status.add((IStatus)this.workspaceStatus);
    }

    public IStatus getStatus() {
        this.status.computeSeverity();
        int okCount = 0;
        IStatus result = null;
        IStatus[] iStatusArray = this.status.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status = iStatusArray[n2];
            if (status.isOK()) {
                ++okCount;
            } else {
                result = status;
            }
            ++n2;
        }
        if (okCount == 1) {
            return result;
        }
        return this.status;
    }

    public boolean processInstallation() {
        return this.installation == null ? this.handleNullInstallation() : this.handleInstallation();
    }

    protected MultiStatus getStatus(Scope scope) {
        if (scope instanceof Installation) {
            return (MultiStatus)this.status.getChildren()[0];
        }
        MultiStatus containerStatus = (MultiStatus)this.status.getChildren()[scope instanceof ProductVersion ? 0 : 1];
        IStatus[] iStatusArray = containerStatus.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status = iStatusArray[n2];
            ScopeStatus scopeStatus = (ScopeStatus)status;
            if (scopeStatus.getScope() == scope) {
                return scopeStatus;
            }
            ++n2;
        }
        ScopeStatus scopeStatus = new ScopeStatus(scope);
        containerStatus.add((IStatus)scopeStatus);
        return scopeStatus;
    }

    public boolean processWorkspace() {
        return this.workspace == null ? this.handleNullWorkspace() : this.handleWorkspace();
    }

    protected boolean handleNullInstallation() {
        if (this.configuration == null && this.setupWizard.isSimple()) {
            this.installationStatus.add(this.createResourceStatus(this.setupWizard.getUnappliedConfigurationResources(), SetupPackage.Literals.CONFIGURATION));
            return false;
        }
        if (this.installation == null && this.workspace == null && this.setupWizard.isSimple()) {
            this.installationStatus.add((IStatus)new Status(4, SetupUIPlugin.PLUGIN_ID, Messages.ConfigurationProcessor_installationStatus_configEmpty));
            return false;
        }
        return true;
    }

    protected boolean handleInstallation() {
        ProductVersion productVersion = this.installation.getProductVersion();
        return productVersion == null ? this.handleNullProductVersion() : this.handleProductVersion(productVersion);
    }

    protected boolean handleNullProductVersion() {
        this.addStatus(4, (Scope)this.installation, Messages.ConfigurationProcessor_status_noProductVersion);
        return false;
    }

    protected boolean handleProductVersion(ProductVersion productVersion) {
        if (productVersion.eIsProxy()) {
            return this.handleProxyProductVersion(productVersion);
        }
        Product product = productVersion.getProduct();
        if (product == null) {
            return this.handleNullProduct(productVersion);
        }
        ProductCatalog productCatalog = product.getProductCatalog();
        CatalogManager catalogManager = this.setupWizard.getCatalogManager();
        if (productCatalog == null) {
            boolean added = false;
            CatalogSelector catalogSelector = new CatalogSelector(catalogManager, true);
            for (Scope scope : catalogSelector.getCatalogs()) {
                if (!ConfigurationProcessor.isUserProductCatalog(scope)) continue;
                ProductCatalog userProductCatalog = (ProductCatalog)scope;
                userProductCatalog.getProducts().add(0, (Object)product);
                BaseUtil.saveEObject((EObject)userProductCatalog);
                catalogManager.selectCatalog(true, (Scope)userProductCatalog, true);
                added = true;
                break;
            }
            if (!added) {
                return this.handleNoUserProductCatalog(productVersion);
            }
        } else {
            Index index = catalogManager.getIndex();
            Index productCatalogIndex = productCatalog.getIndex();
            if (productCatalogIndex == index) {
                if (!"self".equals(productCatalog.getName())) {
                    catalogManager.selectCatalog(true, (Scope)productCatalog, true);
                }
            } else if (!this.addCatalog(true, (Scope)productCatalog, (Scope)productVersion)) {
                return this.handleNoRedirectableProductCatalog(productVersion);
            }
        }
        if ("self.empty.product.version".equals(productVersion.getQualifiedName())) {
            return this.applyEmptyProductVersion();
        }
        return this.applyProductVersion(productVersion);
    }

    protected boolean applyEmptyProductVersion() {
        return false;
    }

    protected boolean applyProductVersion(ProductVersion productVersion) {
        return false;
    }

    protected void applyInstallation() {
        SetupContext setupContext = SetupContext.create((ResourceSet)this.setupWizard.getResourceSet(), null);
        Installation setupInstallation = setupContext.getInstallation();
        this.applyAttributes((Scope)setupInstallation, (Scope)this.installation);
        this.applySetupTasks((SetupTaskContainer)setupInstallation, (SetupTaskContainer)this.installation);
        this.setupWizard.addAppliedConfigurationResource(this.installation.eResource());
    }

    protected void applyAttributes(Scope targetScope, Scope sourceScope) {
        String description;
        String label;
        String name = sourceScope.getName();
        if (!StringUtil.isEmpty((String)name)) {
            targetScope.setName(name);
        }
        if (!StringUtil.isEmpty((String)(label = sourceScope.getLabel()))) {
            targetScope.setLabel(label);
        }
        if (!StringUtil.isEmpty((String)(description = sourceScope.getDescription()))) {
            targetScope.setDescription(description);
        }
        targetScope.getAnnotations().addAll((Collection)sourceScope.getAnnotations());
    }

    protected void applySetupTasks(SetupTaskContainer targetSetupTaskContainer, SetupTaskContainer sourceSetTaskContainer) {
        targetSetupTaskContainer.getSetupTasks().addAll((Collection)sourceSetTaskContainer.getSetupTasks());
    }

    protected boolean handleNoRedirectableProductCatalog(ProductVersion productVersion) {
        return false;
    }

    protected boolean handleNoUserProductCatalog(ProductVersion productVersion) {
        this.addStatus(4, (Scope)productVersion, Messages.ConfigurationProcessor_status_productNotInIndex);
        return false;
    }

    protected boolean handleProxyProductVersion(ProductVersion productVersion) {
        this.addStatus(4, (Scope)productVersion, Messages.ConfigurationProcessor_status_unresolvableVersion);
        return false;
    }

    protected boolean handleNullProduct(ProductVersion productVersion) {
        this.addStatus(4, (Scope)productVersion, Messages.ConfigurationProcessor_status_versionNotInProduct);
        return false;
    }

    protected boolean handleNullWorkspace() {
        if (this.configuration == null && !this.setupWizard.isSimple()) {
            this.workspaceStatus.add(this.createResourceStatus(this.setupWizard.getUnappliedConfigurationResources(), SetupPackage.Literals.CONFIGURATION));
            return false;
        }
        if (this.installation == null && this.workspace == null && !this.setupWizard.isSimple()) {
            this.workspaceStatus.add((IStatus)new Status(4, SetupUIPlugin.PLUGIN_ID, Messages.ConfigurationProcessor_workspaceStatus_configEmpty));
            return false;
        }
        return true;
    }

    protected IStatus createResourceStatus(Collection<? extends Resource> resources, EClass expectedEClass) {
        StringBuilder uris = new StringBuilder();
        ArrayList<Status> childStatuses = new ArrayList<Status>();
        for (Resource resource : resources) {
            if (uris.length() != 0) {
                uris.append(' ');
            }
            uris.append(resource.getURI());
            EList errors = resource.getErrors();
            if (errors.isEmpty()) {
                EList contents = resource.getContents();
                if (contents.isEmpty()) {
                    childStatuses.add(new Status(4, SetupUIPlugin.PLUGIN_ID, Messages.ConfigurationProcessor_status_emptyResource));
                    continue;
                }
                childStatuses.add(new Status(4, SetupUIPlugin.PLUGIN_ID, NLS.bind((String)Messages.ConfigurationProcessor_status_resourceContains, (Object)((EObject)contents.get(0)).eClass().getName())));
                continue;
            }
            for (Resource.Diagnostic diagnostic : errors) {
                Throwable cause;
                Object message = diagnostic.getMessage();
                Throwable throwable = null;
                if (diagnostic instanceof Throwable && (throwable = (Throwable)diagnostic) instanceof XMIException && (cause = throwable.getCause()) != null) {
                    XMIException xmiException = (XMIException)throwable;
                    message = cause.getMessage();
                    int line = xmiException.getLine();
                    if (line != 0) {
                        message = (String)message + " (" + line + ", " + xmiException.getColumn() + ")";
                    }
                }
                childStatuses.add(new Status(4, SetupUIPlugin.PLUGIN_ID, (String)message, throwable));
            }
        }
        return new MultiStatus(SetupUIPlugin.PLUGIN_ID, 0, childStatuses.toArray(new IStatus[childStatuses.size()]), NLS.bind((String)Messages.ConfigurationProcessor_status_couldNotLoadFromUris, (Object)expectedEClass.getName(), (Object)uris), null);
    }

    protected boolean handleWorkspace() {
        if (this.setupWizard.isSimple()) {
            String[] stringArray;
            Shell shell = this.setupWizard.getShell();
            if (this.installation == null) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = Messages.ConfigurationProcessor_configHandlingDialog_button_advancedMode;
                stringArray = stringArray2;
                stringArray2[1] = Messages.ConfigurationProcessor_configHandlingDialog_button_cancel;
            } else {
                String[] stringArray3 = new String[3];
                stringArray3[0] = Messages.ConfigurationProcessor_configHandlingDialog_button_advancedMode;
                stringArray3[1] = Messages.ConfigurationProcessor_configHandlingDialog_button_applyOnlyInstallation;
                stringArray = stringArray3;
                stringArray3[2] = Messages.ConfigurationProcessor_configHandlingDialog_button_cancel;
            }
            int answer = new MessageDialog(shell, Messages.ConfigurationProcessor_configHandlingDialog_title, null, Messages.ConfigurationProcessor_configHandlingDialog_message, 4, stringArray, 0).open();
            switch (answer) {
                case 0: {
                    if (this.configuration != null) {
                        this.setupWizard.addAppliedConfigurationResource(this.configuration.eResource());
                    }
                    Collection<? extends Resource> configurationResources = this.setupWizard.getAppliedConfigurationResources();
                    this.handleSwitchToAdvancedMode();
                    this.setupWizard.setConfigurationResources(configurationResources);
                    return false;
                }
                case 1: {
                    return this.installation != null;
                }
            }
            return false;
        }
        ArrayList<Stream> projectStreams = new ArrayList<Stream>();
        for (Stream stream : this.workspace.getStreams()) {
            if (stream.eIsProxy()) {
                this.addStatus(4, (Scope)stream, Messages.ConfigurationProcessor_status_unresolvableStream);
                continue;
            }
            Project project = stream.getProject();
            if (project == null) {
                this.addStatus(4, (Scope)stream, Messages.ConfigurationProcessor_status_streamNotInProject);
                continue;
            }
            Project rootProject = project;
            ProjectCatalog projectCatalog = null;
            ProjectContainer projectContainer = project.getProjectContainer();
            while (projectContainer != null) {
                if (projectContainer instanceof Project) {
                    rootProject = (Project)projectContainer;
                } else if (projectContainer instanceof ProjectCatalog) {
                    projectCatalog = (ProjectCatalog)projectContainer;
                    break;
                }
                projectContainer = projectContainer.getProjectContainer();
            }
            if (projectCatalog == null) {
                ProjectContainer logicalProjectContainer = rootProject.getLogicalProjectContainer();
                if (logicalProjectContainer == null) {
                    this.addStatus(4, (Scope)stream, Messages.ConfigurationProcessor_status_rootProjectNotInCatalog_noContainer + " " + String.valueOf(EcoreUtil.getURI((EObject)rootProject)));
                    continue;
                }
                if (logicalProjectContainer.eIsProxy()) {
                    this.addStatus(4, (Scope)stream, Messages.ConfigurationProcessor_status_rootProjectNotInCatalog_unresolvableContainer + " " + String.valueOf(EcoreUtil.getURI((EObject)logicalProjectContainer)));
                    continue;
                }
                if (logicalProjectContainer instanceof Project) {
                    this.addStatus(4, (Scope)stream, Messages.ConfigurationProcessor_status_rootProjectNotInCatalog_notInContainer + " " + String.valueOf(EcoreUtil.getURI((EObject)logicalProjectContainer)));
                    continue;
                }
                ProjectCatalog logicalProjectCatalog = (ProjectCatalog)logicalProjectContainer;
                if (!this.handleStream(logicalProjectCatalog, stream)) continue;
                if (logicalProjectCatalog.getProjects().contains((Object)rootProject)) {
                    projectStreams.add(stream);
                    continue;
                }
                if (this.handleUserProject(logicalProjectCatalog, rootProject)) {
                    projectStreams.add(stream);
                    continue;
                }
                this.addStatus(4, (Scope)stream, Messages.ConfigurationProcessor_status_cannotAddRootProject + " " + String.valueOf(EcoreUtil.getURI((EObject)rootProject)));
                this.addStatus(4, (Scope)stream, Messages.ConfigurationProcessor_status_noExtensibleProjectInCatalog + " " + String.valueOf(EcoreUtil.getURI((EObject)logicalProjectCatalog)));
                continue;
            }
            if (!this.handleStream(projectCatalog, stream)) continue;
            projectStreams.add(stream);
        }
        if (projectStreams.isEmpty() ? this.applyNoStreams() : this.applyStreams(projectStreams)) {
            return this.applyWorkspace();
        }
        return false;
    }

    protected boolean applyWorkspace() {
        SetupContext setupContext = SetupContext.create((Installation)this.installation, Collections.emptyList(), null);
        Workspace setupWorkspace = setupContext.getWorkspace();
        this.applyAttributes((Scope)setupWorkspace, (Scope)this.workspace);
        this.applySetupTasks((SetupTaskContainer)setupWorkspace, (SetupTaskContainer)this.workspace);
        if (setupWorkspace.getStreams().isEmpty() && !setupWorkspace.getSetupTasks().isEmpty()) {
            WorkspaceTask workspaceTask = SetupFactory.eINSTANCE.createWorkspaceTask();
            workspaceTask.setID("workspace");
            setupWorkspace.getSetupTasks().add(0, (Object)workspaceTask);
        }
        this.setupWizard.addAppliedConfigurationResource(this.workspace.eResource());
        return true;
    }

    protected boolean applyStreams(List<Stream> streams) {
        return true;
    }

    protected boolean applyNoStreams() {
        return true;
    }

    protected boolean handleNoRedirectableProjectCatalog(Stream stream) {
        return false;
    }

    protected boolean handleUserProject(ProjectCatalog projectCatalog, Project project) {
        CatalogManager catalogManager = this.setupWizard.getCatalogManager();
        for (Project catalogProject : projectCatalog.getProjects()) {
            if (!ConfigurationProcessor.isUserProject(catalogProject)) continue;
            catalogProject.getProjects().add(0, (Object)project);
            BaseUtil.saveEObject((EObject)catalogProject);
            catalogManager.selectCatalog(false, (Scope)projectCatalog, true);
            return true;
        }
        return false;
    }

    protected boolean handleStream(ProjectCatalog projectCatalog, Stream stream) {
        Index index;
        CatalogManager catalogManager = this.setupWizard.getCatalogManager();
        Index projectIndex = projectCatalog.getIndex();
        if (projectIndex != (index = catalogManager.getIndex()) && !this.addCatalog(false, (Scope)projectCatalog, (Scope)stream)) {
            return this.handleNoRedirectableProjectCatalog(stream);
        }
        catalogManager.selectCatalog(false, (Scope)projectCatalog, true);
        return true;
    }

    protected boolean addCatalog(boolean product, Scope catalogScope, Scope originatingScope) {
        String label;
        CatalogManager catalogManager = this.setupWizard.getCatalogManager();
        Scope catalog = catalogManager.getCatalog(product, "redirectable");
        String string = label = product ? "product" : "project";
        if (catalog == null) {
            this.addStatus(4, originatingScope, NLS.bind((String)Messages.ConfigurationProcessor_status_cannotAddCatalog, (Object)EcoreUtil.getURI((EObject)catalogScope)));
            ResourceSet resourceSet = this.setupWizard.getResourceSet();
            Resource resource = resourceSet.getResource(URI.createURI((String)("index:/redirectable." + label + "s.setup")), false);
            if (resource == null) {
                this.addStatus(4, originatingScope, product ? Messages.ConfigurationProcessor_status_noRedirectableProductCatalog : Messages.ConfigurationProcessor_status_noRedirectableProjectCatalog);
            } else {
                this.addStatus(4, originatingScope, NLS.bind((String)Messages.ConfigurationProcessor_status_catalogAlreadyRedirected, (Object)label, (Object)resourceSet.getURIConverter().normalize(resource.getURI())));
            }
            return false;
        }
        Resource catalogResource = catalog.eResource();
        URI sourceURI = catalogResource.getURI();
        URI targetURI = catalogScope.eResource().getURI();
        EcoreUtil.replace((EObject)catalog, (EObject)catalogScope);
        catalogManager.selectCatalog(product, catalogScope, true);
        catalogResource.getResourceSet().getURIConverter().getURIMap().put(targetURI, sourceURI);
        EList setupTasks = (product ? this.installation : this.workspace).getSetupTasks();
        EclipseIniTask redirectionEclipseIniTask = SetupFactory.eINSTANCE.createEclipseIniTask();
        redirectionEclipseIniTask.setVm(true);
        redirectionEclipseIniTask.setOption("-Doomph.redirection." + (product ? "products" : "projects") + "=");
        redirectionEclipseIniTask.setValue(String.valueOf(sourceURI) + "->" + String.valueOf(targetURI));
        setupTasks.add(0, (Object)redirectionEclipseIniTask);
        return true;
    }

    protected void addStatus(int severity, Scope scope, String message) {
        MultiStatus containerStatus = this.getStatus(scope);
        containerStatus.add((IStatus)new Status(severity, SetupUIPlugin.PLUGIN_ID, message));
    }

    protected void handleSwitchToAdvancedMode() {
    }

    public static boolean isUserProject(Project project) {
        Resource resource = project.eResource();
        return resource != null && SetupContext.isUserScheme((String)resource.getURI().scheme());
    }

    public static boolean isUserProductCatalog(Scope scope) {
        if (scope instanceof ProductCatalog) {
            Resource resource = scope.eResource();
            return resource != null && SetupContext.isUserScheme((String)resource.getURI().scheme());
        }
        return false;
    }

    private static class ScopeStatus
    extends MultiStatus {
        private final Scope scope;

        public ScopeStatus(Scope scope) {
            super(SetupUIPlugin.PLUGIN_ID, 0, NLS.bind((String)Messages.ConfigurationProcessor_scopeStatus_message, (Object)EcoreUtil.getURI((EObject)scope)), null);
            this.scope = scope;
        }

        public ScopeStatus(Scope scope, String message) {
            super(SetupUIPlugin.PLUGIN_ID, 0, message, null);
            this.scope = scope;
        }

        public Scope getScope() {
            return this.scope;
        }

        public int computeSeverity() {
            IStatus[] iStatusArray = this.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                int newSev;
                IStatus status = iStatusArray[n2];
                int n3 = newSev = status instanceof ScopeStatus ? ((ScopeStatus)status).computeSeverity() : status.getSeverity();
                if (newSev > this.getSeverity()) {
                    this.setSeverity(newSev);
                }
                ++n2;
            }
            return this.getSeverity();
        }
    }
}

