/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.extensionlocation;

import java.net.URI;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.extensionlocation.Activator;
import org.eclipse.equinox.internal.p2.extensionlocation.ExtensionLocationMetadataRepository;
import org.eclipse.equinox.internal.p2.extensionlocation.Messages;
import org.eclipse.equinox.internal.p2.metadata.repository.SimpleMetadataRepositoryFactory;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.spi.MetadataRepositoryFactory;
import org.eclipse.osgi.util.NLS;

public class ExtensionLocationMetadataRepositoryFactory
extends MetadataRepositoryFactory {
    public IMetadataRepository create(URI location, String name, String type, Map<String, String> properties) throws ProvisionException {
        IStatus status = this.validate(location, null);
        if (!status.isOK()) {
            throw new ProvisionException(status);
        }
        URI repoLocation = ExtensionLocationMetadataRepository.getLocalRepositoryLocation(location);
        if (repoLocation == null) {
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", Messages.failed_create_local_artifact_repository));
        }
        boolean failed = false;
        SimpleMetadataRepositoryFactory simpleFactory = new SimpleMetadataRepositoryFactory();
        simpleFactory.setAgent(this.getAgent());
        try {
            simpleFactory.load(repoLocation, 0, null);
            failed = true;
        }
        catch (ProvisionException provisionException) {
            // empty catch block
        }
        if (failed) {
            String msg = NLS.bind((String)Messages.repo_already_exists, (Object)location.toString());
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", 1001, msg, null));
        }
        IMetadataRepository repository = simpleFactory.create(repoLocation, name, null, properties);
        return new ExtensionLocationMetadataRepository(this.getAgent(), location, repository, null);
    }

    public IMetadataRepository load(URI location, int flags, IProgressMonitor monitor) throws ProvisionException {
        if ((flags & 1) > 0) {
            return null;
        }
        IStatus status = this.validate(location, null);
        if (!status.isOK()) {
            throw new ProvisionException(status);
        }
        URI repoLocation = ExtensionLocationMetadataRepository.getLocalRepositoryLocation(location);
        if (repoLocation == null) {
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", Messages.failed_create_local_artifact_repository));
        }
        try {
            SimpleMetadataRepositoryFactory simpleFactory = new SimpleMetadataRepositoryFactory();
            simpleFactory.setAgent(this.getAgent());
            IMetadataRepository repository = simpleFactory.load(repoLocation, flags, null);
            return new ExtensionLocationMetadataRepository(this.getAgent(), location, repository, monitor);
        }
        catch (ProvisionException e) {
            return this.create(location, Activator.getRepositoryName(location), "org.eclipse.equinox.p2.extensionlocation.metadataRepository", null);
        }
    }

    public IStatus validate(URI location, IProgressMonitor monitor) {
        try {
            ExtensionLocationMetadataRepository.validate(location, monitor);
        }
        catch (ProvisionException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }
}

