/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.edit;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.command.PasteFromClipboardCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.oomph.edit.BasePasteFromClipboardCommand;

public class BaseAdapterFactoryEditingDomain
extends AdapterFactoryEditingDomain {
    private LinkedList<CommandParameter> commandParameters = new LinkedList();

    public BaseAdapterFactoryEditingDomain(AdapterFactory adapterFactory, CommandStack commandStack) {
        super(adapterFactory, commandStack);
    }

    public BaseAdapterFactoryEditingDomain(AdapterFactory adapterFactory, CommandStack commandStack, Map<Resource, Boolean> resourceToReadOnlyMap) {
        super(adapterFactory, commandStack, resourceToReadOnlyMap);
    }

    public BaseAdapterFactoryEditingDomain(AdapterFactory adapterFactory, CommandStack commandStack, ResourceSet resourceSet) {
        super(adapterFactory, commandStack, resourceSet);
    }

    public List<CommandParameter> getCommandParameters() {
        return Collections.unmodifiableList(this.commandParameters);
    }

    public void handledAdditions(Collection<?> collection) {
    }

    public Command createCommand(Class<? extends Command> commandClass, CommandParameter commandParameter) {
        this.commandParameters.push(commandParameter);
        try {
            Object owner;
            if (commandClass == CopyCommand.class && ((owner = commandParameter.getOwner()) instanceof URI || owner instanceof String)) {
                IdentityCommand identityCommand = new IdentityCommand(owner);
                return identityCommand;
            }
            if (commandClass == PasteFromClipboardCommand.class) {
                int index;
                owner = commandParameter.getOwner();
                Collection clipboard = this.getClipboard();
                Object feature = commandParameter.getFeature();
                BasePasteFromClipboardCommand primaryPasteCommand = new BasePasteFromClipboardCommand((EditingDomain)this, owner, feature, clipboard, index = commandParameter.getIndex(), true);
                if (!primaryPasteCommand.canExecute()) {
                    BasePasteFromClipboardCommand alternativePasteCommand = new BasePasteFromClipboardCommand((EditingDomain)this, owner, feature, clipboard, index, false);
                    if (alternativePasteCommand.canExecute()) {
                        primaryPasteCommand.dispose();
                        BasePasteFromClipboardCommand basePasteFromClipboardCommand = alternativePasteCommand;
                        return basePasteFromClipboardCommand;
                    }
                    alternativePasteCommand.dispose();
                }
                BasePasteFromClipboardCommand basePasteFromClipboardCommand = primaryPasteCommand;
                return basePasteFromClipboardCommand;
            }
            Command command = super.createCommand(commandClass, commandParameter);
            return command;
        }
        finally {
            this.commandParameters.pop();
        }
    }
}

