/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench.renderers.swt;

import org.eclipse.e4.ui.internal.workbench.renderers.swt.SWTRenderersMessages;
import org.eclipse.e4.ui.workbench.swt.internal.copy.SearchPattern;
import org.eclipse.e4.ui.workbench.swt.internal.copy.WorkbenchSWTMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractTableInformationControl {
    private Shell fShell;
    private Composite fComposite;
    private Text fFilterText;
    private TableViewer fTableViewer;
    private SearchPattern fSearchPattern;

    public boolean hasFocus() {
        if (this.fShell == null || this.fShell.isDisposed()) {
            return false;
        }
        Control fc = this.fShell.getDisplay().getFocusControl();
        return fc == this.fFilterText || fc == this.fTableViewer.getTable() || fc == this.fComposite || fc == this.fShell;
    }

    public AbstractTableInformationControl(Shell parent, int shellStyle, int controlStyle) {
        this.fShell = new Shell(parent, shellStyle);
        this.fShell.setLayout((Layout)new FillLayout());
        this.fComposite = new Composite((Composite)this.fShell, 16);
        GridLayout layout = new GridLayout(1, false);
        this.fComposite.setLayout((Layout)layout);
        this.createFilterText(this.fComposite);
        this.fTableViewer = this.createTableViewer(this.fComposite, controlStyle);
        final Table table = this.fTableViewer.getTable();
        table.addKeyListener(KeyListener.keyPressedAdapter(e -> {
            switch (e.keyCode) {
                case 27: {
                    this.dispose();
                    break;
                }
                case 127: {
                    this.removeSelectedItem(null);
                    e.character = '\u0000';
                    e.doit = false;
                    break;
                }
                case 0x1000001: {
                    if (table.getSelectionIndex() != 0) break;
                    this.fFilterText.setFocus();
                    break;
                }
                case 0x1000002: {
                    if (table.getSelectionIndex() != table.getItemCount() - 1) break;
                    this.fFilterText.setFocus();
                }
            }
        }));
        table.addSelectionListener(SelectionListener.widgetDefaultSelectedAdapter(e -> this.gotoSelectedElement()));
        boolean ignoreEventCount = true;
        table.addMouseMoveListener(new MouseMoveListener(){
            TableItem fLastItem = null;
            int lastY = 0;
            int itemHeightdiv4;
            int tableHeight;
            Point tableLoc;
            int divCount;
            {
                this.itemHeightdiv4 = table2.getItemHeight() / 4;
                this.tableHeight = table2.getBounds().height;
                this.tableLoc = table2.toDisplay(0, 0);
                this.divCount = 0;
            }

            public void mouseMove(MouseEvent e) {
                if (this.divCount == 1) {
                    this.divCount = 0;
                }
                if (table.equals(e.getSource()) & ++this.divCount == 1) {
                    TableItem tableItem;
                    if (this.fLastItem == null ^ (tableItem = table.getItem(new Point(e.x, e.y))) == null) {
                        table.setCursor(tableItem == null ? null : table.getDisplay().getSystemCursor(21));
                    }
                    if (tableItem != null && this.lastY != e.y) {
                        Item item;
                        this.lastY = e.y;
                        if (!tableItem.equals(this.fLastItem)) {
                            this.fLastItem = tableItem;
                            table.setSelection(new TableItem[]{this.fLastItem});
                        } else if (e.y < this.itemHeightdiv4) {
                            Item item2 = AbstractTableInformationControl.this.fTableViewer.scrollUp(e.x + this.tableLoc.x, e.y + this.tableLoc.y);
                            if (item2 instanceof TableItem) {
                                this.fLastItem = (TableItem)item2;
                                table.setSelection(new TableItem[]{this.fLastItem});
                            }
                        } else if (e.y > this.tableHeight - this.itemHeightdiv4 && (item = AbstractTableInformationControl.this.fTableViewer.scrollDown(e.x + this.tableLoc.x, e.y + this.tableLoc.y)) instanceof TableItem) {
                            this.fLastItem = (TableItem)item;
                            table.setSelection(new TableItem[]{this.fLastItem});
                        }
                    } else if (tableItem == null) {
                        this.fLastItem = null;
                    }
                }
            }
        });
        table.addMouseListener(MouseListener.mouseUpAdapter(e -> {
            TableItem tItem;
            if (table.getSelectionCount() < 1) {
                return;
            }
            if (e.button == 1 && table.equals(e.getSource())) {
                TableItem o = table.getItem(new Point(e.x, e.y));
                TableItem selection = table.getSelection()[0];
                if (selection.equals(o)) {
                    this.gotoSelectedElement();
                }
            }
            if (e.button == 3 && (tItem = this.fTableViewer.getTable().getItem(new Point(e.x, e.y))) != null) {
                Menu menu = new Menu((Control)this.fTableViewer.getTable());
                MenuItem mItem = new MenuItem(menu, 0);
                mItem.setText(SWTRenderersMessages.menuClose);
                mItem.addSelectionListener(SelectionListener.widgetSelectedAdapter(selectionEvent -> this.removeSelectedItem(tItem.getData())));
                menu.setVisible(true);
            }
        }));
        this.fShell.addTraverseListener(e -> {
            switch (e.detail) {
                case 512: {
                    e.detail = 0;
                    e.doit = true;
                    int n1 = table.getItemCount();
                    if (n1 == 0) {
                        return;
                    }
                    int i1 = table.getSelectionIndex() + 1;
                    if (i1 >= n1) {
                        i1 = 0;
                    }
                    table.setSelection(i1);
                    break;
                }
                case 256: {
                    e.detail = 0;
                    e.doit = true;
                    int n2 = table.getItemCount();
                    if (n2 == 0) {
                        return;
                    }
                    int i2 = table.getSelectionIndex() - 1;
                    if (i2 < 0) {
                        i2 = n2 - 1;
                    }
                    table.setSelection(i2);
                }
            }
        });
        this.setInfoSystemColor();
        this.installFilter();
    }

    protected void removeSelectedItem(Object selected) {
        int selInd = this.fTableViewer.getTable().getSelectionIndex();
        if (this.deleteSelectedElement(selected)) {
            return;
        }
        this.fTableViewer.refresh();
        if (selInd >= this.fTableViewer.getTable().getItemCount()) {
            selInd = this.fTableViewer.getTable().getItemCount() - 1;
        }
        if (selInd >= 0) {
            this.fTableViewer.getTable().setSelection(selInd);
        }
    }

    protected abstract TableViewer createTableViewer(Composite var1, int var2);

    public TableViewer getTableViewer() {
        return this.fTableViewer;
    }

    protected Text createFilterText(Composite parent) {
        this.fFilterText = new Text(parent, 0);
        GridData data = new GridData();
        GC gc = new GC((Drawable)parent);
        gc.setFont(parent.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        data.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)1);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        this.fFilterText.setLayoutData((Object)data);
        this.fFilterText.addKeyListener(KeyListener.keyPressedAdapter(e -> {
            switch (e.keyCode) {
                case 13: 
                case 0x1000050: {
                    this.gotoSelectedElement();
                    break;
                }
                case 0x1000002: {
                    this.fTableViewer.getTable().setFocus();
                    this.fTableViewer.getTable().setSelection(0);
                    break;
                }
                case 0x1000001: {
                    this.fTableViewer.getTable().setFocus();
                    this.fTableViewer.getTable().setSelection(this.fTableViewer.getTable().getItemCount() - 1);
                    break;
                }
                case 27: {
                    this.dispose();
                }
            }
        }));
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(768));
        return this.fFilterText;
    }

    private void setInfoSystemColor() {
        Color background;
        ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
        Color foreground = colorRegistry.get("org.eclipse.ui.workbench.INFORMATION_FOREGROUND");
        if (foreground == null) {
            foreground = JFaceColors.getInformationViewerForegroundColor((Display)this.fShell.getDisplay());
        }
        if ((background = colorRegistry.get("org.eclipse.ui.workbench.INFORMATION_BACKGROUND")) == null) {
            background = JFaceColors.getInformationViewerBackgroundColor((Display)this.fShell.getDisplay());
        }
        this.setForegroundColor(foreground);
        this.setBackgroundColor(background);
    }

    private void installFilter() {
        this.fFilterText.setMessage(WorkbenchSWTMessages.FilteredTree_FilterMessage);
        this.fFilterText.setText("");
        this.fFilterText.addModifyListener(e -> {
            String text = ((Text)e.widget).getText();
            this.setMatcherString(text);
        });
    }

    private void stringMatcherUpdated() {
        this.fTableViewer.getControl().setRedraw(false);
        this.fTableViewer.refresh();
        this.selectFirstMatch();
        this.fTableViewer.getControl().setRedraw(true);
    }

    private void setMatcherString(String pattern) {
        if (pattern.length() == 0) {
            this.fSearchPattern = null;
        } else {
            SearchPattern patternMatcher = new SearchPattern();
            patternMatcher.setPattern(pattern);
            this.fSearchPattern = patternMatcher;
        }
        this.stringMatcherUpdated();
    }

    private SearchPattern getMatcher() {
        return this.fSearchPattern;
    }

    protected Object getSelectedElement() {
        return this.fTableViewer.getStructuredSelection().getFirstElement();
    }

    protected abstract void gotoSelectedElement();

    protected abstract boolean deleteSelectedElement(Object var1);

    protected void selectFirstMatch() {
        Table table = this.fTableViewer.getTable();
        Object element = this.findElement(table.getItems());
        if (element != null) {
            this.fTableViewer.setSelection((ISelection)new StructuredSelection(element), true);
        } else {
            this.fTableViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    private Object findElement(TableItem[] items) {
        ILabelProvider labelProvider = (ILabelProvider)this.fTableViewer.getLabelProvider();
        TableItem[] tableItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            Object element = item.getData();
            if (this.fSearchPattern == null) {
                return element;
            }
            if (element != null) {
                String label = labelProvider.getText(element);
                if (label == null) {
                    return null;
                }
                if (label.startsWith("*")) {
                    label = label.substring(1);
                }
                if (this.fSearchPattern.matches(label)) {
                    return element;
                }
            }
            ++n2;
        }
        return null;
    }

    public void setVisible(boolean visible) {
        this.fShell.setVisible(visible);
    }

    public void dispose() {
        if (this.fShell != null) {
            if (!this.fShell.isDisposed()) {
                this.fShell.dispose();
            }
            this.fShell = null;
            this.fTableViewer = null;
            this.fComposite = null;
            this.fFilterText = null;
        }
    }

    public Point computeSizeHint() {
        int tableHeight;
        Table viewerTable = this.fTableViewer.getTable();
        Point tableSize = viewerTable.computeSize(-1, -1);
        int tableMaxHeight = this.fComposite.getDisplay().getBounds().height / 2;
        ((GridData)viewerTable.getLayoutData()).heightHint = tableHeight = tableSize.y <= tableMaxHeight ? tableSize.y - viewerTable.getItemHeight() - viewerTable.getItemHeight() / 2 : tableMaxHeight;
        Point fCompSize = this.fComposite.computeSize(-1, -1);
        this.fComposite.setSize(fCompSize);
        return fCompSize;
    }

    public void setLocation(Point location) {
        Rectangle trim = this.fShell.computeTrim(0, 0, 0, 0);
        Point textLocation = this.fComposite.getLocation();
        location.x += trim.x - textLocation.x;
        location.y += trim.y - textLocation.y;
        this.fShell.setLocation(location);
    }

    public void setSize(int width, int height) {
        this.fShell.setSize(width, height);
    }

    public Shell getShell() {
        return this.fShell;
    }

    private void setForegroundColor(Color foreground) {
        this.fTableViewer.getTable().setForeground(foreground);
        this.fFilterText.setForeground(foreground);
        this.fComposite.setForeground(foreground);
    }

    private void setBackgroundColor(Color background) {
        this.fTableViewer.getTable().setBackground(background);
        this.fFilterText.setBackground(background);
        this.fComposite.setBackground(background);
    }

    public void setFocus() {
        this.fShell.forceActive();
        this.fShell.forceFocus();
        this.fFilterText.setFocus();
    }

    protected class NamePatternFilter
    extends ViewerFilter {
        protected NamePatternFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            SearchPattern matcher = AbstractTableInformationControl.this.getMatcher();
            if (matcher == null || !(viewer instanceof TableViewer)) {
                return true;
            }
            TableViewer tableViewer = (TableViewer)viewer;
            String matchName = ((ILabelProvider)tableViewer.getLabelProvider()).getText(element);
            if (matchName == null) {
                return false;
            }
            if (matchName.startsWith("*")) {
                matchName = matchName.substring(1);
            }
            return matcher.matches(matchName);
        }
    }
}

