/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.pde.provider;

import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.oomph.base.BaseFactory;
import org.eclipse.oomph.base.BasePackage;
import org.eclipse.oomph.setup.pde.AbstractAPIBaselineTask;
import org.eclipse.oomph.setup.pde.PDEPackage;
import org.eclipse.oomph.setup.pde.provider.PDEEditPlugin;
import org.eclipse.oomph.setup.provider.SetupTaskItemProvider;

public class AbstractAPIBaselineTaskItemProvider
extends SetupTaskItemProvider {
    public AbstractAPIBaselineTaskItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addNamePropertyDescriptor(object);
            this.addActivatePropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addNamePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_AbstractAPIBaselineTask_name_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_AbstractAPIBaselineTask_name_feature", "_UI_AbstractAPIBaselineTask_type"), (EStructuralFeature)PDEPackage.Literals.ABSTRACT_API_BASELINE_TASK__NAME, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addActivatePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_AbstractAPIBaselineTask_activate_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_AbstractAPIBaselineTask_activate_feature", "_UI_AbstractAPIBaselineTask_type"), (EStructuralFeature)PDEPackage.Literals.ABSTRACT_API_BASELINE_TASK__ACTIVATE, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        AbstractAPIBaselineTask apiBaselineTask = (AbstractAPIBaselineTask)object;
        StringBuilder builder = new StringBuilder();
        String name = this.getName(object);
        Pattern NAME_LABEL_PATTERN = Pattern.compile("(.*?)[\\s-_]*(API)?[\\s-_]*(Baseline)?[\\s]*", 2);
        Matcher matcher = NAME_LABEL_PATTERN.matcher(name);
        if (matcher.matches()) {
            builder.append(matcher.group(1));
        } else {
            builder.append(name);
        }
        if (builder.length() != 0) {
            builder.append(' ');
        }
        builder.append(this.getString("_UI_APIBaselineTask_type"));
        if (apiBaselineTask.isActivate()) {
            builder.append(", activate");
        }
        return builder.toString();
    }

    protected String getName(Object object) {
        AbstractAPIBaselineTask apiBaselineTask = (AbstractAPIBaselineTask)object;
        String name = apiBaselineTask.getName();
        return name == null ? "" : name;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(AbstractAPIBaselineTask.class)) {
            case 10: 
            case 11: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(BasePackage.Literals.MODEL_ELEMENT__ANNOTATIONS, BaseFactory.eINSTANCE.createAnnotation()));
    }

    public ResourceLocator getResourceLocator() {
        return PDEEditPlugin.INSTANCE;
    }
}

