/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WorkerPool<P extends WorkerPool<P, K, W>, K, W extends Worker<K, P>> {
    private static final Comparator<Worker<?, ?>> COMPARATOR = new Comparator<Worker<?, ?>>(){

        @Override
        public int compare(Worker<?, ?> o1, Worker<?, ?> o2) {
            int result = (((Worker)o2).secondary ? 0 : 1) - (((Worker)o1).secondary ? 0 : 1);
            if (result == 0) {
                result = ((Worker)o2).id - ((Worker)o1).id;
            }
            return result;
        }
    };
    private final int maxWorker = 10;
    private final Map<K, W> workers = new HashMap<K, W>();
    private final List<W> pendingWorkers = new ArrayList<W>();
    private final AtomicBoolean workCanceled = new AtomicBoolean();
    private int nextWorkerID;
    private CountDownLatch latch;
    private boolean isCanceled;
    private IProgressMonitor monitor;

    protected WorkerPool() {
    }

    protected abstract W createWorker(K var1, int var2, boolean var3);

    protected final void begin(String taskName, IProgressMonitor monitor) {
        this.monitor = monitor;
        this.run(taskName, monitor);
        this.dispose();
    }

    protected void run(String taskName, IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    protected IProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void dispose() {
        this.monitor = null;
    }

    public synchronized void cancel() {
        this.isCanceled = true;
        for (Worker worker : this.workers.values()) {
            worker.cancel();
        }
        this.workers.clear();
        this.pendingWorkers.clear();
    }

    public boolean isCanceled() {
        if (this.monitor != null && this.monitor.isCanceled() && !this.workCanceled.getAndSet(true)) {
            this.cancel();
        }
        return this.isCanceled;
    }

    public final void perform(K key) {
        this.perform((Collection<? extends K>)Collections.singleton(key));
    }

    public final void perform(K ... keys) {
        this.perform((Collection<? extends K>)Arrays.asList(keys));
    }

    public void perform(Collection<? extends K> keys) {
        if (this.latch == null) {
            this.latch = new CountDownLatch(1);
        }
        if (this.schedule(keys)) {
            try {
                this.latch.await();
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
        this.latch = null;
    }

    public final boolean schedule(K key) {
        return this.schedule((Collection<? extends K>)Collections.singleton(key));
    }

    public final boolean schedule(K ... keys) {
        return this.schedule((Collection<? extends K>)Arrays.asList(keys));
    }

    public synchronized boolean schedule(Collection<? extends K> keys) {
        boolean result = false;
        for (K key : keys) {
            if (!this.schedule(key, false)) continue;
            result = true;
        }
        return result;
    }

    protected synchronized boolean schedule(K key, boolean secondary) {
        if (this.isCanceled() || this.isCompleted(key)) {
            return false;
        }
        Worker worker = (Worker)((Object)this.workers.get(key));
        if (worker != null) {
            if (!secondary && worker.secondary && this.pendingWorkers.contains((Object)worker)) {
                worker.secondary = false;
                Collections.sort(this.pendingWorkers, COMPARATOR);
            }
        } else {
            worker = this.createWorker(key, ++this.nextWorkerID, secondary);
            this.workers.put(key, (W)((Object)worker));
            if (this.isWorkPossible()) {
                worker.schedule();
            } else {
                this.pendingWorkers.add((W)((Object)worker));
                Collections.sort(this.pendingWorkers, COMPARATOR);
            }
        }
        return true;
    }

    private synchronized void deschedule(K key) {
        this.workers.remove(key);
        if (!this.isCanceled() && !this.pendingWorkers.isEmpty()) {
            Worker worker = (Worker)((Object)this.pendingWorkers.remove(0));
            worker.schedule();
        }
        if (this.latch != null && this.workers.isEmpty()) {
            this.latch.countDown();
        }
    }

    private boolean isWorkPossible() {
        int pending;
        int all = this.workers.size() - 1;
        int running = all - (pending = this.pendingWorkers.size());
        return running < 10;
    }

    protected boolean isCompleted(K key) {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Worker<K, P extends WorkerPool<? extends P, K, ? extends Worker<K, P>>>
    extends Job {
        private P workPool;
        private final K key;
        private final int id;
        private boolean secondary;

        protected Worker(String name, P workPool, K key, int id, boolean secondary) {
            super(name);
            this.workPool = workPool;
            this.key = key;
            this.id = id;
            this.secondary = secondary;
        }

        protected abstract IStatus perform(IProgressMonitor var1);

        public K getKey() {
            return this.key;
        }

        public P getWorkPool() {
            return this.workPool;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                IStatus iStatus = this.perform(monitor);
                return iStatus;
            }
            finally {
                ((WorkerPool)this.workPool).deschedule(this.key);
            }
        }

        public String toString() {
            return "key=" + this.key + ", secondary=" + this.secondary + ", id=" + this.id;
        }
    }
}

