/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.oomph.internal.ui.UIPropertyTester;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.Preferences;

public class SetupPropertyTester
extends PropertyTester {
    public static final String SHOW_TOOL_BAR_CONTRIBUTIONS = "showToolBarContributions";
    private static final Preferences PREFERENCES = SetupUIPlugin.INSTANCE.getInstancePreferences();
    private static boolean initialized;
    private static boolean starting;
    private static IStatus performingStatus;
    private static Shell performingShell;
    private static Shell handlingShell;

    static {
        ((IEclipsePreferences)PREFERENCES).addPreferenceChangeListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if (SetupPropertyTester.SHOW_TOOL_BAR_CONTRIBUTIONS.equals(event.getKey())) {
                    UIPropertyTester.requestEvaluation((String)"org.eclipse.oomph.setup.ui.showToolBarContributions", (boolean)"true".equals(event.getNewValue()));
                }
            }
        });
        if (!initialized) {
            new Thread(){

                public void run() {
                    try {
                        2.sleep(2000L);
                        initialized = true;
                        UIPropertyTester.requestEvaluation((String)"org.eclipse.oomph.setup.ui.showToolBarContributions", (boolean)true);
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
            }.start();
        }
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if ("starting".equals(property)) {
            return this.testStarting(receiver, args, expectedValue);
        }
        if ("performing".equals(property)) {
            return this.testPerforming(receiver, args, expectedValue);
        }
        if ("handling".equals(property)) {
            return this.testHandling(receiver, args, expectedValue);
        }
        if (SHOW_TOOL_BAR_CONTRIBUTIONS.equals(property)) {
            if (expectedValue == null) {
                expectedValue = Boolean.TRUE;
            }
            boolean value = initialized ? PREFERENCES.getBoolean(SHOW_TOOL_BAR_CONTRIBUTIONS, false) : false;
            return expectedValue.equals(value);
        }
        return false;
    }

    private boolean testStarting(Object receiver, Object[] args, Object expectedValue) {
        if (expectedValue == null) {
            expectedValue = Boolean.TRUE;
        }
        return expectedValue.equals(starting);
    }

    private boolean testPerforming(Object receiver, Object[] args, Object expectedValue) {
        if (expectedValue == null) {
            expectedValue = Boolean.TRUE;
        }
        return expectedValue.equals(performingShell != null);
    }

    private boolean testHandling(Object receiver, Object[] args, Object expectedValue) {
        if (expectedValue == null) {
            expectedValue = Boolean.TRUE;
        }
        return expectedValue.equals(handlingShell != null);
    }

    public static void setStarting(boolean starting) {
        SetupPropertyTester.starting = starting;
        UIPropertyTester.requestEvaluation((String)"org.eclipse.oomph.setup.ui.starting", (boolean)false);
    }

    public static Shell getPerformingShell() {
        return performingShell;
    }

    public static IStatus getPerformingStatus() {
        return performingStatus;
    }

    public static void setPerformingStatus(IStatus performingStatus) {
        SetupPropertyTester.performingStatus = performingStatus;
    }

    public static void setPerformingShell(Shell shell) {
        performingShell = shell;
        if (shell != null) {
            shell.setVisible(false);
            shell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    SetupPropertyTester.setPerformingShell(null);
                }
            });
        }
        UIPropertyTester.requestEvaluation((String)"org.eclipse.oomph.setup.ui.performing", (shell != null ? 1 : 0) != 0);
    }

    public static Shell getHandlingShell() {
        return handlingShell;
    }

    public static void setHandlingShell(Shell shell) {
        handlingShell = shell;
        if (shell != null) {
            shell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    SetupPropertyTester.setHandlingShell(null);
                }
            });
        }
        UIPropertyTester.requestEvaluation((String)"org.eclipse.oomph.setup.ui.handling", (boolean)false);
    }
}

