/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.internal.osgi.weaving;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.objectteams.internal.osgi.weaving.AspectBinding;
import org.eclipse.objectteams.internal.osgi.weaving.AspectPermissionManager;
import org.eclipse.objectteams.internal.osgi.weaving.Pair;
import org.eclipse.objectteams.internal.osgi.weaving.Util;
import org.eclipse.objectteams.internal.osgi.weaving.WaitingTeamRecord;
import org.eclipse.objectteams.otequinox.ActivationKind;
import org.eclipse.objectteams.otequinox.TransformerPlugin;
import org.eclipse.objectteams.otredyn.runtime.TeamManager;
import org.eclipse.objectteams.otredyn.transformer.jplis.ObjectTeamsTransformer;
import org.objectteams.Team;
import org.osgi.framework.Bundle;
import org.osgi.framework.hooks.weaving.WovenClass;

@NonNullByDefault
public class TeamLoader {
    private List<WaitingTeamRecord> deferredTeams;
    private Set<String> beingDefined;
    boolean useDynamicWeaving;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$objectteams$otequinox$ActivationKind;

    public TeamLoader(List<WaitingTeamRecord> deferredTeams, Set<String> beingDefined, boolean useDynamicWeaving) {
        this.deferredTeams = deferredTeams;
        this.beingDefined = beingDefined;
        this.useDynamicWeaving = useDynamicWeaving;
    }

    public void loadTeamsForBase(AspectBinding.BaseBundle baseBundle, WovenClass baseClass, AspectPermissionManager permissionManager) {
        Set<AspectBinding.TeamBinding> deniedTeams;
        @NonNull String className = baseClass.getClassName();
        Collection teamsForBase = baseBundle.teamsPerBase.get(className);
        if (teamsForBase == null) {
            return;
        }
        boolean permissionManagerReady = permissionManager.isReady();
        if (permissionManagerReady && !(deniedTeams = permissionManager.checkAspectPermissionDenial(teamsForBase)).isEmpty()) {
            for (WaitingTeamRecord rec : new ArrayList<WaitingTeamRecord>(this.deferredTeams)) {
                if (!deniedTeams.contains(rec.team)) continue;
                this.deferredTeams.remove(rec);
            }
        }
        ArrayList<Team> teamInstances = new ArrayList<Team>();
        for (AspectBinding.TeamBinding teamForBase : teamsForBase) {
            Team instance;
            if (teamForBase.isActivated) continue;
            if (teamForBase.hasBeenDenied()) {
                TransformerPlugin.log(2, "Not activating team " + teamForBase.teamName + " due to denied permissions.");
                continue;
            }
            Class<? extends Team> teamClass = teamForBase.loadTeamClass();
            if (teamClass == null) {
                TransformerPlugin.log(new ClassNotFoundException("Not found: " + String.valueOf(teamForBase)), "Failed to load team " + String.valueOf(teamForBase));
                continue;
            }
            ActivationKind activationKind = teamForBase.getActivation();
            if (activationKind == ActivationKind.NONE) {
                if ((teamForBase = teamForBase.getOtherTeamToActivate()) == null || teamForBase.isActivated) continue;
                activationKind = teamForBase.getActivation();
                teamClass = teamForBase.loadTeamClass();
                if (teamClass == null) {
                    TransformerPlugin.log(new ClassNotFoundException("Not found: " + teamForBase.teamName + " in bundle " + teamForBase.getAspectBinding().aspectPlugin), "Failed to load team " + String.valueOf(teamForBase));
                    continue;
                }
            }
            if (activationKind == ActivationKind.NONE || (instance = this.instantiateAndActivate(teamForBase.getAspectBinding(), teamForBase, activationKind)) == null) continue;
            teamInstances.add(instance);
        }
        if (!permissionManagerReady) {
            permissionManager.addBaseBundleObligations(teamInstances, teamsForBase, baseBundle);
        }
    }

    public static @Nullable Pair<URL, String> findTeamClassResource(String className, Bundle bundle) {
        for (String candidate : TeamLoader.possibleTeamNames(className)) {
            URL result = bundle.getResource(candidate.replace('.', '/') + ".class");
            if (result == null) continue;
            return new Pair<URL, String>(result, candidate);
        }
        return null;
    }

    public static List<String> possibleTeamNames(String currentName) {
        int pos;
        ArrayList<String> result = new ArrayList<String>();
        result.add((String)currentName);
        int sep = 46;
        if (((String)currentName).indexOf(36) > -1) {
            sep = 36;
        }
        int from = ((String)currentName).length() - 1;
        while ((pos = ((String)currentName).lastIndexOf(sep, from)) != -1) {
            String prefix = ((String)currentName).substring(0, pos);
            String postfix = ((String)currentName).substring(pos + 1);
            if (sep == 36) {
                if (!postfix.startsWith("__OT__")) {
                    currentName = prefix + "$__OT__" + postfix;
                    result.add(0, (String)currentName);
                }
            } else {
                int prevDot = prefix.lastIndexOf(46);
                if (prevDot <= -1 || !Character.isUpperCase(prefix.charAt(prevDot + 1))) break;
                currentName = prefix + "$__OT__" + postfix;
                result.add(0, (String)currentName);
            }
            from = pos - 1;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable Team instantiateAndActivate(AspectBinding aspectBinding, AspectBinding.TeamBinding team, ActivationKind activationKind) {
        for (AspectBinding.TeamBinding equivalent : team.equivalenceSet) {
            if (equivalent.instance == null || !equivalent.isActivated) continue;
            return equivalent.instance;
        }
        teamName = team.teamName;
        var5_4 = aspectBinding;
        synchronized (var5_4) {
            block33: {
                if (this.isReadyToLoad(aspectBinding, team, teamName, activationKind)) break block33;
                if (this.useDynamicWeaving) {
                    TeamManager.prepareTeamActivation(team.teamClass);
                }
                return null;
            }
            for (AspectBinding.TeamBinding equivalent : team.equivalenceSet) {
                equivalent.isActivated = true;
            }
        }
        try {
            time = 0L;
            if (Util.PROFILE) {
                time = System.nanoTime();
            }
            instance = team.getInstance();
            try {
                switch (TeamLoader.$SWITCH_TABLE$org$eclipse$objectteams$otequinox$ActivationKind()[activationKind.ordinal()]) {
                    case 3: {
                        instance.activate(Team.ALL_THREADS);
                        TransformerPlugin.log(1, "Activated team " + teamName);
                        break;
                    }
                    case 2: {
                        instance.activate();
                        TransformerPlugin.log(1, "Activated team " + teamName);
                        break;
                    }
                }
                if (Util.PROFILE) {
                    Util.profile(time, Util.ProfileKind.Activation, teamName);
                }
            }
            catch (ClassCircularityError | NoClassDefFoundError e) {
                try {
                    switch (TeamLoader.$SWITCH_TABLE$org$eclipse$objectteams$otequinox$ActivationKind()[activationKind.ordinal()]) {
                        case 3: {
                            instance.deactivate(Team.ALL_THREADS);
                            break;
                        }
                        case 2: {
                            instance.deactivate();
                            break;
                        }
                    }
                }
                catch (Throwable var9_13) {
                    // empty catch block
                }
                ** for (eq : team.equivalenceSet)
            }
lbl-1000:
            // 1 sources

            {
                eq.isActivated = false;
                continue;
            }
lbl53:
            // 1 sources

            notFoundName = e.getMessage().replace('/', '.');
            var10_15 = this.deferredTeams;
            synchronized (var10_15) {
                this.deferredTeams.add(new WaitingTeamRecord(team, activationKind, notFoundName));
            }
            catch (Throwable t) {
                TransformerPlugin.log(t, "Failed to activate team " + teamName);
            }
            return instance;
        }
        catch (ClassCircularityError e) {
            ** for (eq : team.equivalenceSet)
        }
lbl-1000:
        // 1 sources

        {
            eq.isActivated = false;
            continue;
        }
lbl69:
        // 1 sources

        notFoundName = e.getMessage().replace('/', '.');
        var7_9 = this.deferredTeams;
        synchronized (var7_9) {
            this.deferredTeams.add(new WaitingTeamRecord(team, activationKind, notFoundName));
        }
        catch (Throwable e) {
            TransformerPlugin.log(e, "Failed to instantiate team " + teamName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isReadyToLoad(AspectBinding aspectBinding, AspectBinding.TeamBinding team, String teamName, ActivationKind activationKind) {
        String unloadableBaseClass = this.findUnloadableBaseClass(team);
        if (unloadableBaseClass != null) {
            List<WaitingTeamRecord> list = this.deferredTeams;
            synchronized (list) {
                WaitingTeamRecord record = new WaitingTeamRecord(team, activationKind, unloadableBaseClass);
                this.deferredTeams.add(record);
            }
            TransformerPlugin.log(1, "Defer instantation/activation of team " + teamName + ", waiting for " + unloadableBaseClass);
            return false;
        }
        return true;
    }

    private @Nullable String findUnloadableBaseClass(AspectBinding.TeamBinding team) {
        for (String baseclass : team.baseClassNames) {
            if (!this.beingDefined.contains(baseclass)) continue;
            return baseclass;
        }
        Class<? extends Team> teamClass = team.teamClass;
        if (teamClass != null) {
            ClassLoader tryLoader = new ClassLoader(teamClass.getClassLoader()){};
            for (String baseclass : team.baseClassNames) {
                Boolean previous = (Boolean)ObjectTeamsTransformer.initiatedByThrowAwayLoader.get();
                try {
                    try {
                        ObjectTeamsTransformer.initiatedByThrowAwayLoader.set(Boolean.TRUE);
                        tryLoader.loadClass(baseclass);
                    }
                    catch (Throwable t) {
                        String string = baseclass;
                        ObjectTeamsTransformer.initiatedByThrowAwayLoader.set(previous);
                        return string;
                    }
                }
                finally {
                    ObjectTeamsTransformer.initiatedByThrowAwayLoader.set(previous);
                }
            }
        }
        return null;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$objectteams$otequinox$ActivationKind() {
        if ($SWITCH_TABLE$org$eclipse$objectteams$otequinox$ActivationKind != null) {
            return $SWITCH_TABLE$org$eclipse$objectteams$otequinox$ActivationKind;
        }
        int[] nArray = new int[ActivationKind.values().length];
        try {
            nArray[ActivationKind.ALL_THREADS.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ActivationKind.NONE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ActivationKind.THREAD.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$eclipse$objectteams$otequinox$ActivationKind = nArray;
        return nArray;
    }
}

