/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.debug.ui.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Message;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaBreakpointListener;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaInterfaceType;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaStratumLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.IRoleType;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.core.hierarchy.OTTypeHierarchies;
import org.eclipse.objectteams.otdt.debug.ui.OTDebugUIPlugin;
import org.eclipse.objectteams.otdt.debug.ui.internal.BreakpointMessages;

public class CopyInheritanceBreakpointManager
implements IJavaBreakpointListener,
IResourceChangeListener {
    private static final Object OT_BREAKPOINT_COPY = "OT_BREAKPOINT_COPY";
    private static final String ROLE_CLASS_SEPARATOR = "$__OT__";
    private Map<IMarker, List<IJavaBreakpoint>> copiedBreakpoints = new HashMap<IMarker, List<IJavaBreakpoint>>();

    public void addingBreakpoint(IJavaDebugTarget target, IJavaBreakpoint breakpoint) {
    }

    public void breakpointInstalled(IJavaDebugTarget target, IJavaBreakpoint breakpoint) {
    }

    public void breakpointHasRuntimeException(IJavaLineBreakpoint breakpoint, DebugException exception) {
    }

    public void breakpointHasCompilationErrors(IJavaLineBreakpoint breakpoint, Message[] errors) {
    }

    public int breakpointHit(IJavaThread thread, IJavaBreakpoint breakpoint) {
        return 4;
    }

    public int installingBreakpoint(IJavaDebugTarget target, IJavaBreakpoint breakpoint, IJavaType type) {
        block6: {
            block5: {
                if (!this.isBreakpointCopy(breakpoint)) break block5;
                return 1;
            }
            if (type instanceof IJavaInterfaceType) break block6;
            return 4;
        }
        try {
            if (breakpoint instanceof IJavaLineBreakpoint) {
                this.addTSubBreakpointsFor(type, (IJavaLineBreakpoint)breakpoint, target);
            }
        }
        catch (CoreException ex) {
            OTDebugUIPlugin.logException("Problem with breakpoint handling", ex);
        }
        return 4;
    }

    private boolean isBreakpointCopy(IJavaBreakpoint breakpoint) throws CoreException {
        IMarker marker = breakpoint.getMarker();
        if (marker == null) {
            return false;
        }
        Map properties = marker.getAttributes();
        return properties.containsKey(OT_BREAKPOINT_COPY);
    }

    private void addTSubBreakpointsFor(IJavaType triggerType, IJavaLineBreakpoint breakpoint, IJavaDebugTarget target) throws CoreException {
        IMarker marker = breakpoint.getMarker();
        IType type = BreakpointUtils.getType((IJavaBreakpoint)breakpoint);
        IOTType otType = OTModelManager.getOTElement((IType)type);
        if (otType == null) {
            return;
        }
        if (!otType.getFullyQualifiedName('$').equals(triggerType.getName())) {
            return;
        }
        List<IJavaBreakpoint> existingCopies = this.copiedBreakpoints.get(marker);
        if (existingCopies != null) {
            for (IJavaBreakpoint existingCopy : existingCopies) {
                target.breakpointAdded((IBreakpoint)existingCopy);
            }
            return;
        }
        IType[] tsubClasses = new TSubClassComputer((IRoleType)otType).getSubClasses();
        if (tsubClasses == null || tsubClasses.length == 0) {
            return;
        }
        String fileName = type.getCompilationUnit().getElementName();
        ArrayList<IJavaLineBreakpoint> newBreakpoints = new ArrayList<IJavaLineBreakpoint>(tsubClasses.length);
        IType[] iTypeArray = tsubClasses;
        int n = tsubClasses.length;
        int n2 = 0;
        while (n2 < n) {
            IType tsubClass = iTypeArray[n2];
            IJavaLineBreakpoint newBreakpoint = this.propagateBreakpoint(breakpoint, fileName, tsubClass, target);
            if (newBreakpoint != null) {
                newBreakpoints.add(newBreakpoint);
            }
            ++n2;
        }
        this.copiedBreakpoints.put(marker, newBreakpoints);
    }

    private IJavaLineBreakpoint propagateBreakpoint(IJavaLineBreakpoint breakpoint, String fileName, IType destType, IJavaDebugTarget target) throws CoreException {
        if (destType == null) {
            OTDebugUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.objectteams.otdt.debug.ui", "CopyInheritanceBreakpointManager.propagateBreakpoint(): tsub type is null"));
            return null;
        }
        CoreException ex = null;
        int sourceLineNumber = -1;
        try {
            sourceLineNumber = breakpoint.getLineNumber();
        }
        catch (CoreException ce) {
            ex = ce;
        }
        if (sourceLineNumber == -1 || ex != null) {
            OTDebugUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.objectteams.otdt.debug.ui", "CopyInheritanceBreakpointManager.propagateBreakpoint(): source line number not found", (Throwable)ex));
            return null;
        }
        return this.duplicateBreakpoint(breakpoint, fileName, destType, sourceLineNumber, target);
    }

    private IJavaLineBreakpoint duplicateBreakpoint(IJavaLineBreakpoint breakpoint, String fileName, IType destType, int sourceLineNumber, IJavaDebugTarget target) throws CoreException {
        Map properties = this.getBreakpointProperties(breakpoint);
        Boolean origEnabled = (Boolean)properties.get("org.eclipse.debug.core.enabled");
        String destName = this.getClassPartName(destType);
        IJavaStratumLineBreakpoint newBreakpoint = JDIDebugModel.createStratumBreakpoint((IResource)breakpoint.getMarker().getResource(), (String)"OTJ", (String)fileName, null, (String)destName, (int)sourceLineNumber, (int)-1, (int)-1, (int)breakpoint.getHitCount(), (boolean)false, (Map)properties);
        if (!origEnabled.booleanValue()) {
            try {
                newBreakpoint.getMarker().setAttribute("org.eclipse.debug.core.enabled", (Object)Boolean.FALSE);
            }
            catch (CoreException ex) {
                OTDebugUIPlugin.logException("Unable to disable breakpoint", ex);
            }
        }
        target.getDebugTarget().breakpointAdded((IBreakpoint)newBreakpoint);
        return newBreakpoint;
    }

    String getClassPartName(IType type) {
        IType enclosing = type.getDeclaringType();
        try {
            if (enclosing != null && Flags.isTeam((int)enclosing.getFlags())) {
                return this.getClassPartName(enclosing) + ROLE_CLASS_SEPARATOR + type.getElementName();
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return type.getFullyQualifiedName();
    }

    private Map getBreakpointProperties(IJavaLineBreakpoint breakpoint) {
        HashMap<Object, Comparable<Boolean>> properties = new HashMap<Object, Comparable<Boolean>>(13);
        try {
            properties.putAll(breakpoint.getMarker().getAttributes());
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        properties.put("org.eclipse.debug.core.persisted", Boolean.FALSE);
        properties.put("severity", Integer.valueOf(1));
        properties.put(OT_BREAKPOINT_COPY, Boolean.TRUE);
        return properties;
    }

    public void breakpointRemoved(IJavaDebugTarget target, IJavaBreakpoint breakpoint) {
        IMarker marker = breakpoint.getMarker();
        if (marker == null || !marker.exists()) {
            return;
        }
        List<IJavaBreakpoint> copies = this.copiedBreakpoints.get(marker);
        if (copies == null) {
            return;
        }
        ArrayList<IJavaBreakpoint> remainingCopies = new ArrayList<IJavaBreakpoint>(copies.size());
        for (IJavaBreakpoint copy : copies) {
            target.getDebugTarget().breakpointRemoved((IBreakpoint)copy, null);
            try {
                if (copy.isInstalled()) {
                    remainingCopies.add(copy);
                    continue;
                }
                copy.delete();
            }
            catch (CoreException ex) {
                OTDebugUIPlugin.logException("Unable to query copied breakpoint", ex);
            }
        }
        if (remainingCopies.size() == 0) {
            this.copiedBreakpoints.remove(marker);
        } else if (remainingCopies.size() != copies.size()) {
            this.copiedBreakpoints.put(marker, remainingCopies);
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IMarkerDelta[] markerDeltas = event.findMarkerDeltas(IBreakpoint.BREAKPOINT_MARKER, true);
        if (markerDeltas == null) {
            return;
        }
        IMarkerDelta[] iMarkerDeltaArray = markerDeltas;
        int n = markerDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerDelta markerDelta = iMarkerDeltaArray[n2];
            if (markerDelta.getKind() == 4) {
                List<IJavaBreakpoint> breakpoints;
                Boolean newEnabled;
                IMarker marker = markerDelta.getMarker();
                Boolean oldEnabled = markerDelta.getAttribute("org.eclipse.debug.core.enabled", Boolean.FALSE.booleanValue());
                if (!oldEnabled.equals(newEnabled = Boolean.valueOf(marker.getAttribute("org.eclipse.debug.core.enabled", Boolean.FALSE.booleanValue()))) && (breakpoints = this.copiedBreakpoints.get(marker)) != null) {
                    for (final IJavaBreakpoint copy : breakpoints) {
                        Job job = new Job(BreakpointMessages.CopyInheritanceBreakpointManager_toggle_enablement_job){

                            protected IStatus run(IProgressMonitor monitor) {
                                try {
                                    copy.setEnabled(newEnabled.booleanValue());
                                    return Status.OK_STATUS;
                                }
                                catch (CoreException e) {
                                    return new Status(4, "org.eclipse.objectteams.otdt.debug.ui", "Error toggling copied breakpoint enablement", (Throwable)e);
                                }
                            }
                        };
                        job.setRule((ISchedulingRule)event.getResource());
                        job.schedule();
                    }
                }
            }
            ++n2;
        }
    }

    private class TSubClassComputer
    implements IRunnableWithProgress {
        private ITypeHierarchy _hierarchy;
        private IRoleType _roleType;
        private IType[] _subClasses;

        public TSubClassComputer(IRoleType otType) {
            this._roleType = otType;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(BreakpointMessages.CopyInheritanceBreakpointManager_find_tsub_types_task, 1);
            SubProgressMonitor mon = new SubProgressMonitor(monitor, 1);
            try {
                try {
                    this._hierarchy = this._roleType.newTypeHierarchy((IProgressMonitor)mon);
                    OTTypeHierarchies.getInstance().setPhantomMode(this._hierarchy, true);
                    this._subClasses = OTTypeHierarchies.getInstance().getAllTSubTypes(this._hierarchy, (IType)this._roleType);
                }
                catch (JavaModelException ex) {
                    throw new InvocationTargetException(ex);
                }
            }
            finally {
                mon.done();
            }
        }

        public IType[] getSubClasses() {
            try {
                this.run((IProgressMonitor)new NullProgressMonitor());
            }
            catch (InvocationTargetException ex) {
                if (ex.getCause() instanceof CoreException) {
                    OTDebugUIPlugin.logException("Error creating type hiearchy", (CoreException)ex.getCause());
                } else {
                    OTDebugUIPlugin.logException("Error creating type hiearchy", ex);
                }
            }
            catch (InterruptedException ex) {
                OTDebugUIPlugin.logException("Error creating type hiearchy", ex);
            }
            return this._subClasses;
        }
    }
}

