/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.codeassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.internal.codeassist.select.SelectionNodeFound;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.MemberTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.internal.codeassist.SelectionNodesFound;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.AbstractMethodMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.BaseCallMessageSend;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.CallinMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;

public class SelectionOnBaseCallMessageSend
extends BaseCallMessageSend {
    public SelectionOnBaseCallMessageSend(MessageSend wrappee, int baseEndPosition) {
        super(wrappee, baseEndPosition);
    }

    public TypeBinding resolveType(BlockScope scope) {
        block6: {
            try {
                super.resolveType(scope);
            }
            catch (SelectionNodeFound snf) {
                if (snf.binding instanceof MethodBinding && MethodModel.isFakedMethod((MethodBinding)((MethodBinding)snf.binding))) break block6;
                throw snf;
            }
        }
        MessageSend wrappee = this._sendOrig;
        if (wrappee.binding == null || !wrappee.binding.isValidBinding() && wrappee.binding.problemId() != 2 && wrappee.binding.problemId() != 5 && wrappee.binding.problemId() != 6 && wrappee.binding.problemId() != 7) {
            throw new SelectionNodeFound();
        }
        MethodScope methodScope = scope.methodScope();
        if (methodScope == null) {
            throw new SelectionNodeFound();
        }
        SourceTypeBinding site = scope.enclosingSourceType();
        MethodDeclaration callinDecl = SelectionOnBaseCallMessageSend.findEnclosingCallinMethod((Scope)methodScope, null);
        if (callinDecl == null) {
            throw new SelectionNodeFound();
        }
        MethodBinding callinMethod = callinDecl.binding;
        MemberTypeBinding role = site.isLocalType() ? (MemberTypeBinding)callinMethod.declaringClass : (MemberTypeBinding)site;
        MethodBinding[] baseBindings = this.findBaseMethodBindings(role, callinMethod);
        if (baseBindings == null || baseBindings.length == 0) {
            throw new SelectionNodeFound();
        }
        throw new SelectionNodesFound((Binding[])baseBindings);
    }

    private MethodBinding[] findBaseMethodBindings(MemberTypeBinding role, MethodBinding roleMethod) {
        List<CallinMappingDeclaration> foundMappings = this.findMappings(role, roleMethod);
        ReferenceBinding baseClass = role.getRealClass().baseclass();
        if (foundMappings.isEmpty() || baseClass == null) {
            return null;
        }
        int baseMethodsCount = 0;
        for (CallinMappingDeclaration mapping : foundMappings) {
            baseMethodsCount += mapping.baseMethodSpecs.length;
        }
        MethodBinding[] baseMethodBindings = new MethodBinding[baseMethodsCount];
        for (CallinMappingDeclaration foundMapping : foundMappings) {
            int idx = 0;
            while (idx < foundMapping.baseMethodSpecs.length) {
                baseMethodBindings[--baseMethodsCount] = foundMapping.baseMethodSpecs[idx].resolvedMethod;
                ++idx;
            }
        }
        return baseMethodBindings;
    }

    private List<CallinMappingDeclaration> findMappings(MemberTypeBinding role, MethodBinding roleMethod) {
        TypeDeclaration roleDeclaration = role.model.getAst();
        ArrayList<CallinMappingDeclaration> foundMappings = new ArrayList<CallinMappingDeclaration>();
        AbstractMethodMappingDeclaration[] mappings = roleDeclaration.callinCallouts;
        if (mappings != null) {
            int idx = 0;
            while (idx < mappings.length) {
                if (mappings[idx].binding._roleMethodBinding == roleMethod && mappings[idx] instanceof CallinMappingDeclaration) {
                    foundMappings.add((CallinMappingDeclaration)mappings[idx]);
                }
                ++idx;
            }
        }
        return foundMappings;
    }

    public StringBuilder printExpression(int indent, StringBuilder output) {
        MessageSend wrappee = (MessageSend)this._wrappee;
        output.append("<SelectOnBaseCallMessageSend:");
        if (!wrappee.receiver.isImplicitThis()) {
            wrappee.receiver.printExpression(0, output).append('.');
        }
        output.append(wrappee.selector).append('(');
        if (wrappee.arguments != null) {
            int i = 1;
            while (i < wrappee.arguments.length) {
                if (i > 0) {
                    output.append(", ");
                }
                wrappee.arguments[i].printExpression(0, output);
                ++i;
            }
        }
        return output.append(")>");
    }
}

