/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.bytecode;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileStruct;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.ListValueAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.CallinCalloutBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.PrecedenceBinding;

public class CallinPrecedenceAttribute
extends ListValueAttribute {
    private char[][] callinNames;

    public CallinPrecedenceAttribute(ReferenceBinding site, CallinCalloutBinding[] callins) {
        super(IOTConstants.CALLIN_PRECEDENCE, callins.length, 2);
        CallinCalloutBinding callinBinding;
        int count = 0;
        int i = 0;
        while (i < callins.length) {
            callinBinding = callins[i];
            if (callinBinding != null && callinBinding.isValidBinding()) {
                ++count;
            }
            ++i;
        }
        this.callinNames = new char[count][];
        this._count = count;
        count = 0;
        i = 0;
        while (i < callins.length) {
            callinBinding = callins[i];
            if (callinBinding != null && callinBinding.isValidBinding()) {
                this.callinNames[count++] = this.getQualifiedName(site, callinBinding);
            }
            ++i;
        }
    }

    private char[] getQualifiedName(ReferenceBinding site, CallinCalloutBinding callinBinding) {
        Object name = new String(callinBinding.name);
        ReferenceBinding current = callinBinding.introducingRoleClass();
        while (current != null && TypeBinding.notEquals(current, site)) {
            name = new String(current.sourceName()) + "." + (String)name;
            current = current.enclosingType();
        }
        return ((String)name).toCharArray();
    }

    public CallinPrecedenceAttribute(ClassFileStruct reader, int readOffset, int[] constantPoolOffsets) {
        super(IOTConstants.CALLIN_PRECEDENCE, 0, 2);
        this.readList(reader, readOffset, 0, constantPoolOffsets);
    }

    @Override
    void writeElementValue(int i) {
        this.writeName(this.callinNames[i]);
    }

    @Override
    void read(int i) {
        if (i == 0) {
            this.callinNames = new char[this._count][];
        }
        this.callinNames[i] = this.consumeName();
    }

    @Override
    public void evaluate(Binding binding, LookupEnvironment environment, char[][][] missingTypeNames) {
        this.checkBindingMismatch(binding, Integer.MIN_VALUE);
        if (((ReferenceBinding)binding).isTeam()) {
            ((ReferenceBinding)binding).getTeamModel().addAttribute(this);
        }
    }

    @Override
    public void evaluateLateAttribute(ReferenceBinding enclosingType, int state) {
        if (state != 22) {
            return;
        }
        CallinCalloutBinding[] mappings = new CallinCalloutBinding[this.callinNames.length];
        int i = 0;
        while (i < this.callinNames.length) {
            char[][] parts = CharOperation.splitOn('.', this.callinNames[i]);
            int j = 0;
            ReferenceBinding currentType = enclosingType;
            while (j < parts.length - 1) {
                currentType = currentType.getMemberType(CharOperation.concat(IOTConstants.OT_DELIM_NAME, parts[j++]));
            }
            if (currentType == null) {
                throw new InternalCompilerError("Can't resolve type for precedence declaration " + new String(this.callinNames[i]));
            }
            CallinCalloutBinding[] callinCallouts = currentType.callinCallouts;
            if (callinCallouts != null) {
                int k = 0;
                while (k < callinCallouts.length) {
                    if (callinCallouts[k].type == 1 && CharOperation.equals(callinCallouts[k].name, parts[j])) {
                        mappings[i] = callinCallouts[k];
                        break;
                    }
                    ++k;
                }
            }
            if (mappings[i] == null) {
                throw new InternalCompilerError("Precedence attribute has unresolved method mapping");
            }
            ++i;
        }
        int len = enclosingType.precedences.length;
        if (len == 0) {
            enclosingType.precedences = new PrecedenceBinding[1];
        } else {
            enclosingType.precedences = new PrecedenceBinding[len + 1];
            System.arraycopy(enclosingType.precedences, 0, enclosingType.precedences, 0, len);
        }
        enclosingType.precedences[len] = new PrecedenceBinding(enclosingType, mappings);
    }

    @Override
    String toString(int i) {
        return new String(this.callinNames[i]);
    }
}

