/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.util;

import java.lang.ref.SoftReference;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.core.util.Util;

public class ResourceCompilationUnit
implements ICompilationUnit {
    private final IFile file;
    private volatile SoftReference<char[]> contentRef;
    private final char[] fileName;
    private final char[] mainTypeName;
    private final char[] module;

    public ResourceCompilationUnit(IFile file, char[] mod) {
        int end;
        this.file = file;
        this.module = mod;
        String f = file.getFullPath().toString();
        this.fileName = f.toCharArray();
        int start = f.lastIndexOf("/") + 1;
        if (start == 0 || start < f.lastIndexOf("\\")) {
            start = f.lastIndexOf("\\") + 1;
        }
        if ((end = f.lastIndexOf(".")) == -1) {
            end = f.length();
        }
        this.mainTypeName = f.substring(start, end).toCharArray();
    }

    public char[] getContents() {
        char[] contents;
        char[] cachedContents;
        SoftReference<char[]> cr = this.contentRef;
        if (cr != null && (cachedContents = cr.get()) != null) {
            return cachedContents;
        }
        try {
            contents = Util.getResourceContentsAsCharArray(this.file);
        }
        catch (CoreException coreException) {
            contents = CharOperation.NO_CHAR;
        }
        this.contentRef = new SoftReference<char[]>(contents);
        return contents;
    }

    public char[] getFileName() {
        return this.fileName;
    }

    public char[] getMainTypeName() {
        return this.mainTypeName;
    }

    public char[][] getPackageName() {
        return null;
    }

    public boolean ignoreOptionalProblems() {
        return false;
    }

    public char[] getModuleName() {
        return this.module;
    }
}

