/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.core.BinaryMethod;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.ExternalJavadocSupport;
import org.eclipse.jdt.internal.core.IJavadocContents;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.util.Util;

public class JavadocContents
implements IJavadocContents {
    protected static final Range UNKNOWN_FORMAT = new Range(-1, -1);
    protected BinaryType type;
    protected final char[] content;
    protected int childrenStart;
    protected boolean hasComputedChildrenSections;
    protected int indexOfFieldDetails;
    protected int indexOfConstructorDetails;
    protected int indexOfMethodDetails;
    protected int indexOfEndOfClassData;
    protected int indexOfFieldsBottom;
    protected int indexOfAllMethodsTop;
    protected int indexOfAllMethodsBottom;
    protected Range typeDocRange;
    protected Map<IField, Range> fieldDocRanges;
    protected Map<BinaryMethod, Range> methodDocRanges;
    protected int[] fieldAnchorIndexes;
    protected int fieldAnchorIndexesCount;
    protected int fieldLastAnchorFoundIndex;
    protected int[] methodAnchorIndexes;
    protected int methodAnchorIndexesCount;
    protected int methodLastAnchorFoundIndex;
    protected int[] unknownFormatAnchorIndexes;
    protected int unknownFormatAnchorIndexesCount;
    protected int unknownFormatLastAnchorFoundIndex;
    protected int[] tempAnchorIndexes;
    protected int tempAnchorIndexesCount;
    protected int tempLastAnchorFoundIndex;

    JavadocContents(BinaryType type, String content) {
        this.content = content != null ? content.toCharArray() : null;
        this.type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTypeDoc() throws JavaModelException {
        if (this.content == null) {
            return null;
        }
        JavadocContents javadocContents = this;
        synchronized (javadocContents) {
            if (this.typeDocRange == null) {
                this.computeTypeRange();
            }
        }
        if (this.typeDocRange != null) {
            if (this.typeDocRange == UNKNOWN_FORMAT) {
                throw new JavaModelException(new JavaModelStatus(1009, this.type));
            }
            return new String(this.content, this.typeDocRange.start(), this.typeDocRange.length());
        }
        return null;
    }

    @Override
    public String getPackageDoc() throws JavaModelException {
        if (this.content == null) {
            return null;
        }
        int index = CharOperation.indexOf((char[])ExternalJavadocSupport.PACKAGE_DESCRIPTION_START2, (char[])this.content, (boolean)false, (int)0);
        if (index == -1) {
            index = CharOperation.indexOf((char[])ExternalJavadocSupport.PACKAGE_DESCRIPTION_START, (char[])this.content, (boolean)false, (int)0);
        }
        if (index != -1) {
            if ((index = CharOperation.indexOf((char[])ExternalJavadocSupport.ANCHOR_SUFFIX, (char[])this.content, (boolean)false, (int)index)) == -1) {
                return null;
            }
            int start = CharOperation.indexOf((char[])ExternalJavadocSupport.H2_PREFIX, (char[])this.content, (boolean)false, (int)index);
            if (start != -1 && (start = CharOperation.indexOf((char[])ExternalJavadocSupport.H2_SUFFIX, (char[])this.content, (boolean)false, (int)start)) != -1) {
                index = start + ExternalJavadocSupport.H2_SUFFIX_LENGTH;
            }
        } else {
            index = CharOperation.indexOf((char[])ExternalJavadocSupport.PACKAGE_DESCRIPTION_START3, (char[])this.content, (boolean)false, (int)0);
        }
        if (index != -1) {
            int end = CharOperation.indexOf((char[])ExternalJavadocSupport.BOTTOM_NAVBAR, (char[])this.content, (boolean)false, (int)index);
            if (end == -1) {
                end = this.content.length - 1;
            }
            return new String(this.content, index, end - index);
        }
        return null;
    }

    @Override
    public String getModuleDoc() throws JavaModelException {
        if (this.content == null) {
            return null;
        }
        int index = CharOperation.indexOf((char[])ExternalJavadocSupport.MODULE_DESCRIPTION_START, (char[])this.content, (boolean)false, (int)0);
        if (index == -1) {
            return null;
        }
        int end = CharOperation.indexOf((char[])ExternalJavadocSupport.BOTTOM_NAVBAR, (char[])this.content, (boolean)false, (int)index);
        if (end == -1) {
            end = this.content.length - 1;
        }
        return new String(this.content, index, end - index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getFieldDoc(IField child) throws JavaModelException {
        if (this.content == null) {
            return null;
        }
        Range range = null;
        JavadocContents javadocContents = this;
        synchronized (javadocContents) {
            if (this.fieldDocRanges == null) {
                this.fieldDocRanges = new HashMap<IField, Range>();
            } else {
                range = this.fieldDocRanges.get(child);
            }
            if (range == null) {
                range = this.computeFieldRange(child);
                this.fieldDocRanges.put(child, range);
            }
        }
        if (range != null) {
            if (range == UNKNOWN_FORMAT) {
                throw new JavaModelException(new JavaModelStatus(1009, child));
            }
            return new String(this.content, range.start(), range.length());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public String getMethodDoc(IMethod child) throws JavaModelException {
        if (this.content == null || !(child instanceof BinaryMethod)) {
            return null;
        }
        BinaryMethod binaryMethod = (BinaryMethod)child;
        Range range = null;
        JavadocContents javadocContents = this;
        synchronized (javadocContents) {
            void binaryMethod2;
            if (this.methodDocRanges == null) {
                this.methodDocRanges = new HashMap<BinaryMethod, Range>();
            } else {
                range = this.methodDocRanges.get(binaryMethod2);
            }
            if (range == null) {
                range = this.computeMethodRange((BinaryMethod)binaryMethod2);
                this.methodDocRanges.put((BinaryMethod)binaryMethod2, range);
            }
        }
        if (range != null) {
            if (range == UNKNOWN_FORMAT) {
                throw new JavaModelException(new JavaModelStatus(1009, child));
            }
            return new String(this.content, range.start(), range.length());
        }
        return null;
    }

    protected Range computeChildRange(char[] anchor, int indexOfSectionBottom) throws JavaModelException {
        if (this.tempAnchorIndexesCount > 0) {
            int i = 0;
            while (i < this.tempAnchorIndexesCount) {
                int anchorEndStart = this.tempAnchorIndexes[i];
                if (anchorEndStart != -1 && CharOperation.prefixEquals((char[])anchor, (char[])this.content, (boolean)false, (int)anchorEndStart)) {
                    this.tempAnchorIndexes[i] = -1;
                    return this.computeChildRange(anchorEndStart, anchor, indexOfSectionBottom);
                }
                ++i;
            }
        }
        int fromIndex = this.tempLastAnchorFoundIndex;
        int[] index = this.getAnchorIndex(fromIndex);
        while (index[0] != -1 && (index[0] < indexOfSectionBottom || indexOfSectionBottom == -1)) {
            int anchorEndStart;
            fromIndex = index[0] + 1;
            this.tempLastAnchorFoundIndex = anchorEndStart = index[0] + index[1];
            if (CharOperation.prefixEquals((char[])anchor, (char[])this.content, (boolean)false, (int)anchorEndStart)) {
                return this.computeChildRange(anchorEndStart, anchor, indexOfSectionBottom);
            }
            if (this.tempAnchorIndexes.length == this.tempAnchorIndexesCount) {
                this.tempAnchorIndexes = new int[this.tempAnchorIndexesCount + 20];
                System.arraycopy(this.tempAnchorIndexes, 0, this.tempAnchorIndexes, 0, this.tempAnchorIndexesCount);
            }
            this.tempAnchorIndexes[this.tempAnchorIndexesCount++] = anchorEndStart;
            index = this.getAnchorIndex(fromIndex);
        }
        return null;
    }

    protected int[] getAnchorIndex(int fromIndex) {
        int index = CharOperation.indexOf((char[])ExternalJavadocSupport.ANCHOR_PREFIX_START, (char[])this.content, (boolean)false, (int)fromIndex);
        if (index != -1) {
            return new int[]{index, ExternalJavadocSupport.ANCHOR_PREFIX_START_LENGTH};
        }
        if (index == -1) {
            index = CharOperation.indexOf((char[])ExternalJavadocSupport.ANCHOR_PREFIX_START_2, (char[])this.content, (boolean)false, (int)fromIndex);
        }
        if (index == -1) {
            return new int[]{-1, -1};
        }
        return new int[]{index, ExternalJavadocSupport.ANCHOR_PREFIX_START2_LENGTH};
    }

    protected Range computeChildRange(int anchorEndStart, char[] anchor, int indexOfBottom) {
        Range range = null;
        if (indexOfBottom != -1) {
            int indexOfEndLink = CharOperation.indexOf((char[])ExternalJavadocSupport.ANCHOR_SUFFIX, (char[])this.content, (boolean)false, (int)(anchorEndStart + anchor.length));
            if (indexOfEndLink != -1) {
                int indexOfNextElement = this.getAnchorIndex(indexOfEndLink)[0];
                int javadocStart = indexOfEndLink + ExternalJavadocSupport.ANCHOR_SUFFIX_LENGTH;
                int javadocEnd = indexOfNextElement == -1 ? indexOfBottom : Math.min(indexOfNextElement, indexOfBottom);
                range = new Range(javadocStart, javadocEnd);
            } else {
                range = UNKNOWN_FORMAT;
            }
        } else {
            range = UNKNOWN_FORMAT;
        }
        return range;
    }

    protected void computeChildrenSections() {
        int lastIndex = CharOperation.indexOf((char[])ExternalJavadocSupport.SEPARATOR_START, (char[])this.content, (boolean)false, (int)this.childrenStart);
        lastIndex = lastIndex == -1 ? this.childrenStart : lastIndex;
        this.indexOfFieldDetails = CharOperation.indexOf((char[])ExternalJavadocSupport.FIELD_DETAIL, (char[])this.content, (boolean)false, (int)lastIndex);
        lastIndex = this.indexOfFieldDetails == -1 ? lastIndex : this.indexOfFieldDetails;
        this.indexOfConstructorDetails = CharOperation.indexOf((char[])ExternalJavadocSupport.CONSTRUCTOR_DETAIL, (char[])this.content, (boolean)false, (int)lastIndex);
        lastIndex = this.indexOfConstructorDetails == -1 ? lastIndex : this.indexOfConstructorDetails;
        this.indexOfMethodDetails = CharOperation.indexOf((char[])ExternalJavadocSupport.METHOD_DETAIL, (char[])this.content, (boolean)false, (int)lastIndex);
        lastIndex = this.indexOfMethodDetails == -1 ? lastIndex : this.indexOfMethodDetails;
        this.indexOfEndOfClassData = CharOperation.indexOf((char[])ExternalJavadocSupport.END_OF_CLASS_DATA, (char[])this.content, (boolean)false, (int)lastIndex);
        this.indexOfFieldsBottom = this.indexOfConstructorDetails != -1 ? this.indexOfConstructorDetails : (this.indexOfMethodDetails != -1 ? this.indexOfMethodDetails : this.indexOfEndOfClassData);
        this.indexOfAllMethodsTop = this.indexOfConstructorDetails != -1 ? this.indexOfConstructorDetails : this.indexOfMethodDetails;
        this.indexOfAllMethodsBottom = this.indexOfEndOfClassData;
        this.hasComputedChildrenSections = true;
    }

    protected Range computeFieldRange(IField field) throws JavaModelException {
        if (!this.hasComputedChildrenSections) {
            this.computeChildrenSections();
        }
        StringBuilder buffer = new StringBuilder(field.getElementName());
        buffer.append("\"");
        char[] anchor = String.valueOf(buffer).toCharArray();
        Range range = null;
        if (this.indexOfFieldDetails == -1 || this.indexOfFieldsBottom == -1) {
            if (this.unknownFormatAnchorIndexes == null) {
                this.unknownFormatAnchorIndexes = new int[this.type.getChildren().length];
                this.unknownFormatAnchorIndexesCount = 0;
                this.unknownFormatLastAnchorFoundIndex = this.childrenStart;
            }
            this.tempAnchorIndexes = this.unknownFormatAnchorIndexes;
            this.tempAnchorIndexesCount = this.unknownFormatAnchorIndexesCount;
            this.tempLastAnchorFoundIndex = this.unknownFormatLastAnchorFoundIndex;
            range = this.computeChildRange(anchor, this.indexOfFieldsBottom);
            this.unknownFormatLastAnchorFoundIndex = this.tempLastAnchorFoundIndex;
            this.unknownFormatAnchorIndexesCount = this.tempAnchorIndexesCount;
            this.unknownFormatAnchorIndexes = this.tempAnchorIndexes;
        } else {
            if (this.fieldAnchorIndexes == null) {
                this.fieldAnchorIndexes = new int[this.type.getFields().length];
                this.fieldAnchorIndexesCount = 0;
                this.fieldLastAnchorFoundIndex = this.indexOfFieldDetails;
            }
            this.tempAnchorIndexes = this.fieldAnchorIndexes;
            this.tempAnchorIndexesCount = this.fieldAnchorIndexesCount;
            this.tempLastAnchorFoundIndex = this.fieldLastAnchorFoundIndex;
            range = this.computeChildRange(anchor, this.indexOfFieldsBottom);
            this.fieldLastAnchorFoundIndex = this.tempLastAnchorFoundIndex;
            this.fieldAnchorIndexesCount = this.tempAnchorIndexesCount;
            this.fieldAnchorIndexes = this.tempAnchorIndexes;
        }
        return range;
    }

    protected Range computeMethodRange(BinaryMethod method) throws JavaModelException {
        if (!this.hasComputedChildrenSections) {
            this.computeChildrenSections();
        }
        char[] anchor = this.computeMethodAnchorPrefixEnd(method).toCharArray();
        Range range = null;
        if (this.indexOfAllMethodsTop == -1 || this.indexOfAllMethodsBottom == -1) {
            if (this.unknownFormatAnchorIndexes == null) {
                this.unknownFormatAnchorIndexes = new int[this.type.getChildren().length];
                this.unknownFormatAnchorIndexesCount = 0;
                this.unknownFormatLastAnchorFoundIndex = this.childrenStart;
            }
            this.tempAnchorIndexes = this.unknownFormatAnchorIndexes;
            this.tempAnchorIndexesCount = this.unknownFormatAnchorIndexesCount;
            this.tempLastAnchorFoundIndex = this.unknownFormatLastAnchorFoundIndex;
            range = this.computeChildRange(anchor, this.indexOfFieldsBottom);
            if (range == null) {
                range = this.computeChildRange(JavadocContents.getJavadoc8Anchor(anchor), this.indexOfAllMethodsBottom);
            }
            this.unknownFormatLastAnchorFoundIndex = this.tempLastAnchorFoundIndex;
            this.unknownFormatAnchorIndexesCount = this.tempAnchorIndexesCount;
            this.unknownFormatAnchorIndexes = this.tempAnchorIndexes;
        } else {
            if (this.methodAnchorIndexes == null) {
                this.methodAnchorIndexes = new int[this.type.getFields().length];
                this.methodAnchorIndexesCount = 0;
                this.methodLastAnchorFoundIndex = this.indexOfAllMethodsTop;
            }
            this.tempAnchorIndexes = this.methodAnchorIndexes;
            this.tempAnchorIndexesCount = this.methodAnchorIndexesCount;
            this.tempLastAnchorFoundIndex = this.methodLastAnchorFoundIndex;
            range = this.computeChildRange(anchor, this.indexOfAllMethodsBottom);
            if (range == null) {
                range = this.computeChildRange(JavadocContents.getJavadoc8Anchor(anchor), this.indexOfAllMethodsBottom);
            }
            this.methodLastAnchorFoundIndex = this.tempLastAnchorFoundIndex;
            this.methodAnchorIndexesCount = this.tempAnchorIndexesCount;
            this.methodAnchorIndexes = this.tempAnchorIndexes;
        }
        return range;
    }

    private static char[] getJavadoc8Anchor(char[] anchor) {
        char[] anchor8 = new char[anchor.length];
        int i8 = 0;
        char[] cArray = anchor;
        int n = anchor.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            switch (ch) {
                case '(': 
                case ')': 
                case ',': {
                    anchor8[i8++] = 45;
                    break;
                }
                case '[': {
                    anchor8[i8++] = 58;
                    anchor8[i8++] = 65;
                    break;
                }
                case ' ': 
                case ']': {
                    break;
                }
                default: {
                    anchor8[i8++] = ch;
                }
            }
            ++n2;
        }
        if (i8 != anchor.length) {
            anchor8 = CharOperation.subarray((char[])anchor8, (int)0, (int)i8);
        }
        return anchor8;
    }

    protected String computeMethodAnchorPrefixEnd(BinaryMethod method) throws JavaModelException {
        String methodName = this.getMethodName(method);
        IBinaryMethod info = (IBinaryMethod)method.getElementInfo();
        Object anchor = this.createSignatureAnchor(method, methodName, info);
        BinaryType declaringType = this.type;
        if (declaringType.isMember() && method.isConstructor() && !Flags.isStatic(declaringType.getFlags())) {
            int index;
            int indexOfComma;
            int indexOfOpeningParen = ((String)anchor).indexOf(40);
            if (indexOfOpeningParen == -1) {
                return null;
            }
            index = (indexOfComma = ((String)anchor).indexOf(44, index = indexOfOpeningParen++)) != -1 ? indexOfComma + 2 : ((String)anchor).indexOf(41, index);
            anchor = ((String)anchor).substring(0, indexOfOpeningParen) + ((String)anchor).substring(index);
        }
        return (String)anchor + "\"";
    }

    protected String createSignatureAnchor(BinaryMethod method, String methodName, IBinaryMethod info) throws JavaModelException {
        char[] genericSignature = info.getGenericSignature();
        String anchor = null;
        if (genericSignature != null) {
            anchor = Util.toAnchor(0, genericSignature = CharOperation.replaceOnCopy((char[])genericSignature, (char)'/', (char)'.'), methodName, Flags.isVarargs(method.getFlags()));
            if (anchor == null) {
                throw new JavaModelException(new JavaModelStatus(1009, method));
            }
        } else {
            anchor = Signature.toString(method.getSignature().replace('/', '.'), methodName, null, true, false, Flags.isVarargs(method.getFlags()));
        }
        return anchor;
    }

    protected String getMethodName(BinaryMethod method) throws JavaModelException {
        String typeQualifiedName = null;
        if (this.type.isMember()) {
            IType currentType = this.type;
            StringBuilder buffer = new StringBuilder();
            while (currentType != null) {
                buffer.insert(0, currentType.getElementName());
                currentType = currentType.getDeclaringType();
                if (currentType == null) continue;
                buffer.insert(0, '.');
            }
            typeQualifiedName = buffer.toString();
        } else {
            typeQualifiedName = this.type.getElementName();
        }
        String methodName = method.getElementName();
        if (method.isConstructor()) {
            methodName = typeQualifiedName;
        }
        return methodName;
    }

    protected void computeTypeRange() throws JavaModelException {
        int indexOfStartOfClassData = CharOperation.indexOf((char[])ExternalJavadocSupport.START_OF_CLASS_DATA, (char[])this.content, (boolean)false);
        if (indexOfStartOfClassData == -1) {
            this.typeDocRange = UNKNOWN_FORMAT;
            return;
        }
        int indexOfNextSeparator = CharOperation.indexOf((char[])ExternalJavadocSupport.SEPARATOR_START, (char[])this.content, (boolean)false, (int)indexOfStartOfClassData);
        if (indexOfNextSeparator == -1) {
            this.typeDocRange = UNKNOWN_FORMAT;
            return;
        }
        int indexOfNextSummary = CharOperation.indexOf((char[])ExternalJavadocSupport.NESTED_CLASS_SUMMARY, (char[])this.content, (boolean)false, (int)indexOfNextSeparator);
        if (indexOfNextSummary == -1 && this.type.isEnum()) {
            indexOfNextSummary = CharOperation.indexOf((char[])ExternalJavadocSupport.ENUM_CONSTANT_SUMMARY, (char[])this.content, (boolean)false, (int)indexOfNextSeparator);
        }
        if (indexOfNextSummary == -1 && this.type.isAnnotation() && (indexOfNextSummary = CharOperation.indexOf((char[])ExternalJavadocSupport.ANNOTATION_TYPE_REQUIRED_MEMBER_SUMMARY, (char[])this.content, (boolean)false, (int)indexOfNextSeparator)) == -1) {
            indexOfNextSummary = CharOperation.indexOf((char[])ExternalJavadocSupport.ANNOTATION_TYPE_OPTIONAL_MEMBER_SUMMARY, (char[])this.content, (boolean)false, (int)indexOfNextSeparator);
        }
        if (indexOfNextSummary == -1) {
            indexOfNextSummary = CharOperation.indexOf((char[])ExternalJavadocSupport.FIELD_SUMMARY, (char[])this.content, (boolean)false, (int)indexOfNextSeparator);
        }
        if (indexOfNextSummary == -1) {
            indexOfNextSummary = CharOperation.indexOf((char[])ExternalJavadocSupport.CONSTRUCTOR_SUMMARY, (char[])this.content, (boolean)false, (int)indexOfNextSeparator);
        }
        if (indexOfNextSummary == -1) {
            indexOfNextSummary = CharOperation.indexOf((char[])ExternalJavadocSupport.METHOD_SUMMARY, (char[])this.content, (boolean)false, (int)indexOfNextSeparator);
        }
        if (indexOfNextSummary == -1) {
            indexOfNextSummary = CharOperation.indexOf((char[])ExternalJavadocSupport.END_OF_CLASS_DATA, (char[])this.content, (boolean)false, (int)indexOfNextSeparator);
        } else {
            this.childrenStart = indexOfNextSummary + 1;
        }
        if (indexOfNextSummary == -1) {
            this.typeDocRange = UNKNOWN_FORMAT;
            return;
        }
        int start = indexOfStartOfClassData + ExternalJavadocSupport.START_OF_CLASS_DATA_LENGTH;
        int indexOfFirstParagraph = CharOperation.indexOf((char[])"<P>".toCharArray(), (char[])this.content, (boolean)false, (int)start, (int)indexOfNextSummary);
        int indexOfFirstDiv = CharOperation.indexOf((char[])"<DIV CLASS=\"BLOCK\">".toCharArray(), (char[])this.content, (boolean)false, (int)start, (int)indexOfNextSummary);
        int afterHierarchy = indexOfNextSummary;
        if (indexOfFirstParagraph != -1 && indexOfFirstParagraph < afterHierarchy) {
            afterHierarchy = indexOfFirstParagraph;
        }
        if (indexOfFirstDiv != -1 && indexOfFirstDiv < afterHierarchy) {
            afterHierarchy = indexOfFirstDiv;
        }
        if (afterHierarchy != indexOfNextSummary) {
            start = afterHierarchy;
        }
        this.typeDocRange = new Range(start, indexOfNextSummary);
    }

    public static final class Range
    extends Record {
        private final int start;
        private final int end;

        public Range(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int length() {
            return this.end() - this.start();
        }

        public int start() {
            return this.start;
        }

        public int end() {
            return this.end;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Range.class, "start;end", "start", "end"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Range.class, "start;end", "start", "end"}, this);
        }

        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Range.class, "start;end", "start", "end"}, this, object);
        }
    }
}

