/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.bytecode;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileStruct;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.CallinMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.MethodSpec;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.AbstractAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.ListValueAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.CallinCalloutBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.ModelElement;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;

public class OTDynCallinBindingsAttribute
extends ListValueAttribute {
    public static final char[] ATTRIBUTE_NAME = "OTDynCallinBindings".toCharArray();
    public static final short STATIC_ROLE_METHOD = 1;
    public static final short INHERITED = 4;
    public static final short COVARIANT_BASE_RETURN = 8;
    public static final short BASE_SUPER_CALL = 16;
    private List<Mapping> mappings;
    private TeamModel theTeam;

    OTDynCallinBindingsAttribute(TeamModel theTeam) {
        super(ATTRIBUTE_NAME, -1, -1);
        this.theTeam = theTeam;
        this.theTeam.addAttribute(this);
        this.mappings = new ArrayList<Mapping>();
    }

    private OTDynCallinBindingsAttribute(TeamModel theTeam, List<Mapping> mappings) {
        super(ATTRIBUTE_NAME, mappings.size(), -1);
        this.theTeam = theTeam;
        this.mappings = mappings;
    }

    public OTDynCallinBindingsAttribute(ClassFileStruct reader, int readOffset, int[] constantPoolOffsets) {
        super(ATTRIBUTE_NAME, -1, -1);
        this._reader = reader;
        this._readOffset = readOffset;
        this._constantPoolOffsets = constantPoolOffsets;
        this._count = this.consumeShort();
        this.mappings = new ArrayList<Mapping>();
        int i = 0;
        while (i < this._count) {
            this.mappings.add(this.readMapping());
            ++i;
        }
    }

    @Override
    protected int getAttributeSize() {
        int s = 2;
        for (Mapping mapping : this.mappings) {
            s += mapping.getAttributeSize();
        }
        return s;
    }

    void addMappings(char[] baseClassName, CallinMappingDeclaration callinDecl) {
        MethodSpec roleSpec = callinDecl.roleMethodSpec;
        int flags = 0;
        if (callinDecl.roleMethodSpec.resolvedMethod.isStatic()) {
            flags |= 1;
        }
        if (callinDecl.hasCovariantReturn()) {
            flags |= 8;
        }
        MethodSpec[] baseMethodSpecs = callinDecl.getBaseMethodSpecs();
        Mapping mapping = new Mapping(callinDecl.scope.enclosingSourceType().sourceName(), callinDecl.declaringRoleName(), callinDecl.name, roleSpec.selector, roleSpec.signature(CompilerOptions.WeavingScheme.OTDRE), callinDecl.getCallinModifier(), flags, baseClassName, baseMethodSpecs.length, roleSpec.resolvedMethod);
        int i = 0;
        while (i < baseMethodSpecs.length) {
            MethodSpec baseSpec = baseMethodSpecs[i];
            int baseFlags = 0;
            if (baseSpec.isCallin()) {
                baseFlags |= 1;
            }
            if (baseSpec.isStatic()) {
                baseFlags |= 2;
            }
            if (baseSpec.isFinal()) {
                baseFlags |= 4;
            }
            if (baseSpec.isPrivate()) {
                baseFlags |= 8;
            }
            if (baseSpec.isPublic()) {
                baseFlags |= 0x10;
            }
            mapping.addBaseMethod(i, baseSpec.codegenSeletor(), baseSpec.signature(CompilerOptions.WeavingScheme.OTDRE), baseSpec.resolvedMethod.declaringClass.constantPoolName(), baseSpec.getCallinId(this.theTeam, callinDecl.explicitName()), baseFlags, baseSpec.getTranslationFlags());
            ++i;
        }
        mapping.setSMAPinfo(callinDecl);
        this.mappings.add(mapping);
        this._count = this.mappings.size();
    }

    public static void createOrMerge(TeamModel theTeam, char[] baseClassName, CallinMappingDeclaration[] mappingDecls) {
        AbstractAttribute existingAttr = theTeam.getAttribute(ATTRIBUTE_NAME);
        OTDynCallinBindingsAttribute theAttr = existingAttr != null ? (OTDynCallinBindingsAttribute)existingAttr : new OTDynCallinBindingsAttribute(theTeam);
        CallinMappingDeclaration[] callinMappingDeclarationArray = mappingDecls;
        int n = mappingDecls.length;
        int n2 = 0;
        while (n2 < n) {
            CallinMappingDeclaration callinDecl = callinMappingDeclarationArray[n2];
            theAttr.addMappings(baseClassName, callinDecl);
            ++n2;
        }
    }

    @Override
    String toString(int i) {
        Mapping mapping = this.mappings.get(i);
        StringBuffer buf = new StringBuffer();
        buf.append('\t');
        buf.append(String.valueOf(mapping.declaringRoleName));
        buf.append('.');
        buf.append(String.valueOf(mapping.callinName));
        buf.append(": ");
        buf.append(String.valueOf(mapping.roleSelector));
        buf.append(String.valueOf(mapping.roleSignature));
        buf.append(" <- ");
        buf.append(String.valueOf(mapping.callinModifier));
        buf.append(' ');
        buf.append(String.valueOf(mapping.baseClassName));
        BaseMethod[] baseMethods = mapping.getBaseMethods();
        int j = 0;
        while (j < baseMethods.length) {
            buf.append("\n\t\t");
            buf.append(String.valueOf(baseMethods[j].declaringBaseClassName));
            buf.append('.');
            buf.append(String.valueOf(baseMethods[j].baseMethodName));
            buf.append(String.valueOf(baseMethods[j].baseMethodSignature));
            buf.append('{');
            buf.append(baseMethods[j].callinID);
            buf.append('}');
            ++j;
        }
        buf.append('\n');
        return buf.toString();
    }

    @Override
    void writeElementValue(int i) {
        Mapping mapping = this.mappings.get(i);
        this.writeName(mapping.roleClassName);
        this.writeName(CharOperation.concat(mapping.declaringRoleName, mapping.callinName, '.'));
        this.writeName(mapping.roleSelector);
        this.writeName(mapping.roleSignature);
        this.writeName(mapping.callinModifier);
        int flags = mapping.flags;
        if (mapping.roleMethod != null && MethodModel.hasCallinFlag(mapping.roleMethod, 32)) {
            flags |= 0x10;
        }
        this.writeByte((byte)flags);
        this.writeName(mapping.baseClassName);
        this.writeName(mapping.fileName);
        this.writeUnsignedShort(mapping.lineNumber);
        this.writeUnsignedShort(mapping.lineOffset);
        BaseMethod[] baseMethods = mapping.getBaseMethods();
        this.writeUnsignedShort(baseMethods.length);
        int j = 0;
        while (j < baseMethods.length) {
            this.writeName(baseMethods[j].baseMethodName);
            this.writeName(baseMethods[j].baseMethodSignature);
            this.writeName(baseMethods[j].declaringBaseClassName);
            this.writeInt(baseMethods[j].callinID);
            this.writeByte((byte)baseMethods[j].baseFlags);
            this.writeUnsignedShort(baseMethods[j].translationFlags);
            ++j;
        }
    }

    Mapping readMapping() {
        char[] roleClassName = this.consumeName();
        char[] callinName = this.consumeName();
        char[] roleSelector = this.consumeName();
        char[] roleSignature = this.consumeName();
        char[] callinModifer = this.consumeName();
        int flags = this.consumeByte();
        char[] baseClassName = this.consumeName();
        char[] fileName = this.consumeName();
        int lineNumber = this.consumeShort();
        int lineOffset = this.consumeShort();
        int baseMethodCount = this.consumeShort();
        int pos = CharOperation.lastIndexOf('.', callinName);
        char[] declaringRoleName = CharOperation.subarray(callinName, 0, pos);
        callinName = CharOperation.subarray(callinName, pos + 1, -1);
        Mapping result = new Mapping(roleClassName, declaringRoleName, callinName, roleSelector, roleSignature, callinModifer, flags, baseClassName, baseMethodCount, null);
        result.setSMAPInfo(fileName, lineNumber, lineOffset);
        int i = 0;
        while (i < baseMethodCount) {
            char[] baseMethodName = this.consumeName();
            char[] baseMethodSignature = this.consumeName();
            char[] declaringBaseClass = this.consumeName();
            int callinID = this.consumeInt();
            int baseFlags = this.consumeByte();
            int translationFlags = this.consumeShort();
            result.addBaseMethod(i, baseMethodName, baseMethodSignature, declaringBaseClass, callinID, baseFlags, translationFlags);
            ++i;
        }
        return result;
    }

    @Override
    public void evaluate(Binding binding, LookupEnvironment environment, char[][][] missingTypeNames) {
        this.checkBindingMismatch(binding, Integer.MIN_VALUE);
        if (((ReferenceBinding)binding).isTeam()) {
            ((ReferenceBinding)binding).getTeamModel().addAttribute(this);
        }
    }

    @Override
    public void evaluateLateAttribute(ReferenceBinding teamBinding, int state) {
        if (state != 16) {
            return;
        }
        int i = 0;
        while (i < this.mappings.size()) {
            OTDynCallinBindingsAttribute.createBinding(teamBinding, this.mappings.get(i), true);
            ++i;
        }
    }

    public void createBindings(TeamModel teamModel, boolean recordLabels) {
        ReferenceBinding teamBinding = teamModel.getBinding();
        int i = 0;
        while (i < this.mappings.size()) {
            OTDynCallinBindingsAttribute.createBinding(teamBinding, this.mappings.get(i), recordLabels);
            ++i;
        }
    }

    private static void createBinding(ReferenceBinding teamBinding, Mapping mapping, boolean recordLabels) {
        int closePos;
        ReferenceBinding roleBinding = teamBinding.getMemberType(mapping.roleClassName).getRealClass();
        CallinCalloutBinding result = null;
        CallinCalloutBinding[] callinCallouts = roleBinding.callinCallouts;
        if (callinCallouts != null) {
            int i = 0;
            while (i < callinCallouts.length) {
                if (CharOperation.equals(mapping.callinName, callinCallouts[i].name)) {
                    result = callinCallouts[i];
                    result.callinModifier = OTDynCallinBindingsAttribute.encodeCallinModifier(mapping.callinModifier);
                    break;
                }
                ++i;
            }
        }
        if (result == null) {
            result = new CallinCalloutBinding(roleBinding, mapping.callinName, OTDynCallinBindingsAttribute.encodeCallinModifier(mapping.callinModifier));
        }
        BaseMethod[] mappingBaseMethods = mapping.baseMethods;
        MethodBinding[] baseMethods = new MethodBinding[mappingBaseMethods.length];
        ReferenceBinding currentType = roleBinding;
        char[] roleSignature = mapping.roleSignature;
        if (result.callinModifier == 146 && (closePos = CharOperation.indexOf(')', roleSignature)) > -1) {
            roleSignature = CharOperation.subarray(roleSignature, 0, closePos + 1);
        }
        block1: while (currentType != null) {
            MethodBinding[] methods = currentType.getMethods(mapping.roleSelector);
            int j = 0;
            while (j < methods.length) {
                if (CharOperation.prefixEquals(roleSignature, MethodSpec.signature(methods[j], CompilerOptions.WeavingScheme.OTDRE))) {
                    result._roleMethodBinding = methods[j];
                    break block1;
                }
                ++j;
            }
            currentType = currentType.superclass();
        }
        if (result._roleMethodBinding == null) {
            throw new InternalCompilerError("role method specified in callin mapping does not exist " + String.valueOf(mapping));
        }
        int callinIdMax = 0;
        int i = 0;
        while (i < mappingBaseMethods.length) {
            block14: {
                BaseMethod bm = mappingBaseMethods[i];
                callinIdMax = Math.max(callinIdMax, bm.callinID);
                currentType = roleBinding.baseclass();
                while (currentType != null) {
                    MethodBinding[] methods = currentType.getMethods(bm.baseMethodName);
                    int j = 0;
                    while (j < methods.length) {
                        if (CharOperation.equals(bm.baseMethodSignature, methods[j].signature())) {
                            baseMethods[i] = methods[j];
                            if (recordLabels && mapping.callinName != null && mapping.callinName[0] != '<') {
                                teamBinding._teamModel.recordLabelledCallin(new String(mapping.callinName), methods[j], bm.callinID, roleBinding);
                            }
                            break block14;
                        }
                        ++j;
                    }
                    currentType = currentType.superclass();
                }
                baseMethods[i] = new ProblemMethodBinding(bm.baseMethodName, null, roleBinding.baseclass(), 1);
            }
            ++i;
        }
        result._baseMethods = baseMethods;
        result.callinIdMax = callinIdMax;
        teamBinding._teamModel.recordCallinId(callinIdMax);
        result.copyInheritanceSrc = OTDynCallinBindingsAttribute.findTSuperBinding(mapping.callinName, roleBinding);
        roleBinding.addCallinCallouts(new CallinCalloutBinding[]{result});
    }

    private static CallinCalloutBinding findTSuperBinding(char[] name, ReferenceBinding roleType) {
        ReferenceBinding[] tsuperRoles = roleType.roleModel.getTSuperRoleBindings();
        int i = tsuperRoles.length - 1;
        while (i >= 0) {
            if (tsuperRoles[i].callinCallouts != null) {
                CallinCalloutBinding[] callinCalloutBindingArray = tsuperRoles[i].callinCallouts;
                int n = tsuperRoles[i].callinCallouts.length;
                int n2 = 0;
                while (n2 < n) {
                    CallinCalloutBinding mapping = callinCalloutBindingArray[n2];
                    if (CharOperation.equals(mapping.name, name)) {
                        return mapping.copyInheritanceSrc != null ? mapping.copyInheritanceSrc : mapping;
                    }
                    ++n2;
                }
            }
            --i;
        }
        return null;
    }

    private static int encodeCallinModifier(char[] modifierName) {
        if (CharOperation.equals(modifierName, IOTConstants.NAME_REPLACE)) {
            return 146;
        }
        if (CharOperation.equals(modifierName, IOTConstants.NAME_AFTER)) {
            return 141;
        }
        if (CharOperation.equals(modifierName, IOTConstants.NAME_BEFORE)) {
            return 147;
        }
        throw new InternalCompilerError("invalid callin modifier in byte code");
    }

    public int getCallinIdMax() {
        int max = -1;
        for (Mapping mapping : this.mappings) {
            BaseMethod[] baseMethodArray = mapping.baseMethods;
            int n = mapping.baseMethods.length;
            int n2 = 0;
            while (n2 < n) {
                BaseMethod baseMethod = baseMethodArray[n2];
                max = Math.max(max, baseMethod.callinID);
                ++n2;
            }
        }
        return max;
    }

    public OTDynCallinBindingsAttribute filteredCopy(ReferenceBinding teamBinding) {
        ArrayList<Mapping> filteredMappings = new ArrayList<Mapping>();
        block0: for (Mapping mapping : this.mappings) {
            if (mapping.callinName[0] != '<') {
                ReferenceBinding roleBinding = teamBinding.getMemberType(mapping.roleClassName).getRealClass();
                CallinCalloutBinding[] callinCalloutBindingArray = roleBinding.callinCallouts;
                int n = roleBinding.callinCallouts.length;
                int n2 = 0;
                while (n2 < n) {
                    CallinCalloutBinding callinCallout = callinCalloutBindingArray[n2];
                    if (CharOperation.equals(callinCallout.name, mapping.callinName)) continue block0;
                    ++n2;
                }
            }
            filteredMappings.add(mapping);
        }
        if (filteredMappings.size() == 0) {
            return null;
        }
        return new OTDynCallinBindingsAttribute(teamBinding._teamModel, filteredMappings);
    }

    @Override
    public void merge(ModelElement model, AbstractAttribute other) {
        List<Mapping> newMappings = ((OTDynCallinBindingsAttribute)other).mappings;
        for (Mapping mapping : newMappings) {
            if (this.hasMapping(mapping)) continue;
            this.mappings.add(mapping);
            ++this._count;
        }
    }

    private boolean hasMapping(Mapping mapping) {
        for (Mapping current : this.mappings) {
            if (!current.callinName.equals(mapping.callinName)) continue;
            return true;
        }
        return false;
    }

    private class BaseMethod {
        static final int CALLIN = 1;
        static final int STATIC = 2;
        static final int FINAL = 4;
        static final int PRIVATE = 8;
        static final int PUBLIC = 16;
        char[] baseMethodName;
        char[] baseMethodSignature;
        char[] declaringBaseClassName;
        int callinID;
        int baseFlags;
        int translationFlags;

        BaseMethod(char[] baseMethodName, char[] baseMethodSignature, char[] declaringBaseClassName, int callinID, int baseFlags, int translationFlags) {
            this.baseMethodName = baseMethodName;
            this.baseMethodSignature = baseMethodSignature;
            this.declaringBaseClassName = declaringBaseClassName;
            this.callinID = callinID;
            this.baseFlags = baseFlags;
            this.translationFlags = translationFlags;
        }
    }

    private class Mapping {
        char[] roleClassName;
        char[] declaringRoleName;
        char[] callinName;
        char[] roleSelector;
        char[] roleSignature;
        char[] callinModifier;
        char[] baseClassName;
        char[] fileName;
        int flags;
        int lineNumber;
        int lineOffset;
        BaseMethod[] baseMethods;
        MethodBinding roleMethod;

        Mapping(char[] roleClassName, char[] declaringRoleName, char[] callinName, char[] roleSelector, char[] roleSignature, char[] callinModifer, int flags, char[] baseClassName, int baseMethodCount, MethodBinding roleMethod) {
            this.roleClassName = roleClassName;
            this.declaringRoleName = declaringRoleName;
            this.callinName = callinName;
            this.roleSelector = roleSelector;
            this.roleSignature = roleSignature;
            this.callinModifier = callinModifer;
            this.flags = flags;
            this.baseClassName = baseClassName;
            this.baseMethods = new BaseMethod[baseMethodCount];
            this.roleMethod = roleMethod;
        }

        void addBaseMethod(int i, char[] baseMethodName, char[] baseMethodSignature, char[] declaringBaseClassName, int callinID, int baseFlags, int translationFlags) {
            this.baseMethods[i] = new BaseMethod(baseMethodName, baseMethodSignature, declaringBaseClassName, callinID, baseFlags, translationFlags);
        }

        public BaseMethod[] getBaseMethods() {
            return this.baseMethods;
        }

        public int getAttributeSize() {
            int s = 21;
            int i = 0;
            while (i < this.baseMethods.length) {
                s += 13;
                ++i;
            }
            return s;
        }

        void setSMAPinfo(CallinMappingDeclaration decl) {
            this.fileName = this.getFileName(decl);
            int[] lineEnds = decl.scope.referenceCompilationUnit().compilationResult().getLineSeparatorPositions();
            this.lineNumber = (short)Util.getLineNumber(decl.sourceStart, lineEnds, 0, lineEnds.length - 1);
            short lineEnd = (short)Util.getLineNumber(decl.declarationSourceEnd, lineEnds, 0, lineEnds.length - 1);
            this.lineOffset = (short)(lineEnd - this.lineNumber);
        }

        private char[] getFileName(CallinMappingDeclaration decl) {
            CompilationUnitDeclaration compilationUnit = decl.scope.referenceCompilationUnit();
            char[] fullName = compilationUnit.getFileName();
            char[][] packageName = null;
            if (compilationUnit.currentPackage == null || compilationUnit.currentPackage.tokens.length == 0) {
                int pos = CharOperation.lastIndexOf('/', fullName);
                if (pos == -1) {
                    return fullName;
                }
                return CharOperation.subarray(fullName, pos + 1, -1);
            }
            packageName = compilationUnit.currentPackage.tokens;
            char[][] components = CharOperation.splitOn('/', fullName);
            int pos = CharOperation.lastIndexOf('/', fullName);
            if (pos == -1) {
                return CharOperation.concatWith(packageName, fullName, '/');
            }
            if (components.length <= packageName.length) {
                throw new InternalCompilerError("too few path elements");
            }
            int start = components.length - (packageName.length + 1);
            int end = components.length;
            if (!CharOperation.equals(packageName, CharOperation.subarray(components, start, end - 1))) {
                decl.scope.problemReporter().packageIsNotExpectedPackage(compilationUnit);
            }
            return CharOperation.concatWith(CharOperation.subarray(components, start, end), '/');
        }

        public void setSMAPInfo(char[] fileName, int lineNumber, int lineOffset) {
            this.fileName = fileName;
            this.lineNumber = lineNumber;
            this.lineOffset = lineOffset;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder("Callin binding for ");
            buf.append(this.declaringRoleName);
            buf.append('.').append(this.roleSelector).append(this.roleSignature);
            return buf.toString();
        }
    }
}

