/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist.impl;

import java.util.Map;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.codeassist.impl.AssistOptions;
import org.eclipse.jdt.internal.codeassist.impl.AssistParser;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.ImportConflictBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.SourceTypeConverter;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.AbstractMethodMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.CallinMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.CalloutMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.ParameterMapping;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Config;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Dependencies;

public abstract class Engine
implements ITypeRequestor {
    public LookupEnvironment lookupEnvironment;
    protected CompilationUnitScope unitScope;
    public SearchableEnvironment nameEnvironment;
    public AssistOptions options;
    public CompilerOptions compilerOptions;
    public boolean forbiddenReferenceIsError;
    public boolean discouragedReferenceIsError;
    public boolean importCachesInitialized = false;
    public char[][][] importsCache;
    public ImportBinding[] onDemandImportsCache;
    public int importCacheCount = 0;
    public int onDemandImportCacheCount = 0;
    public char[] currentPackageName = null;

    public Engine(Map<String, String> settings) {
        this.options = new AssistOptions(settings);
        this.compilerOptions = new CompilerOptions(settings);
        this.forbiddenReferenceIsError = (this.compilerOptions.getSeverity(0x20000020) & 1) != 0;
        this.discouragedReferenceIsError = (this.compilerOptions.getSeverity(0x20004000) & 1) != 0;
    }

    public void accept(IBinaryType binaryType, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        this.lookupEnvironment.createBinaryTypeFrom(binaryType, packageBinding, accessRestriction);
    }

    public void accept(ICompilationUnit sourceUnit, AccessRestriction accessRestriction) {
        CompilationResult result = new CompilationResult(sourceUnit, 1, 1, this.compilerOptions.maxProblemsPerUnit);
        AssistParser assistParser = this.getParser();
        Object parserState = assistParser.becomeSimpleParser();
        CompilationUnitDeclaration parsedUnit = assistParser.dietParse(sourceUnit, result);
        assistParser.restoreAssistParser(parserState);
        this.lookupEnvironment.buildTypeBindings(parsedUnit, accessRestriction);
        this.lookupEnvironment.completeTypeBindings(parsedUnit, true);
    }

    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        LookupEnvironment environment = packageBinding.environment;
        if (environment == null) {
            environment = this.lookupEnvironment;
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (Config config = Dependencies.setup((Object)this, (Parser)this.getParser(), (LookupEnvironment)environment, (boolean)true, (boolean)false);){
            CompilationUnitDeclaration unit;
            CompilationResult result = null;
            if (sourceTypes[0].getEnclosingType() != null) {
                try {
                    SourceTypeElementInfo sourceType = sourceTypes[0] instanceof SourceType ? (SourceTypeElementInfo)((SourceType)sourceTypes[0]).getElementInfo() : (SourceTypeElementInfo)sourceTypes[0];
                    IType[] types = sourceType.getHandle().getCompilationUnit().getTypes();
                    sourceTypes = new ISourceType[types.length];
                    sourceTypes[0] = sourceType;
                    int length = types.length;
                    int i = 0;
                    while (i < length) {
                        ISourceType otherType;
                        sourceTypes[i] = otherType = (ISourceType)((JavaElement)((Object)types[i])).getElementInfo();
                        ++i;
                    }
                    ISourceType otherType = (ISourceType)((JavaElement)((Object)types[0])).getElementInfo();
                    result = new CompilationResult(otherType.getFileName(), 1, 1, this.compilerOptions.maxProblemsPerUnit);
                }
                catch (JavaModelException javaModelException) {}
            } else {
                result = new CompilationResult(sourceTypes[0].getFileName(), 1, 1, this.compilerOptions.maxProblemsPerUnit);
            }
            if ((unit = SourceTypeConverter.buildCompilationUnit(sourceTypes, 15, environment.problemReporter, result)) != null) {
                environment.buildTypeBindings(unit, accessRestriction);
                environment.completeTypeBindings(unit, true);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void accept(IModule module, LookupEnvironment environment) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Config config = Dependencies.setup((Object)this, (Parser)this.getParser(), (LookupEnvironment)environment, (boolean)true, (boolean)false);){
            super.accept(module, environment);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public abstract AssistParser getParser();

    public void initializeImportCaches() {
        ImportBinding[] importBindings;
        if (this.currentPackageName == null) {
            this.initializePackageCache();
        }
        int length = (importBindings = this.unitScope.imports) == null ? 0 : importBindings.length;
        int i = 0;
        while (i < length) {
            ImportBinding importBinding = importBindings[i];
            if (importBinding.onDemand) {
                if (this.onDemandImportsCache == null) {
                    this.onDemandImportsCache = new ImportBinding[length - i];
                }
                this.onDemandImportsCache[this.onDemandImportCacheCount++] = importBinding;
            } else if (!(importBinding.resolvedImport instanceof MethodBinding) || importBinding instanceof ImportConflictBinding) {
                if (this.importsCache == null) {
                    this.importsCache = new char[length - i][][];
                }
                this.importsCache[this.importCacheCount++] = new char[][]{importBinding.compoundName[importBinding.compoundName.length - 1], CharOperation.concatWith((char[][])importBinding.compoundName, (char)'.')};
            }
            ++i;
        }
        this.importCachesInitialized = true;
    }

    public void initializePackageCache() {
        this.currentPackageName = this.unitScope.fPackage != null ? CharOperation.concatWith((char[][])this.unitScope.fPackage.compoundName, (char)'.') : (this.unitScope.referenceContext != null && this.unitScope.referenceContext.currentPackage != null ? CharOperation.concatWith((char[][])this.unitScope.referenceContext.currentPackage.tokens, (char)'.') : CharOperation.NO_CHAR);
    }

    protected boolean mustQualifyType(char[] packageName, char[] typeName, char[] enclosingTypeNames, int modifiers) {
        if (this.unitScope == null) {
            return true;
        }
        if (!this.importCachesInitialized) {
            this.initializeImportCaches();
        }
        int i = 0;
        while (i < this.importCacheCount) {
            char[][] importName = this.importsCache[i];
            if (CharOperation.equals((char[])typeName, (char[])importName[0])) {
                char[] fullyQualifiedTypeName = enclosingTypeNames == null || enclosingTypeNames.length == 0 ? CharOperation.concat((char[])packageName, (char[])typeName, (char)'.') : CharOperation.concat((char[])CharOperation.concat((char[])packageName, (char[])enclosingTypeNames, (char)'.'), (char[])typeName, (char)'.');
                return !CharOperation.equals((char[])fullyQualifiedTypeName, (char[])importName[1]);
            }
            ++i;
        }
        if ((enclosingTypeNames == null || enclosingTypeNames.length == 0) && CharOperation.equals((char[])this.currentPackageName, (char[])packageName)) {
            return false;
        }
        char[] fullyQualifiedEnclosingTypeName = null;
        int i2 = 0;
        while (i2 < this.onDemandImportCacheCount) {
            ImportBinding importBinding = this.onDemandImportsCache[i2];
            Binding resolvedImport = importBinding.resolvedImport;
            char[][] importName = importBinding.compoundName;
            char[] importFlatName = CharOperation.concatWith((char[][])importName, (char)'.');
            boolean isFound = false;
            if (resolvedImport instanceof ReferenceBinding) {
                if (enclosingTypeNames != null && enclosingTypeNames.length != 0) {
                    if (fullyQualifiedEnclosingTypeName == null) {
                        fullyQualifiedEnclosingTypeName = CharOperation.concat((char[])packageName, (char[])enclosingTypeNames, (char)'.');
                    }
                    if (CharOperation.equals(fullyQualifiedEnclosingTypeName, (char[])importFlatName)) {
                        isFound = importBinding.isStatic() ? (modifiers & 8) != 0 : true;
                    }
                }
            } else if ((enclosingTypeNames == null || enclosingTypeNames.length == 0) && CharOperation.equals((char[])packageName, (char[])importFlatName)) {
                isFound = importBinding.isStatic() ? (modifiers & 8) != 0 : true;
            }
            if (isFound) {
                int j = 0;
                while (j < this.onDemandImportCacheCount) {
                    if (i2 != j) {
                        ImportBinding conflictingImportBinding = this.onDemandImportsCache[j];
                        if (conflictingImportBinding.resolvedImport instanceof ReferenceBinding) {
                            ReferenceBinding refBinding = (ReferenceBinding)conflictingImportBinding.resolvedImport;
                            if (refBinding.getMemberType(typeName) != null) {
                                return true;
                            }
                        } else {
                            char[] conflictingImportName = CharOperation.concatWith((char[][])conflictingImportBinding.compoundName, (char)'.');
                            if (this.nameEnvironment.nameLookup.findType(String.valueOf(typeName), String.valueOf(conflictingImportName), false, 0x100001E, false) != null) {
                                return true;
                            }
                        }
                    }
                    ++j;
                }
                return false;
            }
            ++i2;
        }
        return true;
    }

    protected ASTNode parseBlockStatements(CompilationUnitDeclaration unit, int position) {
        int length = unit.types.length;
        int i = 0;
        while (i < length) {
            TypeDeclaration type = unit.types[i];
            if (type.declarationSourceStart < position && type.declarationSourceEnd >= position) {
                this.getParser().scanner.setSource(unit.compilationResult);
                if (type.isTeam() || type.isRole()) {
                    this.getParser().scanner.enterOTSource();
                }
                return this.parseBlockStatements(type, unit, position);
            }
            ++i;
        }
        return null;
    }

    private ASTNode parseBlockStatements(TypeDeclaration type, CompilationUnitDeclaration unit, int position) {
        FieldDeclaration[] fields;
        AbstractMethodDeclaration[] methods;
        TypeDeclaration[] memberTypes = type.memberTypes;
        if (memberTypes != null) {
            int length = memberTypes.length;
            int i = 0;
            while (i < length) {
                TypeDeclaration memberType = memberTypes[i];
                if (memberType.bodyStart <= position && memberType.declarationSourceEnd >= position) {
                    return this.parseBlockStatements(memberType, unit, position);
                }
                ++i;
            }
        }
        if ((methods = type.methods) != null) {
            int length = methods.length;
            int i = 0;
            while (i < length) {
                AbstractMethodDeclaration method = methods[i];
                if (method.bodyStart <= position + 1 && !method.isDefaultConstructor() && method.declarationSourceEnd >= position) {
                    this.getParser().parseBlockStatements(method, unit);
                    return method;
                }
                ++i;
            }
        }
        if ((fields = type.fields) != null) {
            int length = fields.length;
            int i = 0;
            while (i < length) {
                FieldDeclaration field = fields[i];
                if (field.sourceStart <= position && field.declarationSourceEnd >= position) {
                    if (field instanceof Initializer) {
                        this.getParser().parseBlockStatements((Initializer)field, type, unit);
                    }
                    return field;
                }
                ++i;
            }
        }
        return this.parseMethodMappings(type, unit, position);
    }

    private ASTNode parseMethodMappings(TypeDeclaration type, CompilationUnitDeclaration unit, int position) {
        AbstractMethodMappingDeclaration[] mappings = type.callinCallouts;
        if (mappings != null) {
            int length = mappings.length;
            int i = 0;
            while (i < length) {
                AbstractMethodMappingDeclaration mapping = mappings[i];
                if (mapping.declarationSourceStart <= position && mapping.declarationSourceEnd >= position) {
                    if (mapping.isCallin()) {
                        CallinMappingDeclaration callinMapping = (CallinMappingDeclaration)mapping;
                        if (callinMapping.roleMethodSpec.sourceStart <= position && callinMapping.roleMethodSpec.sourceEnd >= position) {
                            return callinMapping.roleMethodSpec;
                        }
                        int baseSpecIdx = 0;
                        while (baseSpecIdx < callinMapping.baseMethodSpecs.length) {
                            if (callinMapping.baseMethodSpecs[baseSpecIdx].sourceStart <= position && callinMapping.baseMethodSpecs[baseSpecIdx].sourceEnd >= position) {
                                return callinMapping.baseMethodSpecs[baseSpecIdx];
                            }
                            ++baseSpecIdx;
                        }
                    } else {
                        CalloutMappingDeclaration calloutMapping = (CalloutMappingDeclaration)mapping;
                        if (calloutMapping.roleMethodSpec != null && calloutMapping.roleMethodSpec.sourceStart <= position && calloutMapping.roleMethodSpec.sourceEnd >= position) {
                            return calloutMapping.roleMethodSpec;
                        }
                        if (calloutMapping.baseMethodSpec != null && calloutMapping.baseMethodSpec.sourceStart <= position && calloutMapping.baseMethodSpec.sourceEnd >= position) {
                            return calloutMapping.baseMethodSpec;
                        }
                    }
                    this.getParser().parseBlockStatements(mapping, unit);
                    if (mapping.mappings != null) {
                        int j = 0;
                        while (j < mapping.mappings.length) {
                            ParameterMapping parameterMapping = mapping.mappings[j];
                            if (parameterMapping.sourceStart <= position && parameterMapping.sourceEnd >= position) {
                                return parameterMapping;
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        return null;
    }

    protected void reset(boolean resetLookupEnvironment) {
        if (resetLookupEnvironment) {
            this.lookupEnvironment.reset();
        }
    }

    public static char[] getTypeSignature(TypeBinding typeBinding) {
        char[] result = typeBinding.signature();
        if (result != null) {
            result = CharOperation.replaceOnCopy((char[])result, (char)'/', (char)'.');
        }
        return result;
    }

    public static char[] getSignature(MethodBinding methodBinding) {
        char[] result = null;
        int oldMod = methodBinding.modifiers;
        methodBinding.modifiers |= 0x40000000;
        result = methodBinding.genericSignature(true);
        if (result == null) {
            result = methodBinding.signature(true);
        }
        methodBinding.modifiers = oldMod;
        if (result != null) {
            result = CharOperation.replaceOnCopy((char[])result, (char)'/', (char)'.');
        }
        return result;
    }

    public static char[] getSignature(TypeBinding typeBinding) {
        char[] result = null;
        result = typeBinding.genericTypeSignature(true);
        if (result != null) {
            result = CharOperation.replaceOnCopy((char[])result, (char)'/', (char)'.');
        }
        return result;
    }

    public Parser getPlainParser() {
        return null;
    }
}

