/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.objectteams.otdt.core.compiler.InferenceKind;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.CallinMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TypeAnalyzer;

public class CallinCalloutBinding
extends Binding {
    public static final int CALLIN = 1;
    public static final int CALLOUT = 2;
    public static final int CALLOUT_OVERRIDE = 3;
    public static final int REPLACE = 1;
    public static final int AFTER = 2;
    public static final int BEFORE = 3;
    public TypeVariableBinding[] typeVariables;
    public MethodBinding _roleMethodBinding;
    public ReferenceBinding _declaringRoleClass;
    public MethodBinding[] _baseMethods = Binding.NO_METHODS;
    public FieldBinding _baseField;
    public int type;
    public int callinModifier;
    public int calloutModifier;
    public int declaredModifiers;
    public char[] name;
    public InferenceKind inferred = InferenceKind.NONE;
    public long tagBits = 0L;
    public CallinCalloutBinding copyInheritanceSrc;
    public int callinIdMax = -1;

    public CallinCalloutBinding(boolean isCalloutOverride, MethodBinding roleMethodBinding, ReferenceBinding declaringRoleClass, int calloutModifier, int declaredModifiers) {
        this._declaringRoleClass = declaringRoleClass;
        this._roleMethodBinding = roleMethodBinding;
        this.type = isCalloutOverride ? 3 : 2;
        this.calloutModifier = calloutModifier;
        this.declaredModifiers = declaredModifiers;
    }

    public CallinCalloutBinding(ReferenceBinding declaringRoleClass, CallinMappingDeclaration mappingDecl) {
        this.type = 1;
        this._declaringRoleClass = declaringRoleClass;
        this.name = mappingDecl.name;
        this.callinModifier = mappingDecl.callinModifier;
        this._roleMethodBinding = mappingDecl.getRoleMethod();
    }

    public CallinCalloutBinding(ReferenceBinding declaringRole, char[] name, int callinModifier) {
        this.type = 1;
        this._declaringRoleClass = declaringRole;
        this.name = name;
        this.callinModifier = callinModifier;
    }

    public CallinCalloutBinding(ReferenceBinding declaringRole, char[] name) {
        this.type = 1;
        this._declaringRoleClass = declaringRole;
        this.name = name;
    }

    @Override
    public int kind() {
        return 32768;
    }

    public CallinCalloutBinding getOrigin() {
        if (this.copyInheritanceSrc != null) {
            return this.copyInheritanceSrc.getOrigin();
        }
        return this;
    }

    @Override
    public char[] readableName() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.toString());
        return buffer.toString().toCharArray();
    }

    public boolean isCallin() {
        return this.type == 1;
    }

    public boolean isReplaceCallin() {
        return this.type == 1 && this.callinModifier == 1;
    }

    private boolean isCalloutOverride() {
        return this.type == 3;
    }

    public boolean isCallout() {
        return this.type == 2 || this.type == 3;
    }

    public boolean hasValidBaseMethods() {
        if (this._baseMethods == null || this._baseMethods.length == 0) {
            return false;
        }
        int i = 0;
        while (i < this._baseMethods.length) {
            if (!this._baseMethods[i].isValidBinding()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean hasValidRoleMethod() {
        return this._roleMethodBinding != null && this._roleMethodBinding.isValidBinding();
    }

    @Override
    public int problemId() {
        if (this._roleMethodBinding != null && !this._roleMethodBinding.isValidBinding()) {
            return this._roleMethodBinding.problemId();
        }
        if (this._baseMethods != null) {
            MethodBinding[] methodBindingArray = this._baseMethods;
            int n = this._baseMethods.length;
            int n2 = 0;
            while (n2 < n) {
                MethodBinding method = methodBindingArray[n2];
                if (!method.isValidBinding()) {
                    return method.problemId();
                }
                ++n2;
            }
        }
        if (this._baseField != null) {
            return this._baseField.problemId();
        }
        return 0;
    }

    public boolean isRoleMethodOverriddenIn(ReferenceBinding subRole) {
        if (!this.hasValidRoleMethod()) {
            return false;
        }
        MethodBinding[] methodBindingArray = subRole.getMethods(this._roleMethodBinding.selector);
        int n = methodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodBinding subMethod = methodBindingArray[n2];
            if (TypeAnalyzer.isEqualMethodSignature(this._roleMethodBinding.declaringClass.enclosingType(), this._roleMethodBinding, subRole.enclosingType(), subMethod, 3)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public TypeVariableBinding getTypeVariable(char[] variableName) {
        int i = this.typeVariables.length;
        while (--i >= 0) {
            if (!CharOperation.equals(this.typeVariables[i].sourceName, variableName)) continue;
            return this.typeVariables[i];
        }
        return null;
    }

    @Override
    public char[] computeUniqueKey(boolean isLeaf) {
        if (this.name != null) {
            return this.name;
        }
        if (this._roleMethodBinding == null) {
            return new char[0];
        }
        if (this._baseMethods != Binding.NO_METHODS) {
            return CharOperation.concat(this._roleMethodBinding.computeUniqueKey(isLeaf), "->".toCharArray(), this._baseMethods[0].computeUniqueKey(isLeaf));
        }
        return CharOperation.concat(this._roleMethodBinding.computeUniqueKey(isLeaf), "->".toCharArray());
    }

    @Override
    public void setAnnotations(AnnotationBinding[] annotations, boolean forceStore) {
        this._declaringRoleClass.storeAnnotations(this, annotations, forceStore);
    }

    @Override
    public AnnotationBinding[] getAnnotations() {
        return this._declaringRoleClass.retrieveAnnotations(this);
    }

    public String toString() {
        Object result = this.name == null ? "" : new String(this.name) + ": ";
        result = (String)result + (this._roleMethodBinding != null ? this._roleMethodBinding.toString(false) : "NULL ROLE METHODS");
        if (this.isCallin()) {
            result = (String)result + "<- " + CallinMappingDeclaration.callinModifier(this.callinModifier) + " ";
        } else if (this.isCallout()) {
            result = this.isCalloutOverride() ? (String)result + "=> " : (String)result + "-> ";
        }
        if (this._baseMethods != null) {
            int i = 0;
            while (i < this._baseMethods.length) {
                result = (String)result + this._baseMethods[i].toString(false);
                if (i < this._baseMethods.length - 1) {
                    result = (String)result + ", ";
                }
                ++i;
            }
        }
        result = (String)result + ";";
        return result;
    }

    public char[] getQualifiedName() {
        char[] theName = this.name;
        if (theName[0] == '<') {
            return theName;
        }
        ReferenceBinding currentType = this._declaringRoleClass;
        return CharOperation.concat(theName, currentType.readableName(), '$');
    }

    public ReferenceBinding introducingRoleClass() {
        ReferenceBinding declaringRole = this._declaringRoleClass;
        if (this.name == null) {
            return declaringRole;
        }
        if (this.name[0] != '<') {
            ReferenceBinding currentRole = declaringRole;
            while (currentRole != null && currentRole.isRole()) {
                CallinCalloutBinding[] callinCalloutBindingArray = currentRole.callinCallouts;
                int n = currentRole.callinCallouts.length;
                int n2 = 0;
                while (n2 < n) {
                    CallinCalloutBinding mapping = callinCalloutBindingArray[n2];
                    if (CharOperation.equals(this.name, mapping.name)) {
                        declaringRole = currentRole;
                    }
                    ++n2;
                }
                currentRole = currentRole.superclass();
            }
        }
        return declaringRole;
    }
}

