/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.bytecode;

import java.util.Iterator;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileConstants;
import org.eclipse.jdt.internal.compiler.codegen.AttributeNamesConstants;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.ConstantPoolObject;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.ConstantPoolObjectMapper;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.ConstantPoolObjectReader;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.ConstantPoolObjectWriter;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.ConstantPoolSimpleConverter;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.OTByteCodes;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.ArrayTranslations;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.Lifting;
import org.eclipse.objectteams.otdt.internal.core.compiler.mappings.CalloutImplementorDyn;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.LineInfo;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.LineNumberProvider;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.TeamMethodGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TSuperHelper;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TypeAnalyzer;

public class BytecodeTransformer
implements AttributeNamesConstants,
ClassFileConstants {
    public static final int ITEM_OBJECT = 7;
    public static final int ITEM_UNINITIALIZED = 8;
    private ConstantPoolObjectReader _reader;
    private ConstantPoolObjectWriter _writer;
    private ConstantPoolObjectMapper _mapper;
    private static final int METHOD_PREFIX_LEN = 8;
    private static final int CODE_ATTR_PREFIX_LEN = 14;

    public void checkCopyNonWideConstants(Scope scope, ClassFile classFile) {
        block10: {
            TeamModel srcModel;
            TeamMethodGenerator tmg;
            SourceTypeBinding dstType = classFile.referenceBinding;
            this._writer = new ConstantPoolObjectWriter(classFile);
            if (dstType.isRole() && !dstType.isInterface()) {
                ReferenceBinding[] tsuperRoles = dstType.roleModel.getTSuperRoleBindings();
                int i = 0;
                while (i < tsuperRoles.length) {
                    byte[] srcConstantPool;
                    RoleModel srcRole = tsuperRoles[i].roleModel;
                    if (srcRole != null && srcRole.hasByteCode() && (srcConstantPool = srcRole.getByteCode()) != null) {
                        this._reader = new ConstantPoolObjectReader(srcRole, srcConstantPool, scope.environment());
                        this.copyAllNonWideConstants(srcRole.getConstantPoolOffsets().length, srcRole.getBinding().enclosingType(), dstType);
                    }
                    ++i;
                }
            }
            if (!dstType.isTeam()) break block10;
            ReferenceBinding orgObjectteamsTeam = scope.getOrgObjectteamsTeam();
            if (!TypeAnalyzer.isOrgObjectteamsTeam(dstType) && !dstType.superclass.isTeam() && (tmg = scope.environment().getTeamMethodGenerator()).requestBytes()) {
                this._reader = new ConstantPoolObjectReader(tmg.classBytes, tmg.constantPoolOffsets, orgObjectteamsTeam.getTeamModel(), scope.environment());
                this.copyAllNonWideConstants(tmg.constantPoolOffsets.length, dstType.superclass, dstType);
            }
            if ((srcModel = dstType.superclass.getTeamModel()) == null) {
                return;
            }
            MethodBinding[] methodBindingArray = dstType.methods();
            int n = methodBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                block11: {
                    TeamModel methodSrcTeam;
                    MethodBinding method;
                    block12: {
                        method = methodBindingArray[n2];
                        method = method.copyInheritanceSrc;
                        if (method == null || method.model == null) break block11;
                        methodSrcTeam = srcModel;
                        if (!TypeBinding.notEquals(method.declaringClass, srcModel.getBinding())) break block12;
                        if (!method.declaringClass.isTeam()) break block11;
                        methodSrcTeam = method.declaringClass.getTeamModel();
                    }
                    if (method.model.hasBytes()) {
                        this._reader = new ConstantPoolObjectReader(method.model, methodSrcTeam, scope.environment());
                        this.copyAllNonWideConstants(method.model.getConstantPoolOffsets().length, methodSrcTeam.getBinding(), dstType);
                        return;
                    }
                }
                ++n2;
            }
        }
    }

    public void checkCopyMethodCode(ClassFile classFile, AbstractMethodDeclaration dstMethod) {
        assert (dstMethod.isRelevantCopied());
        assert (dstMethod.sourceMethodBinding != null);
        SourceTypeBinding dstType = classFile.referenceBinding;
        MethodBinding srcMethodBinding = dstMethod.sourceMethodBinding;
        ReferenceBinding srcType = srcMethodBinding.declaringClass;
        RoleModel srcRole = srcType.roleModel;
        if (TypeAnalyzer.isSourceTypeWithErrors(srcType) || MethodModel.hasProblem(srcMethodBinding)) {
            dstMethod.binding.bytecodeMissing = true;
            return;
        }
        if (CharOperation.equals(CalloutImplementorDyn.OT_ACCESS, dstMethod.selector) || CharOperation.equals(CalloutImplementorDyn.OT_ACCESS_STATIC, dstMethod.selector)) {
            return;
        }
        byte[] srcConstantPool = null;
        int offset = -1;
        ConstantPoolObjectReader reader = null;
        if (!srcMethodBinding.original().bytecodeMissing) {
            if (srcRole != null) {
                srcConstantPool = srcRole.getByteCode();
                offset = srcRole.getByteCodeOffset(srcMethodBinding);
                reader = new ConstantPoolObjectReader(srcRole, srcConstantPool, dstMethod.scope.environment());
            } else if (srcMethodBinding.model != null) {
                assert (srcType.isTeam());
                MethodModel mModel = srcMethodBinding.model;
                srcConstantPool = mModel.getBytes();
                offset = mModel.getStructOffset();
                reader = new ConstantPoolObjectReader(mModel, srcType.getTeamModel(), dstMethod.scope.environment());
            }
        }
        if (offset == -1) {
            dstMethod.binding.bytecodeMissing = true;
            return;
        }
        this.doCopyMethodCode(srcRole, srcMethodBinding, dstType, dstMethod, srcConstantPool, null, offset, reader, new ConstantPoolObjectMapper(srcMethodBinding, dstMethod.binding), classFile);
    }

    public void doCopyMethodCode(RoleModel srcRole, MethodBinding srcMethodBinding, SourceTypeBinding dstType, AbstractMethodDeclaration dstMethod, byte[] srcConstantPool, int[] constantPoolOffsets, int offset, ConstantPoolObjectReader reader, ConstantPoolObjectMapper mapper, ClassFile classFile) {
        byte[] extraAttr;
        this._reader = reader;
        this._mapper = mapper;
        this._writer = new ConstantPoolObjectWriter(classFile);
        int codeAttributeOffset = this.findCodeAttribute(srcConstantPool, offset);
        int codeLength = OTByteCodes.getInt(srcConstantPool, codeAttributeOffset + 10);
        int tailOffset = codeAttributeOffset + 14 + codeLength;
        int attributesLen = this.computeAttributesLen(srcConstantPool, offset);
        int totalLen = 8 + attributesLen;
        byte[] methodCode = new byte[totalLen];
        System.arraycopy(srcConstantPool, offset, methodCode, 0, totalLen);
        ConstantPoolSimpleConverter conv = constantPoolOffsets == null ? ConstantPoolSimpleConverter.create(srcRole, srcMethodBinding, methodCode, classFile) : new ConstantPoolSimpleConverter(srcConstantPool, constantPoolOffsets, offset, methodCode, classFile);
        conv.updateName(codeAttributeOffset - offset);
        byte[][] varDest = new byte[][]{methodCode};
        boolean isAddingMarkerArg = !TSuperHelper.isTSuper(srcMethodBinding) && dstMethod.isTSuper;
        int copyInhSrcLineOffsetOffset = this.copyAdjustStructure(classFile, conv, srcConstantPool, offset, varDest, dstMethod.binding, totalLen, isAddingMarkerArg);
        int inc = varDest[0].length - methodCode.length;
        tailOffset += inc;
        totalLen += inc;
        codeAttributeOffset += inc;
        methodCode = varDest[0];
        codeAttributeOffset -= offset;
        tailOffset -= offset;
        if (copyInhSrcLineOffsetOffset == -1 && (extraAttr = this.generateCpInhSrc(dstMethod.model, classFile)) != null) {
            byte[] byArray = methodCode;
            methodCode = new byte[totalLen + extraAttr.length];
            System.arraycopy(byArray, 0, methodCode, 0, totalLen);
            System.arraycopy(extraAttr, 0, methodCode, totalLen, extraAttr.length);
            this.incrementWord(methodCode, 0, 6, 1);
            copyInhSrcLineOffsetOffset = totalLen + 8;
        }
        if (dstMethod.isTSuper) {
            this.incrementWord(methodCode, codeAttributeOffset, 8, 1);
        }
        CodeStream codeStream = classFile.codeStream;
        codeStream.init(classFile);
        int newMethodOffset = classFile.contentsOffset;
        boolean isCtorAddingMarkArg = srcMethodBinding.isConstructor() && !TSuperHelper.isTSuper(srcMethodBinding) && dstMethod.isTSuper;
        try {
            this.adjustCode(classFile, dstMethod.getModel(), methodCode, codeAttributeOffset, codeLength, isCtorAddingMarkArg);
        }
        catch (ConstantPoolObjectReader.IncompatibleBytecodeException ibe) {
            ProblemReporter pr = dstMethod.scope.problemReporter();
            pr.incompatibleBytecode(ibe._offendingName, ibe._problemId);
        }
        catch (Throwable throwable) {
            ProblemReporter pr = dstMethod.scope.problemReporter();
            pr.corruptBytecode(dstMethod.binding);
        }
        int lineOffset = this.adjustTail(dstType, methodCode, tailOffset, dstMethod.binding, srcMethodBinding.model);
        if (copyInhSrcLineOffsetOffset > -1 && lineOffset != 0) {
            OTByteCodes.setInt(methodCode, copyInhSrcLineOffsetOffset, lineOffset);
            MethodModel.getModel((AbstractMethodDeclaration)dstMethod)._lineOffset = lineOffset;
        }
        codeStream.writeBytes(methodCode);
        classFile.contents = codeStream.bCodeStream;
        classFile.contentsOffset += methodCode.length;
        ++classFile.methodCount;
        dstMethod.maybeRecordByteCode(classFile, newMethodOffset);
    }

    private int computeAttributesLen(byte[] srcConstantPool, int offset) {
        int attributesStart;
        int attributesCount = OTByteCodes.getWord(srcConstantPool, offset + 6);
        int attrOffset = attributesStart = offset + 8;
        int i = 0;
        while (i < attributesCount) {
            attrOffset += 2;
            attrOffset += 4 + OTByteCodes.getInt(srcConstantPool, attrOffset);
            ++i;
        }
        return attrOffset - attributesStart;
    }

    private void incrementWord(byte[] code, int codeAttributeOffset, int offset, int increment) {
        int value = OTByteCodes.getWord(code, codeAttributeOffset + offset);
        OTByteCodes.setWord(code, codeAttributeOffset + offset, value + increment);
    }

    private int findCodeAttribute(byte[] code, int start) {
        int attributesCount = OTByteCodes.getWord(code, start + 6);
        start += 8;
        int i = 0;
        while (i < attributesCount) {
            char[] attribute_name = this._reader.getUtf8(OTByteCodes.getWord(code, start + 0));
            if (CharOperation.equals(attribute_name, CodeName)) {
                return start;
            }
            int attribute_length = OTByteCodes.getInt(code, start + 2);
            start += 6 + attribute_length;
            ++i;
        }
        throw new InternalCompilerError("Binary method has no code attribute");
    }

    private int copyAdjustStructure(ClassFile classFile, ConstantPoolSimpleConverter conv, byte[] src, int srcOffset, byte[][] varDest, MethodBinding dstMethod, int expectedLen, boolean isAddingMarkerArg) {
        byte[] dest = varDest[0];
        conv.updateName(2);
        conv.writeName(4, dstMethod.signature(classFile));
        int attributesCount = OTByteCodes.getWord(dest, 6);
        int offset = 8;
        int destOff = 0;
        int copyInhSrcLineOffsetOffset = -1;
        int i = 0;
        while (i < attributesCount) {
            int j;
            char[] attrName = conv.updateName(offset);
            int attrLen = OTByteCodes.getInt(src, srcOffset + (offset += 2));
            offset += 4;
            if (CharOperation.equals(attrName, ExceptionsName)) {
                int numExceptions = OTByteCodes.getWord(src, srcOffset + offset);
                offset += 2;
                j = 0;
                while (j < numExceptions) {
                    int ref = OTByteCodes.getWord(src, srcOffset + offset);
                    ConstantPoolObject cpo = this._reader.readConstantPoolObject(ref, 2);
                    cpo = this._mapper.mapConstantPoolObject(cpo);
                    this._writer.writeConstantPoolObject(dest, offset + destOff, 2, cpo);
                    offset += 2;
                    ++j;
                }
            } else if (CharOperation.equals(attrName, SignatureName)) {
                conv.updateName(offset);
                offset += 2;
            } else if (CharOperation.equals(attrName, IOTConstants.COPY_INHERITANCE_SOURCE_NAME)) {
                conv.updateName(offset);
                if (attrLen > 2) {
                    copyInhSrcLineOffsetOffset = offset + 2;
                    offset += 6;
                } else {
                    copyInhSrcLineOffsetOffset = 0;
                    offset += 2;
                }
            } else if (CharOperation.equals(attrName, IOTConstants.TYPE_ANCHOR_LIST)) {
                int num = OTByteCodes.getWord(src, srcOffset + offset);
                offset += 2;
                j = 0;
                while (j < num) {
                    conv.updateName(offset);
                    offset += 2;
                    ++j;
                }
            } else if (CharOperation.equals(attrName, RuntimeVisibleAnnotationsName) || CharOperation.equals(attrName, RuntimeInvisibleAnnotationsName)) {
                int annotCount = OTByteCodes.getWord(src, srcOffset + offset);
                offset += 2;
                j = 0;
                while (j < annotCount) {
                    offset = this.adjustAnnotation(conv, src, srcOffset, offset);
                    ++j;
                }
            } else if (CharOperation.equals(attrName, RuntimeInvisibleParameterAnnotationsName) || CharOperation.equals(attrName, RuntimeVisibleParameterAnnotationsName)) {
                if (isAddingMarkerArg) {
                    OTByteCodes.setInt(dest, offset + destOff - 4, attrLen + 2);
                    int paramCount = OTByteCodes.getUnsignedByte(src, srcOffset + offset);
                    dest[offset + destOff] = (byte)(paramCount + 1);
                    ++offset;
                    int p = 0;
                    while (p < paramCount) {
                        int annotCount = OTByteCodes.getWord(src, srcOffset + offset);
                        offset += 2;
                        int j2 = 0;
                        while (j2 < annotCount) {
                            offset = this.adjustAnnotation(conv, src, srcOffset, offset + destOff);
                            ++j2;
                        }
                        ++p;
                    }
                    dest = OTByteCodes.insertWord(dest, offset + destOff, 0);
                    varDest[0] = dest;
                    destOff += 2;
                } else {
                    offset += attrLen;
                }
            } else {
                offset += attrLen;
            }
            ++i;
        }
        assert (offset == expectedLen);
        return copyInhSrcLineOffsetOffset;
    }

    private int adjustAnnotation(ConstantPoolSimpleConverter conv, byte[] src, int srcOffset, int offset) {
        conv.updateName(offset);
        int numMembers = OTByteCodes.getWord(src, srcOffset + (offset += 2));
        offset += 2;
        if (numMembers > 0) {
            int k = 0;
            while (k < numMembers) {
                conv.updateName(offset);
                offset += 2;
                offset = this.adjustAnnotationElementValue(conv, src, srcOffset, offset);
                ++k;
            }
        }
        return offset;
    }

    private int adjustAnnotationElementValue(ConstantPoolSimpleConverter conv, byte[] src, int srcOffset, int offset) throws IllegalArgumentException {
        int currentOffset = offset;
        int tag = OTByteCodes.getUnsignedByte(src, srcOffset + currentOffset);
        ++currentOffset;
        switch (tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: {
                currentOffset += 2;
                break;
            }
            case 99: 
            case 115: {
                conv.updateName(currentOffset);
                currentOffset += 2;
                break;
            }
            case 101: {
                conv.updateName(currentOffset);
                conv.updateName(currentOffset += 2);
                currentOffset += 2;
                break;
            }
            case 64: {
                currentOffset = this.adjustAnnotation(conv, src, srcOffset, currentOffset);
                break;
            }
            case 91: {
                int numberOfValues = OTByteCodes.getWord(src, srcOffset + currentOffset);
                currentOffset += 2;
                int i = 0;
                while (i < numberOfValues) {
                    currentOffset = this.adjustAnnotationElementValue(conv, src, srcOffset, currentOffset);
                    ++i;
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return currentOffset;
    }

    byte[] generateCpInhSrc(MethodModel model, ClassFile classFile) {
        if (model == null || model._attributes == null) {
            return null;
        }
        int i = 0;
        while (i < model._attributes.length) {
            if (CharOperation.equals(model._attributes[i]._name, IOTConstants.COPY_INHERITANCE_SOURCE_NAME)) {
                byte[] result = new byte[model._attributes[i].size()];
                model._attributes[i].generate(result, 0, classFile.constantPool);
                return result;
            }
            ++i;
        }
        return null;
    }

    private void adjustCode(ClassFile dstClassFile, MethodModel mModel, byte[] codeToAdjust, int codeAttributeOffset, int codeLength, boolean isCtorAddingMarkArg) {
        int actualBytecodeStart;
        int state = 1;
        boolean initCachesAdded = false;
        int i = actualBytecodeStart = codeAttributeOffset + 14;
        while (i < actualBytecodeStart + codeLength) {
            int arg;
            byte b_int = codeToAdjust[i];
            int length = OTByteCodes.cpReferenceLength(b_int);
            if (length != 0) {
                int ref = OTByteCodes.getRef(length, codeToAdjust, i + 1);
                ConstantPoolObject src_cpo = this._reader.readConstantPoolObject(ref, length);
                ConstantPoolObject dst_cpo = this._mapper.mapConstantPoolObject(src_cpo, state == 3);
                if (dst_cpo.isMethod()) {
                    if (dst_cpo.isIllegallyCopiedCtor()) {
                        AbstractMethodDeclaration methodDecl = mModel.getDecl();
                        methodDecl.scope.problemReporter().illegallyCopiedDefaultCtor(methodDecl, methodDecl.scope.referenceType());
                        return;
                    }
                    MethodBinding method = dst_cpo.getMethodRef();
                    if (state == 3) {
                        if (isCtorAddingMarkArg && method.overriddenTSupers != null && method.isConstructor()) {
                            MethodBinding tsuperVersion = this.findTSuperVersion(method);
                            if (tsuperVersion != null) {
                                this.replaceChainArg(codeToAdjust, i - 3);
                                dst_cpo.setMethod(tsuperVersion);
                            }
                        } else if (method.parameters.length > src_cpo.getMethodRef().parameters.length && method.copyInheritanceSrc != null) {
                            codeToAdjust[i - 2] = 0;
                            codeToAdjust[i - 1] = 0;
                        }
                    }
                }
                this._writer.writeConstantPoolObject(codeToAdjust, i + 1, length, dst_cpo);
            } else if (b_int == 0 && mModel != null && mModel.liftedParams != null && mModel.liftedParams.length > 0 && (arg = this.checkPatchLiftingNops(codeToAdjust, i)) >= 0) {
                ConstantPoolObject dst_cpo = null;
                int loadPos = arg & 0x1FFF;
                if (!initCachesAdded) {
                    dst_cpo = this.getInitCachesMethod(dstClassFile);
                    if (dst_cpo != null) {
                        this._writer.writeConstantPoolObject(codeToAdjust, i + 2, 2, dst_cpo);
                    }
                    initCachesAdded = true;
                }
                if (dst_cpo == null) {
                    codeToAdjust[i + 1] = 0;
                }
                int offset = loadPos > 3 ? 1 : 0;
                dst_cpo = this.getLiftMethod(dstClassFile, mModel, loadPos);
                if (dst_cpo == null) {
                    return;
                }
                this._writer.writeConstantPoolObject(codeToAdjust, i + offset + 8, 2, dst_cpo);
                this.incrementWord(codeToAdjust, codeAttributeOffset, 6, 2);
                length = 10 + offset;
                if ((arg & 0x2000) != 0) {
                    ++length;
                }
            }
            if (state == 1 && b_int == 1) {
                state = 2;
            } else if (state == 2 && b_int == 58) {
                state = 3;
            } else if (state == 3) {
                state = 0;
            }
            i += length;
            i += OTByteCodes.getParamLength(b_int, codeToAdjust, i, actualBytecodeStart);
            ++i;
        }
    }

    private void copyAllNonWideConstants(int nConstants, ReferenceBinding srcTeamBinding, ReferenceBinding dstType) {
        Iterator<ConstantPoolObject> it = this._reader.getNonWideConstantIterator(nConstants);
        if (!dstType.isTeam() && dstType.isRole()) {
            dstType = dstType.enclosingType();
        }
        while (it.hasNext()) {
            ConstantPoolObject src_cpo = it.next();
            ConstantPoolObject dst_cpo = src_cpo.isClass() ? new ConstantPoolObject(7, ConstantPoolObjectMapper.mapClass(srcTeamBinding, src_cpo.getClassObject(), dstType)) : src_cpo;
            this._writer.writeConstantPoolObject(dst_cpo);
        }
    }

    private ConstantPoolObject getInitCachesMethod(ClassFile dstClassFile) {
        MethodBinding[] inits = dstClassFile.referenceBinding.getMethods(IOTConstants.OT_INIT_CACHES);
        if (inits.length == 0) {
            return null;
        }
        assert (inits.length == 1);
        ConstantPoolObject dst_cpo = new ConstantPoolObject(10, inits[0]);
        return dst_cpo;
    }

    private ConstantPoolObject getLiftMethod(ClassFile dstClassFile, MethodModel mModel, int arg) {
        TypeBinding[] adjustedArgs = mModel.liftedParams;
        TypeBinding roleOrig = adjustedArgs[arg - 1];
        AbstractMethodDeclaration mDecl = mModel.getDecl();
        TypeBinding role = TeamModel.getRoleToLiftTo(mDecl.scope, mDecl.binding.parameters[arg - 1], roleOrig, true, mDecl.arguments[arg - 1]);
        char[] liftName = null;
        liftName = role.isArrayType() ? ArrayTranslations.getTransformMethodName((ReferenceBinding)role.leafComponentType(), role.dimensions(), true) : Lifting.getLiftMethodName(role);
        MethodBinding[] lifters = dstClassFile.referenceBinding.getMethods(liftName);
        if (lifters.length != 1) {
            assert (RoleModel.hasTagBit(((ReferenceBinding)role.leafComponentType()).getRealClass(), 4)) : "must have lift method unless lifting problem was detected";
            return null;
        }
        ConstantPoolObject dst_cpo = new ConstantPoolObject(10, lifters[0]);
        return dst_cpo;
    }

    private int checkPatchLiftingNops(byte[] code, int idx) {
        int i = idx + 1;
        while (i < idx + 6) {
            if (code[i] != 0) {
                return -1;
            }
            ++i;
        }
        int loadPos = OTByteCodes.getAloadPos(code[idx + 6], code[idx + 7]);
        if (loadPos == -1) {
            return -1;
        }
        int storeStart = loadPos > 3 ? 8 : 7;
        i = idx + storeStart;
        while (i < idx + storeStart + 3) {
            if (code[i] != 0) {
                return -1;
            }
            ++i;
        }
        int storePos = OTByteCodes.getAstorePos(code[idx + 10], code[idx + 11]);
        if (storePos == -1) {
            return -1;
        }
        code[idx + 0] = 42;
        code[idx + 1] = -74;
        code[idx + 4] = 87;
        code[idx + 5] = 42;
        if (loadPos > 3) {
            ++idx;
        }
        code[idx + 7] = -74;
        if (storePos > 3) {
            loadPos += 8192;
        }
        return loadPos;
    }

    public static void addChainingPlaceholder(BlockScope scope, CodeStream codeStream, int chainTSuperMarkArgPos) {
        LocalVariableBinding nullVar = new LocalVariableBinding("_OT$chainArg".toCharArray(), (TypeBinding)scope.getJavaLangObject(), 0, false);
        nullVar.resolvedPosition = chainTSuperMarkArgPos;
        nullVar.useFlag = 1;
        nullVar.declaringScope = scope.methodScope();
        codeStream.record(nullVar);
        codeStream.addVisibleLocalVariable(nullVar);
        codeStream.aconst_null();
        codeStream.astore(chainTSuperMarkArgPos);
        nullVar.recordInitializationStartPC(0);
        if (nullVar.initializationPCs != null) {
            nullVar.recordInitializationEndPC(codeStream.position);
        }
    }

    private void replaceChainArg(byte[] codeToAdjust, int idx) {
        codeToAdjust[idx] = 0;
        codeToAdjust[idx + 1] = 25;
    }

    private MethodBinding findTSuperVersion(MethodBinding orig) {
        ReferenceBinding roleType = orig.declaringClass;
        MethodBinding[] methods = roleType.methods();
        int i = 0;
        while (i < methods.length) {
            if (orig.overridesTSuper(methods[i].copyInheritanceSrc)) {
                return methods[i];
            }
            ++i;
        }
        assert (orig.copyInheritanceSrc != null);
        return null;
    }

    private int[][] getLineNumberTable(byte[] classFileBytes, int offset) {
        int length = OTByteCodes.getWord(classFileBytes, offset);
        int[][] result = null;
        if (length != 0) {
            result = new int[length][2];
            int readOffset = 2;
            int i = 0;
            while (i < length) {
                result[i][0] = OTByteCodes.getWord(classFileBytes, offset + readOffset);
                result[i][1] = OTByteCodes.getWord(classFileBytes, offset + readOffset + 2);
                readOffset += 4;
                ++i;
            }
        }
        return result;
    }

    private int adjustTail(SourceTypeBinding dstType, byte[] codeToAdjust, int tailOffset, MethodBinding dstMethodBinding, MethodModel srcMethodModel) {
        int newLineOffset = 0;
        int exceptionCount = OTByteCodes.getWord(codeToAdjust, tailOffset);
        int offset = tailOffset + 2;
        int i = 0;
        while (i < exceptionCount) {
            if (OTByteCodes.getWord(codeToAdjust, offset + 6) != 0) {
                this.updateCPO(dstType, codeToAdjust, offset + 6, 2);
            }
            offset += 8;
            ++i;
        }
        int implicitSlots = dstMethodBinding.isStatic() ? 2 : 1;
        TypeBinding[] arguments = new TypeBinding[dstMethodBinding.parameters.length + implicitSlots];
        System.arraycopy(dstMethodBinding.parameters, 0, arguments, implicitSlots, dstMethodBinding.parameters.length);
        if (!dstMethodBinding.isStatic()) {
            arguments[0] = dstMethodBinding.declaringClass;
        } else {
            arguments[0] = TypeBinding.INT;
            arguments[1] = dstType.enclosingType();
        }
        int attribCount = OTByteCodes.getWord(codeToAdjust, offset);
        offset += 2;
        int i2 = 0;
        while (i2 < attribCount) {
            ConstantPoolObject typeCPO;
            TypeBinding typeBinding;
            int descRef;
            int slotNumber;
            int slotOffset;
            int descOffset;
            int nameOffset;
            int localBase;
            int j;
            ConstantPoolObject newCPO = this.updateCPO(dstType, codeToAdjust, offset, 2);
            int attrLen = OTByteCodes.getInt(codeToAdjust, offset += 2);
            offset += 4;
            char[] attrName = newCPO.getUtf8();
            if (CharOperation.equals(attrName, LineNumberTableName) && dstType.roleModel != null) {
                int[][] lineNumberTable = this.getLineNumberTable(codeToAdjust, offset);
                if (lineNumberTable != null) {
                    int oldLineOffset = srcMethodModel != null ? srcMethodModel._lineOffset : 0;
                    newLineOffset = this.mapLines(dstMethodBinding.copyInheritanceSrc.declaringClass, lineNumberTable, dstType.roleModel.getLineNumberProvider(), oldLineOffset);
                    int j2 = 0;
                    while (j2 < lineNumberTable.length) {
                        if (lineNumberTable[j2][1] < 65533) {
                            int numberOffset = offset + 2 + j2 * 4 + 2;
                            this._writer.write2(codeToAdjust, numberOffset, lineNumberTable[j2][1] - oldLineOffset + newLineOffset);
                        }
                        ++j2;
                    }
                }
            } else if (CharOperation.equals(attrName, LocalVariableTableName)) {
                int localsCount = OTByteCodes.getWord(codeToAdjust, offset);
                j = 0;
                while (j < localsCount) {
                    localBase = offset + 2 + j * 10;
                    nameOffset = localBase + 4;
                    this.updateCPO(dstType, codeToAdjust, nameOffset, 2);
                    descOffset = localBase + 6;
                    slotOffset = localBase + 8;
                    slotNumber = OTByteCodes.getWord(codeToAdjust, slotOffset);
                    if (slotNumber < arguments.length) {
                        this._writer.writeUtf8(codeToAdjust, descOffset, arguments[slotNumber].signature());
                    } else {
                        descRef = OTByteCodes.getRef(2, codeToAdjust, descOffset);
                        typeBinding = this._reader.getSignatureBinding(descRef, false);
                        typeCPO = this._mapper.mapTypeUtf8(typeBinding, false);
                        this._writer.writeConstantPoolObject(codeToAdjust, descOffset, 2, typeCPO);
                    }
                    ++j;
                }
            } else if (CharOperation.equals(attrName, LocalVariableTypeTableName)) {
                int localsCount = OTByteCodes.getWord(codeToAdjust, offset);
                j = 0;
                while (j < localsCount) {
                    localBase = offset + 2 + j * 10;
                    nameOffset = localBase + 4;
                    this.updateCPO(dstType, codeToAdjust, nameOffset, 2);
                    descOffset = localBase + 6;
                    slotOffset = localBase + 8;
                    slotNumber = OTByteCodes.getWord(codeToAdjust, slotOffset);
                    if (slotNumber < arguments.length) {
                        this._writer.writeUtf8(codeToAdjust, descOffset, arguments[slotNumber].genericTypeSignature());
                    } else {
                        descRef = OTByteCodes.getRef(2, codeToAdjust, descOffset);
                        typeBinding = this._reader.getSignatureBinding(descRef, true);
                        typeCPO = this._mapper.mapTypeUtf8(typeBinding, true);
                        this._writer.writeConstantPoolObject(codeToAdjust, descOffset, 2, typeCPO);
                    }
                    ++j;
                }
            } else if (CharOperation.equals(attrName, StackMapTableName)) {
                this.rewriteStackMapTable(codeToAdjust, offset);
            }
            offset += attrLen;
            ++i2;
        }
        return newLineOffset;
    }

    private int mapLines(ReferenceBinding copySrc, int[][] lineNumberTable, LineNumberProvider provider, int oldLineOffset) {
        if (lineNumberTable.length == 0) {
            return 0;
        }
        int firstLine = Integer.MAX_VALUE;
        int lastLine = 0;
        int[][] nArray = lineNumberTable;
        int n = lineNumberTable.length;
        int n2 = 0;
        while (n2 < n) {
            int[] line = nArray[n2];
            if (line[1] < 65533) {
                firstLine = Math.min(firstLine, line[1]);
                lastLine = Math.max(lastLine, line[1]);
            }
            ++n2;
        }
        if (firstLine == Integer.MAX_VALUE) {
            return 0;
        }
        LineInfo info = provider.addLineInfo(copySrc, firstLine -= oldLineOffset, (lastLine -= oldLineOffset) - firstLine + 1);
        return info.getOutputStartLine() - firstLine;
    }

    private void rewriteStackMapTable(byte[] codeToAdjust, int offset) {
        int numberOfEntries = OTByteCodes.getWord(codeToAdjust, offset);
        offset += 2;
        int j = 0;
        while (j < numberOfEntries) {
            int type = codeToAdjust[offset] & 0xFF;
            int readOffset = 0;
            switch (type) {
                case 247: {
                    readOffset = 3;
                    readOffset += this.rewriteVerificationInfo(codeToAdjust, offset + readOffset);
                    break;
                }
                case 248: 
                case 249: 
                case 250: {
                    readOffset = 3;
                    break;
                }
                case 251: {
                    readOffset = 3;
                    break;
                }
                case 252: 
                case 253: 
                case 254: {
                    readOffset = 3;
                    int diffLocals = type - 251;
                    int i = 0;
                    while (i < diffLocals) {
                        readOffset += this.rewriteVerificationInfo(codeToAdjust, offset + readOffset);
                        ++i;
                    }
                    break;
                }
                case 255: {
                    int tempLocals = OTByteCodes.getWord(codeToAdjust, offset + 3);
                    readOffset = 5;
                    if (tempLocals != 0) {
                        int i = 0;
                        while (i < tempLocals) {
                            readOffset += this.rewriteVerificationInfo(codeToAdjust, offset + readOffset);
                            ++i;
                        }
                    }
                    int tempStackItems = OTByteCodes.getWord(codeToAdjust, offset + readOffset);
                    readOffset += 2;
                    if (tempStackItems == 0) break;
                    int i = 0;
                    while (i < tempStackItems) {
                        readOffset += this.rewriteVerificationInfo(codeToAdjust, offset + readOffset);
                        ++i;
                    }
                    break;
                }
                default: {
                    if (type <= 63) {
                        readOffset = 1;
                        break;
                    }
                    if (type > 127) break;
                    readOffset = 1;
                    readOffset += this.rewriteVerificationInfo(codeToAdjust, offset + readOffset);
                }
            }
            offset += readOffset;
            ++j;
        }
    }

    private int rewriteVerificationInfo(byte[] codeToAdjust, int offset) {
        int t = codeToAdjust[offset] & 0xFF;
        int readOffset = 1;
        switch (t) {
            case 7: {
                this.updateCPO(null, codeToAdjust, offset + 1, 2);
                readOffset += 2;
                break;
            }
            case 8: {
                readOffset += 2;
            }
        }
        return readOffset;
    }

    private ConstantPoolObject updateCPO(SourceTypeBinding dstType, byte[] code, int offset, int length) {
        int ref = OTByteCodes.getRef(2, code, offset);
        if (ref != 0) {
            ConstantPoolObject srcCPO = this._reader.readConstantPoolObject(ref, length);
            ConstantPoolObject dstCPO = this._mapper.mapConstantPoolObject(srcCPO);
            this._writer.writeConstantPoolObject(code, offset, length, dstCPO);
            return dstCPO;
        }
        return null;
    }

    public MethodBinding peekConstructorCall(TeamModel teamModel, MethodModel model, LookupEnvironment environment) {
        byte[] bytes = model.getBytes();
        int offset = model.getStructOffset();
        this._reader = new ConstantPoolObjectReader(model, teamModel, environment);
        int codeAttributeOffset = this.findCodeAttribute(bytes, offset);
        int start = codeAttributeOffset + 14;
        int i = 0;
        while (true) {
            byte b_int;
            int length;
            if ((length = OTByteCodes.cpReferenceLength(b_int = bytes[start + i])) != 0) {
                int ref = OTByteCodes.getRef(length, bytes, start + i + 1);
                ConstantPoolObject src_cpo = this._reader.readConstantPoolObject(ref, length);
                if (!src_cpo.isMethod() || !src_cpo.getMethodRef().isConstructor()) {
                    if (src_cpo.isSpecificType(TypeConstants.JAVA_LANG_ERROR)) {
                        try {
                            b_int = bytes[start + i + 4];
                            length = OTByteCodes.cpReferenceLength(b_int);
                            src_cpo = this._reader.readConstantPoolObject(OTByteCodes.getRef(length, bytes, start + i + 5), length);
                            if (src_cpo.getType() == 8 && src_cpo.getString().startsWith("Unresolved compilation problem:")) {
                                model.getBinding().bytecodeMissing = true;
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                    return null;
                }
                return src_cpo.getMethodRef();
            }
            if (OTByteCodes.getAloadPos(b_int, bytes[start + i + 1]) != i && b_int != 1) {
                return null;
            }
            ++i;
        }
    }
}

