/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AND_AND_Expression;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.jdt.internal.compiler.ast.EqualExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.IfStatement;
import org.eclipse.jdt.internal.compiler.ast.InstanceOfExpression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.SingleValueAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.StateMemento;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.TreeNode;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.DependentTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.TThisBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.FieldModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.copyinheritance.CopyInheritance;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstEdit;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.RoleTypeCreator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TypeAnalyzer;

public class StandardElementGenerator {
    private static final String OUTER_THIS_PREFIX = "this$";
    private static final char[] LENGTH = "length".toCharArray();

    @Nullable
    public static MethodBinding createGetTeamMethod(TypeDeclaration roleType) {
        MethodBinding existingMethod = TypeAnalyzer.findMethod(roleType.initializerScope, roleType.binding, IOTConstants._OT_GETTEAM, Binding.NO_PARAMETERS);
        if (existingMethod != null && existingMethod.isValidBinding() && roleType.isInterface() == existingMethod.isAbstract()) {
            return null;
        }
        AstGenerator gen = roleType.baseclass != null ? new AstGenerator(roleType.baseclass.sourceStart, roleType.baseclass.sourceEnd) : new AstGenerator(roleType.sourceStart, roleType.sourceEnd);
        ReferenceBinding teamType = null;
        LookupEnvironment environment = roleType.scope.environment();
        try {
            environment.missingClassFileLocation = roleType;
            teamType = roleType.scope.getOrgObjectteamsITeam();
        }
        finally {
            environment.missingClassFileLocation = null;
        }
        int flags = 1;
        if (roleType.isInterface()) {
            flags |= 0x1000400;
        }
        MethodDeclaration getTeam = gen.method(roleType.compilationResult, flags, teamType, IOTConstants._OT_GETTEAM, null);
        AstEdit.addMethod(roleType, getTeam);
        if ((flags & 0x1000000) == 0) {
            int depth = roleType.binding.depth() - 1;
            getTeam.setStatements(new Statement[]{gen.returnStatement(gen.fieldReference(gen.thisReference(), (OUTER_THIS_PREFIX + depth).toCharArray()))});
            if (StateMemento.hasMethodResolveStarted(roleType.binding)) {
                getTeam.resolveStatements();
            }
        }
        return getTeam.binding;
    }

    public static void createCastMethod(TeamModel teamModel, TypeDeclaration roleType, int dimensions) {
        StandardElementGenerator.getCastMethod(teamModel, roleType.binding, roleType.scope, dimensions, false, roleType.sourceStart, roleType.sourceEnd);
    }

    public static MethodBinding getCastMethod(TeamModel teamModel, ReferenceBinding roleType, Scope scope, int dimensions, boolean searchSuper, int sourceStart, int sourceEnd) {
        boolean shouldWeaken = teamModel.getState() >= 16;
        MethodBinding superMethod = null;
        roleType = roleType.getRealType();
        char[] methodName = CharOperation.concat(IOTConstants.CAST_PREFIX, roleType.sourceName());
        if (dimensions > 0) {
            methodName = CharOperation.concat(methodName, String.valueOf(dimensions).toCharArray(), '$');
        }
        ReferenceBinding teamBinding = teamModel.getBinding();
        while (teamBinding != null) {
            MethodBinding[] methods = teamBinding.getMethods(methodName);
            if (methods != null && methods.length == 1) {
                if (methods[0].declaringClass == teamModel.getBinding() || searchSuper) {
                    return methods[0];
                }
                superMethod = methods[0];
                break;
            }
            if (!searchSuper && !shouldWeaken) break;
            teamBinding = teamBinding.superclass();
        }
        TypeDeclaration teamClass = teamModel.getAst();
        if (teamClass == null) {
            MethodBinding castMethod = new MethodBinding(1, methodName, roleType, new TypeBinding[]{scope.getJavaLangObject()}, null, teamModel.getBinding());
            teamModel.getBinding().addMethod(castMethod);
            return castMethod;
        }
        AstGenerator gen = new AstGenerator(sourceStart, sourceEnd);
        int modifiers = 0;
        boolean clearPrivateModifier = false;
        if (roleType.isPublic()) {
            modifiers = 1;
        } else {
            modifiers = 4;
            clearPrivateModifier = true;
        }
        char[] argName = "_OT$arg".toCharArray();
        ReferenceBinding exprType = teamClass.scope.getJavaLangObject();
        TypeReference exprTypeRef = gen.typeReference(exprType);
        MethodDeclaration castMethod = gen.method(teamClass.compilationResult(), modifiers, gen.createArrayTypeReference(roleType, dimensions), methodName, new Argument[]{gen.argument(argName, exprTypeRef)});
        ReferenceBinding returnType = dimensions == 0 ? roleType : scope.environment().createArrayType(roleType, dimensions);
        castMethod.returnType.resolvedType = RoleTypeCreator.maybeWrapUnqualifiedRoleType(returnType, teamBinding);
        TypeReference arrayCastType = gen.createArrayTypeReference(roleType, dimensions);
        LocalDeclaration castedLocalVar = gen.localVariable(IOTConstants.ROLE, arrayCastType, (Expression)gen.castExpression(gen.singleNameReference(argName), arrayCastType, 2));
        IfStatement nullCheck = gen.ifStatement(gen.nullCheck(gen.singleNameReference(argName)), gen.returnStatement(gen.nullLiteral()));
        BinaryExpression teamCheckCondition = StandardElementGenerator.genTeamCheck(gen, 29, gen.singleNameReference(IOTConstants.ROLE), gen.thisReference(), dimensions);
        if (dimensions > 0) {
            teamCheckCondition = gen.setPos(new AND_AND_Expression(gen.equalExpression(gen.qualifiedNameReference(new char[][]{IOTConstants.ROLE, LENGTH}), gen.intLiteral(0), 6), teamCheckCondition, 0));
        }
        castMethod.setStatements(new Statement[]{nullCheck, castedLocalVar, gen.ifStatement(teamCheckCondition, gen.throwStatement(gen.allocation(gen.qualifiedTypeReference(IOTConstants.ROLE_CAST_EXCEPTION), new Expression[0]))), gen.returnStatement(gen.singleNameReference(IOTConstants.ROLE))});
        castMethod.isGenerated = true;
        AstEdit.addGeneratedMethod(teamClass, castMethod);
        if (clearPrivateModifier) {
            castMethod.binding.tagBits = 512L;
        }
        if (superMethod != null) {
            CopyInheritance.weakenSignature(castMethod, superMethod);
        }
        return castMethod.binding;
    }

    public static boolean isCastToMethod(char[] selector) {
        return CharOperation.prefixEquals(IOTConstants.CAST_PREFIX, selector);
    }

    public static Expression createRoleInstanceOfCheck(BlockScope scope, InstanceOfExpression expr, ReferenceBinding exprType, DependentTypeBinding castType) {
        BinaryExpression teamInstanceComparison;
        AstGenerator gen = new AstGenerator(expr.sourceStart, expr.sourceEnd);
        if (RoleTypeBinding.isRoleWithExplicitAnchor(exprType)) {
            teamInstanceComparison = StandardElementGenerator.createAnchorEqualCheck(scope, (RoleTypeBinding)exprType, castType, expr.sourceStart, expr.sourceEnd);
        } else {
            BinaryExpression teamCheck = StandardElementGenerator.genTeamCheck(gen, 18, gen.resolvedCastExpression(expr.expression, castType.getRealType(), 2), StandardElementGenerator.createTeamAnchorReference(scope, castType, gen), expr.type.dimensions());
            MessageSend msg = (MessageSend)teamCheck.left;
            msg.binding = castType.getMethod(scope, IOTConstants._OT_GETTEAM);
            if (msg.binding == null) {
                msg.binding = new MethodBinding(1, IOTConstants._OT_GETTEAM, scope.getOrgObjectteamsITeam(), Binding.NO_PARAMETERS, Binding.NO_EXCEPTIONS, castType);
                assert (castType.roleModel.isIgnoreFurtherInvestigation());
            }
            msg.actualReceiverType = castType.getRealType();
            msg.constant = Constant.NotAConstant;
            teamCheck.right.constant = Constant.NotAConstant;
            teamCheck.constant = Constant.NotAConstant;
            teamCheck.resolvedType = TypeBinding.BOOLEAN;
            teamInstanceComparison = teamCheck;
        }
        TypeReference castTypeRef = gen.typeReference(castType.getRealType());
        castTypeRef.resolvedType = castType.getRealType();
        castTypeRef.constant = Constant.NotAConstant;
        expr.expression.resolvedType = exprType.getRealClass();
        expr.expression.constant = Constant.NotAConstant;
        InstanceOfExpression origCheckClone = gen.setPos(new InstanceOfExpression(expr.expression, castTypeRef));
        origCheckClone.bits = expr.bits;
        origCheckClone.resolvedType = TypeBinding.BOOLEAN;
        origCheckClone.constant = Constant.NotAConstant;
        AND_AND_Expression andAnd = gen.setPos(new AND_AND_Expression(origCheckClone, teamInstanceComparison, 0));
        andAnd.resolvedType = TypeBinding.BOOLEAN;
        andAnd.constant = Constant.NotAConstant;
        return andAnd;
    }

    private static BinaryExpression genTeamCheck(AstGenerator gen, int operator, Expression providedExpression, Expression expectedTeamExpr, int dimensions) {
        Expression providedLeafExpression;
        if (dimensions == 0) {
            providedLeafExpression = providedExpression;
        } else if (dimensions == 1) {
            providedLeafExpression = gen.arrayReference(providedExpression, 0);
        } else {
            throw new InternalCompilerError("Multidimensional array of roles not supported here");
        }
        MessageSend teamProvidedRef = gen.messageSend(providedLeafExpression, IOTConstants._OT_GETTEAM, null);
        EqualExpression teamCheckCondition = gen.equalExpression(teamProvidedRef, expectedTeamExpr, operator);
        return teamCheckCondition;
    }

    private static EqualExpression createAnchorEqualCheck(BlockScope scope, DependentTypeBinding left, DependentTypeBinding right, int start, int end) {
        AstGenerator gen = new AstGenerator(start, end);
        Expression exprTeam = StandardElementGenerator.createTeamAnchorReference(scope, left, gen);
        Expression castTeam = StandardElementGenerator.createTeamAnchorReference(scope, right, gen);
        EqualExpression teamInstanceComparison = gen.equalExpression(exprTeam, castTeam, 18);
        teamInstanceComparison.constant = Constant.NotAConstant;
        return teamInstanceComparison;
    }

    private static Expression createTeamAnchorReference(BlockScope scope, DependentTypeBinding roleType, AstGenerator gen) {
        Expression teamExpr = StandardElementGenerator.createTeamExpression(roleType, gen);
        teamExpr.resolveType(scope);
        return teamExpr;
    }

    public static Expression createTeamExpression(DependentTypeBinding roleType, AstGenerator gen) {
        return roleType._teamAnchor instanceof TThisBinding ? gen.qualifiedThisReference((ReferenceBinding)roleType._teamAnchor.getResolvedType()) : gen.singleNameReference(roleType._teamAnchor.internalName());
    }

    public static void generatePlayedByElements(RoleModel role, TreeNode boundParentRole) {
        TypeDeclaration roleType = role.getAst();
        ReferenceBinding baseclass = roleType.binding.baseclass();
        if (baseclass != null) {
            if (boundParentRole == null) {
                if (roleType.isInterface()) {
                    StandardElementGenerator.createGetBaseMethod(roleType, baseclass, IOTConstants._OT_GETBASE, 0x1000401);
                } else {
                    StandardElementGenerator.checkCreateBaseField(roleType, baseclass, true);
                    StandardElementGenerator.createGetBaseMethod(role.getInterfaceAst(), baseclass, IOTConstants._OT_GETBASE, 0x1000401);
                    StandardElementGenerator.createGetBaseMethod(roleType, baseclass, IOTConstants._OT_GETBASE, 1);
                }
            } else {
                ReferenceBinding[] superInterfaces;
                ReferenceBinding superBase = boundParentRole.getTreeObject().getBaseTypeBinding();
                if (!superBase.isCompatibleWith(baseclass) && (superInterfaces = roleType.binding.superInterfaces()) != null) {
                    ReferenceBinding[] referenceBindingArray = superInterfaces;
                    int n = superInterfaces.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ReferenceBinding superIfc = referenceBindingArray[n2];
                        if (superIfc.baseclass() != null && !superBase.isCompatibleWith(superIfc.baseclass())) {
                            StandardElementGenerator.createGetBaseMethod(roleType, baseclass, IOTConstants._OT_GETBASE, 1);
                            break;
                        }
                        ++n2;
                    }
                }
            }
            ReferenceBinding interfacePartBinding = role.getInterfacePartBinding();
            char[] baseclassName = role.getBaseclassAttributename(true);
            role.addAttribute(SingleValueAttribute.playedByAttribute(baseclassName));
            if (!role.getBinding().isInterface() && interfacePartBinding != null) {
                interfacePartBinding.roleModel.addAttribute(SingleValueAttribute.playedByAttribute(baseclassName));
            }
        }
    }

    private static void checkCreateFakedStrongBaseField(ReferenceBinding superRole, ReferenceBinding roleClass, ReferenceBinding baseTypeBinding) {
        if (superRole.baseclass == baseTypeBinding) {
            return;
        }
        ReferenceBinding nextSuper = superRole.superclass();
        while (nextSuper.isRole() && nextSuper.roleModel.isBound()) {
            superRole = nextSuper;
            nextSuper = nextSuper.superclass();
        }
        FieldBinding fakeStrongBaseField = new FieldBinding(IOTConstants._OT_BASE, baseTypeBinding, 4113, roleClass, Constant.NotAConstant);
        fakeStrongBaseField.tagBits |= 0x4000000000000000L;
        SourceTypeBinding roleSourceClass = (SourceTypeBinding)roleClass;
        FieldModel model = FieldModel.getModel(fakeStrongBaseField);
        model.actualDeclaringClass = superRole;
        FieldBinding superBaseField = superRole.getField(IOTConstants._OT_BASE, false);
        if (superBaseField != null) {
            fakeStrongBaseField.shareBestName(superBaseField);
        }
        roleSourceClass.addField(fakeStrongBaseField);
    }

    public static void checkCreateBaseField(TypeDeclaration roleType, ReferenceBinding baseclass, boolean createBinding) {
        if (roleType.isInterface()) {
            return;
        }
        if (roleType.fields != null) {
            FieldDeclaration[] fieldDeclarationArray = roleType.fields;
            int n = roleType.fields.length;
            int n2 = 0;
            while (n2 < n) {
                FieldDeclaration field = fieldDeclarationArray[n2];
                if (CharOperation.equals(field.name, IOTConstants._OT_BASE)) {
                    return;
                }
                ++n2;
            }
        }
        AstGenerator gen = roleType.baseclass != null ? new AstGenerator(roleType.baseclass) : new AstGenerator(roleType);
        ReferenceBinding superRole = roleType.binding.superclass;
        if (superRole != null && superRole.isRole() && superRole.roleModel.isBound()) {
            StandardElementGenerator.checkCreateFakedStrongBaseField(superRole, roleType.binding, baseclass);
            return;
        }
        int modifiers = 4113;
        if (roleType.binding.isCompatibleWith(roleType.scope.getOrgObjectteamsIBaseMigratable())) {
            modifiers &= 0xFFFFFFEF;
        }
        FieldDeclaration baseField = gen.field(modifiers, gen.baseclassReference(baseclass), IOTConstants._OT_BASE, null);
        boolean hasTypeProblem = baseclass instanceof MissingTypeBinding;
        AstEdit.addField(roleType, baseField, createBinding, hasTypeProblem, false);
        if (hasTypeProblem) {
            baseField.binding.type = baseclass;
            baseField.binding.modifiers &= 0xFDFFFFFF;
        }
    }

    public static MethodBinding getGetBaseMethod(BlockScope scope, RoleModel roleModel, ReferenceBinding baseType) {
        MethodBinding binding = TypeAnalyzer.findMethod(scope, roleModel.getBinding(), IOTConstants._OT_GETBASE, Binding.NO_PARAMETERS);
        if (binding.isValidBinding()) {
            return binding;
        }
        if (roleModel.getBinding().isBinaryBinding()) {
            scope.problemReporter().abortDueToInternalError("missing internal _OT$getBase() method");
            return binding;
        }
        MethodBinding ifcMethod = StandardElementGenerator.createGetBaseMethod(roleModel.getInterfaceAst(), baseType, IOTConstants._OT_GETBASE, 0x1000401);
        if (roleModel.getClassPartAst() != null) {
            MethodBinding classMethod = StandardElementGenerator.createGetBaseMethod(roleModel.getClassPartAst(), baseType, IOTConstants._OT_GETBASE, 1);
            if (!roleModel.getAst().isInterface()) {
                return classMethod;
            }
        }
        return ifcMethod;
    }

    private static MethodBinding createGetBaseMethod(TypeDeclaration roleType, ReferenceBinding baseType, char[] methodName, int flags) {
        Statement bodyStatement;
        TypeReference baseclassReference;
        if (roleType == null) {
            return null;
        }
        MethodBinding existingMethod = null;
        AbstractMethodDeclaration decl = TypeAnalyzer.findMethodDecl(roleType, methodName, 0);
        if (decl != null) {
            existingMethod = decl.binding;
        }
        if (existingMethod == null) {
            existingMethod = TypeAnalyzer.findMethod(roleType.initializerScope, roleType.binding.superclass(), methodName, Binding.NO_PARAMETERS);
        }
        if (existingMethod != null && existingMethod.isValidBinding() && existingMethod.isAbstract() == roleType.isInterface() && (existingMethod.declaringClass == roleType.binding || existingMethod.returnType.isCompatibleWith(baseType))) {
            return existingMethod;
        }
        AstGenerator gen = roleType.baseclass != null ? new AstGenerator(roleType.baseclass.sourceStart, roleType.baseclass.sourceEnd) : new AstGenerator(roleType.sourceStart, roleType.sourceEnd);
        TypeParameter methodParam = null;
        if (baseType != null) {
            baseclassReference = gen.baseclassReference(baseType);
            bodyStatement = gen.returnStatement(gen.castExpression(gen.singleNameReference(IOTConstants._OT_BASE), baseclassReference, 0));
        } else {
            char[] paramName = "_OT$AnyBase".toCharArray();
            methodParam = gen.baseBoundedTypeParameter(paramName, roleType.binding);
            baseclassReference = gen.singleTypeReference(paramName);
            char[][] ABSTRACT_METHOD = new char[][]{"java".toCharArray(), "lang".toCharArray(), "AbstractMethodError".toCharArray()};
            bodyStatement = gen.throwStatement(gen.allocation(gen.qualifiedTypeReference(ABSTRACT_METHOD), null));
        }
        MethodDeclaration getBase = gen.method(roleType.compilationResult, flags, baseclassReference, methodName, null);
        if (methodParam != null) {
            getBase.typeParameters = new TypeParameter[]{methodParam};
        }
        AstEdit.addMethod(roleType, getBase);
        if (methodParam != null) {
            roleType.getRoleModel().unimplementedGetBase = getBase.binding;
        }
        if ((flags & 0x1000000) == 0) {
            getBase.setStatements(new Statement[]{bodyStatement});
            if (StateMemento.hasMethodResolveStarted(roleType.binding)) {
                getBase.resolveStatements();
            }
        }
        return getBase.binding;
    }

    public static void createGetBaseForUnboundLowerable(RoleModel model) {
        TypeDeclaration interfaceAst = model.getInterfaceAst();
        if (interfaceAst == null || interfaceAst.scope == null) {
            return;
        }
        ClassScope scope = interfaceAst.scope;
        TypeBinding iLowerable = scope.getType(new char[][]{IOTConstants.ORG, IOTConstants.OBJECTTEAMS, IOTConstants.ITEAM, IOTConstants.ILOWERABLE}, 4);
        if (!model.isBound() && model.getBinding().isCompatibleWith(iLowerable)) {
            StandardElementGenerator.createGetBaseMethod(interfaceAst, scope.getJavaLangObject(), IOTConstants._OT_GETBASE, 0x1000401);
        }
    }
}

